/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.matchers;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.WipeableString;
import com.nulabinc.zxcvbn.matchers.BaseMatcher;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class SequenceMatcher
extends BaseMatcher {
    private static final int MAX_CODE_POINT_DIFF = 5;
    private static final int MIN_VALID_SEQUENCE_LENGTH = 1;
    private static final Pattern LOWERCASE_PATTERN = Pattern.compile("^[a-z]+$");
    private static final Pattern UPPERCASE_PATTERN = Pattern.compile("^[A-Z]+$");
    private static final Pattern DIGIT_PATTERN = Pattern.compile("^\\d+$");

    public SequenceMatcher(Context context) {
        super(context);
    }

    @Override
    public List<Match> execute(CharSequence password) {
        ArrayList<Match> matches = new ArrayList<Match>();
        if (password == null || password.length() == 1) {
            return matches;
        }
        int lastCodePointDiff = 0;
        WipeableString wipeable = new WipeableString(password);
        int startIndex = 0;
        for (int curIndex = 1; curIndex < password.length(); ++curIndex) {
            int codePointDiff = wipeable.codePointAt(curIndex) - wipeable.codePointAt(curIndex - 1);
            if (curIndex == 1) {
                lastCodePointDiff = codePointDiff;
            }
            if (codePointDiff == lastCodePointDiff) continue;
            int endIndex = curIndex - 1;
            this.addMatchIfPresent(password, matches, startIndex, endIndex, lastCodePointDiff);
            startIndex = endIndex;
            lastCodePointDiff = codePointDiff;
        }
        wipeable.wipe();
        this.addMatchIfPresent(password, matches, startIndex, password.length() - 1, lastCodePointDiff);
        return matches;
    }

    private Match createSequenceMatch(CharSequence password, int startIndex, int endIndex, int codePointDiff) {
        if (!this.isValidSequenceLength(endIndex, startIndex, codePointDiff) || !this.isValidCodePointDiffValue(codePointDiff)) {
            return null;
        }
        WipeableString token = WipeableString.copy(password, startIndex, endIndex + 1);
        SequenceType sequenceType = this.determineSequenceType(token);
        return MatchFactory.createSequenceMatch(startIndex, endIndex, token, sequenceType.getName(), sequenceType.getSpace(), codePointDiff > 0);
    }

    private boolean isValidSequenceLength(int endIndex, int startIndex, int codePointDiff) {
        return endIndex - startIndex > 1 || Math.abs(codePointDiff) == 1;
    }

    private boolean isValidCodePointDiffValue(int codePointDiff) {
        return Math.abs(codePointDiff) <= 5;
    }

    private SequenceType determineSequenceType(CharSequence token) {
        if (this.isLowercase(token)) {
            return SequenceType.LOWER;
        }
        if (this.isUppercase(token)) {
            return SequenceType.UPPER;
        }
        if (this.isDigits(token)) {
            return SequenceType.DIGITS;
        }
        return SequenceType.UNICODE;
    }

    private boolean isLowercase(CharSequence token) {
        return LOWERCASE_PATTERN.matcher(token).matches();
    }

    private boolean isUppercase(CharSequence token) {
        return UPPERCASE_PATTERN.matcher(token).matches();
    }

    private boolean isDigits(CharSequence token) {
        return DIGIT_PATTERN.matcher(token).matches();
    }

    private void addMatchIfPresent(CharSequence password, List<Match> matches, int startIndex, int endIndex, int codePointDiff) {
        Match match = this.createSequenceMatch(password, startIndex, endIndex, codePointDiff);
        if (match != null) {
            matches.add(match);
        }
    }

    private static enum SequenceType {
        LOWER("lower", 26),
        UPPER("upper", 26),
        DIGITS("digits", 10),
        UNICODE("unicode", 26);

        private final String name;
        private final int space;

        private SequenceType(String name, int space) {
            this.name = name;
            this.space = space;
        }

        public String getName() {
            return this.name;
        }

        public int getSpace() {
            return this.space;
        }
    }
}

