/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.DigestAlgorithm;

public class DigestInput {
    private final DigestAlgorithm digestAlgorithm;
    private final ByteBuffer message;

    protected DigestInput(BuilderImpl builder) {
        this.digestAlgorithm = builder.digestAlgorithm();
        this.message = builder.message();
    }

    public DigestAlgorithm digestAlgorithm() {
        return this.digestAlgorithm;
    }

    public ByteBuffer message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DigestAlgorithm digestAlgorithm;
        protected ByteBuffer message;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DigestInput model) {
            this.digestAlgorithm = model.digestAlgorithm();
            this.message = model.message();
        }

        @Override
        public Builder digestAlgorithm(DigestAlgorithm digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
            return this;
        }

        @Override
        public DigestAlgorithm digestAlgorithm() {
            return this.digestAlgorithm;
        }

        @Override
        public Builder message(ByteBuffer message) {
            this.message = message;
            return this;
        }

        @Override
        public ByteBuffer message() {
            return this.message;
        }

        @Override
        public DigestInput build() {
            if (Objects.isNull((Object)this.digestAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `digestAlgorithm`");
            }
            if (Objects.isNull(this.message())) {
                throw new IllegalArgumentException("Missing value for required field `message`");
            }
            return new DigestInput(this);
        }
    }

    public static interface Builder {
        public Builder digestAlgorithm(DigestAlgorithm var1);

        public DigestAlgorithm digestAlgorithm();

        public Builder message(ByteBuffer var1);

        public ByteBuffer message();

        public DigestInput build();
    }
}

