"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.geometries = void 0;
var __1 = require("../../..");
var constants_1 = require("../../../../specs/constants");
var create_selector_1 = require("../../../../state/create_selector");
var get_settings_specs_1 = require("../../../../state/selectors/get_settings_specs");
var utils_1 = require("../../../../state/utils");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var scenegraph_1 = require("./scenegraph");
var getParentDimensions = function (state) { return state.parentDimensions; };
exports.geometries = create_selector_1.createCustomCachedSelector([get_settings_specs_1.getSpecs, getParentDimensions], function (specs, parentDimensions) {
    var goalSpecs = utils_1.getSpecsFromStore(specs, __1.ChartType.Goal, constants_1.SpecType.Series);
    return goalSpecs.length === 1 ? scenegraph_1.render(goalSpecs[0], parentDimensions) : viewmodel_types_1.nullShapeViewModel();
});
//# sourceMappingURL=geometries.js.map