/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.system;

import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.NonFallbackCalciteException;
import org.opensearch.sql.monitor.ResourceMonitor;
import org.opensearch.sql.opensearch.request.system.OpenSearchSystemRequest;

public class OpenSearchSystemIndexEnumerator
implements Enumerator<Object> {
    private static final long NUMBER_OF_NEXT_CALL_TO_CHECK = 1000L;
    private final List<String> fields;
    private final OpenSearchSystemRequest request;
    private Iterator<ExprValue> iterator;
    private ExprValue current;
    private Integer queryCount;
    private final ResourceMonitor monitor;

    public OpenSearchSystemIndexEnumerator(List<String> fields, OpenSearchSystemRequest request, ResourceMonitor monitor) {
        this.fields = fields;
        this.request = request;
        this.monitor = monitor;
        this.queryCount = 0;
        this.current = null;
        if (!this.monitor.isHealthy()) {
            throw new NonFallbackCalciteException("insufficient resources to run the query, quit.");
        }
        this.iterator = request.search().iterator();
    }

    public Object current() {
        return this.fields.stream().map(k -> this.current.tupleValue().getOrDefault(k, ExprNullValue.of()).valueForCalcite()).toArray();
    }

    public boolean moveNext() {
        boolean shouldCheck;
        boolean bl = shouldCheck = (long)this.queryCount.intValue() % 1000L == 0L;
        if (shouldCheck && !this.monitor.isHealthy()) {
            throw new NonFallbackCalciteException("insufficient resources to load next row, quit.");
        }
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            Integer n = this.queryCount;
            this.queryCount = this.queryCount + 1;
            return true;
        }
        return false;
    }

    public void reset() {
        this.iterator = this.request.search().iterator();
        this.queryCount = 0;
        this.current = null;
    }

    public void close() {
        this.iterator = null;
        this.current = null;
    }
}

