/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.admin.cluster.remotestore.metadata.RemoteStoreMetadataRequest;
import org.opensearch.action.admin.cluster.remotestore.metadata.RemoteStoreMetadataResponse;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestRemoteStoreMetadataAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_remotestore/metadata/{index}"), new RestHandler.Route(RestRequest.Method.GET, "/_remotestore/metadata/{index}/{shard_id}")));
    }

    @Override
    public String getName() {
        return "remote_store_metadata";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String index = request.param("index");
        String shardId = request.param("shard_id");
        RemoteStoreMetadataRequest metadataRequest = new RemoteStoreMetadataRequest();
        if (index != null) {
            metadataRequest.indices(new String[]{index});
        }
        if (shardId != null) {
            metadataRequest.shards(shardId);
        }
        return channel -> client.admin().cluster().remoteStoreMetadata(metadataRequest, new RestToXContentListener<RemoteStoreMetadataResponse>((RestChannel)channel));
    }
}

