/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.validators;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.logging.Logger;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.keycloak.saml.validators.ConditionsValidator;
import org.keycloak.saml.validators.DestinationValidator;

public class SubjectConfirmationDataValidator {
    private static final Logger logger = Logger.getLogger(SubjectConfirmationDataValidator.class);
    private final SubjectConfirmationDataType subjectConfirmationData;
    private final String inResponseTo;
    private final int clockSkewInMillis;
    private final String assertionId;
    private final XMLGregorianCalendar now = XMLTimeUtil.getIssueInstant();
    private final Set<String> allowedRecipients;
    private final DestinationValidator destinationValidator;

    private SubjectConfirmationDataValidator(String assertionId, SubjectConfirmationDataType subjectConfirmationData, String inResponseTo, int clockSkewInMillis, Set<String> allowedRecipients, DestinationValidator destinationValidator) {
        this.assertionId = assertionId;
        this.subjectConfirmationData = subjectConfirmationData;
        this.inResponseTo = inResponseTo;
        this.clockSkewInMillis = clockSkewInMillis;
        this.allowedRecipients = allowedRecipients;
        this.destinationValidator = destinationValidator;
    }

    public boolean isValid() {
        if (this.subjectConfirmationData == null) {
            return true;
        }
        if (!ConditionsValidator.validateExpiration(this.assertionId, this.subjectConfirmationData.getNotBefore(), this.subjectConfirmationData.getNotOnOrAfter(), this.now, this.clockSkewInMillis)) {
            return false;
        }
        if (!this.validateRecipient()) {
            return false;
        }
        return this.validateInResponseTo();
    }

    private boolean validateRecipient() {
        if (this.subjectConfirmationData.getRecipient() == null || this.allowedRecipients.isEmpty()) {
            return true;
        }
        for (String allowedRecipient : this.allowedRecipients) {
            if (!this.destinationValidator.validate(this.subjectConfirmationData.getRecipient(), allowedRecipient)) continue;
            return true;
        }
        logger.tracef("Response Validation Error: SubjectConfirmationData invalid recipient '%s', not in %s", (Object)this.subjectConfirmationData.getRecipient(), this.allowedRecipients);
        return false;
    }

    private boolean validateInResponseTo() {
        if (this.inResponseTo == null || this.subjectConfirmationData.getInResponseTo() == null) {
            return true;
        }
        if (this.subjectConfirmationData.getInResponseTo().equals(this.inResponseTo)) {
            return true;
        }
        logger.tracef("Response Validation Error: received SubjectConfirmationData InResponseTo '%s' does not match the expected request ID '%s'", (Object)this.subjectConfirmationData.getInResponseTo(), (Object)this.inResponseTo);
        return false;
    }

    public static class Builder {
        private final String assertionId;
        private final SubjectConfirmationDataType subjectConfirmationData;
        private final DestinationValidator destinationValidator;
        private int clockSkewInMillis = 0;
        private final Set<String> allowedRecipients = new HashSet<String>();
        private String inResponseTo;

        public Builder(String assertionId, SubjectConfirmationDataType subjectConfirmationData, DestinationValidator destinationValidator) {
            this.assertionId = assertionId;
            this.subjectConfirmationData = subjectConfirmationData;
            this.destinationValidator = destinationValidator;
        }

        public Builder inResponseTo(String inResponseTo) {
            this.inResponseTo = inResponseTo;
            return this;
        }

        public Builder clockSkewInMillis(int clockSkewInMillis) {
            this.clockSkewInMillis = clockSkewInMillis;
            return this;
        }

        public Builder allowedRecipient(String ... allowedRecipients) {
            this.allowedRecipients.addAll(Arrays.asList(allowedRecipients));
            return this;
        }

        public SubjectConfirmationDataValidator build() {
            return new SubjectConfirmationDataValidator(this.assertionId, this.subjectConfirmationData, this.inResponseTo, this.clockSkewInMillis, this.allowedRecipients, this.destinationValidator);
        }
    }
}

