/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Objects;
import org.keycloak.models.jpa.entities.RoleEntity;

@Entity
@Table(name="COMPOSITE_ROLE")
@NamedQueries(value={@NamedQuery(name="deleteRoleFromComposites", query="delete CompositeRoleEntity c where c.parentRole = :role or c.childRole = :role"), @NamedQuery(name="deleteSingleCompositeFromRole", query="delete CompositeRoleEntity c where c.parentRole = :parentRole and c.childRole = :childRole")})
@IdClass(value=Key.class)
public class CompositeRoleEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="COMPOSITE")
    private RoleEntity parentRole;
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CHILD_ROLE")
    private RoleEntity childRole;

    public CompositeRoleEntity() {
    }

    public CompositeRoleEntity(RoleEntity parentRole, RoleEntity childRole) {
        this.parentRole = parentRole;
        this.childRole = childRole;
    }

    public RoleEntity getParentRole() {
        return this.parentRole;
    }

    public void setParentRole(RoleEntity parentRole) {
        this.parentRole = parentRole;
    }

    public RoleEntity getChildRole() {
        return this.childRole;
    }

    public void setChildRole(RoleEntity childRole) {
        this.childRole = childRole;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof CompositeRoleEntity)) {
            return false;
        }
        CompositeRoleEntity that = (CompositeRoleEntity)o;
        return this.parentRole.equals(that.parentRole) && this.childRole.equals(that.childRole);
    }

    public int hashCode() {
        return Objects.hash(this.childRole, this.parentRole);
    }

    public static class Key
    implements Serializable {
        private RoleEntity childRole;
        private RoleEntity parentRole;

        public Key() {
        }

        public Key(RoleEntity parentRole, RoleEntity childRole) {
            this.childRole = childRole;
            this.parentRole = parentRole;
        }

        public RoleEntity getChildRole() {
            return this.childRole;
        }

        public void setChildRole(RoleEntity childRole) {
            this.childRole = childRole;
        }

        public RoleEntity getParentRole() {
            return this.parentRole;
        }

        public void setParentRole(RoleEntity parentRole) {
            this.parentRole = parentRole;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.childRole, key.childRole) && Objects.equals(this.parentRole, key.parentRole);
        }

        public int hashCode() {
            return Objects.hash(this.childRole, this.parentRole);
        }
    }
}

