/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.entities.CompositeRoleEntity;
import org.keycloak.models.jpa.entities.RoleAttributeEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.utils.StreamsUtil;

public class RoleAdapter
implements RoleModel,
JpaModel<RoleEntity> {
    protected RoleEntity role;
    protected EntityManager em;
    protected RealmModel realm;
    protected KeycloakSession session;

    public RoleAdapter(KeycloakSession session, RealmModel realm, EntityManager em, RoleEntity role) {
        this.em = em;
        this.realm = realm;
        this.role = role;
        this.session = session;
    }

    @Override
    public RoleEntity getEntity() {
        return this.role;
    }

    public void setRole(RoleEntity role) {
        this.role = role;
    }

    public String getName() {
        return this.role.getName();
    }

    public String getDescription() {
        return this.role.getDescription();
    }

    public void setDescription(String description) {
        this.role.setDescription(description);
    }

    public String getId() {
        return this.role.getId();
    }

    public void setName(String name) {
        this.role.setName(name);
    }

    public boolean isComposite() {
        return this.getChildRoles().findAny().isPresent();
    }

    public void addCompositeRole(RoleModel role) {
        if (this.em.find(CompositeRoleEntity.class, (Object)new CompositeRoleEntity.Key(this.getEntity(), this.toRoleEntity(role))) == null) {
            CompositeRoleEntity compositeRoleEntity = new CompositeRoleEntity(this.getEntity(), this.toRoleEntity(role));
            this.em.persist((Object)compositeRoleEntity);
        }
    }

    public void removeCompositeRole(RoleModel role) {
        RoleEntity child = this.toRoleEntity(role);
        this.em.createNamedQuery("deleteSingleCompositeFromRole").setParameter("parentRole", (Object)this.getEntity()).setParameter("childRole", (Object)child).executeUpdate();
    }

    public Stream<RoleModel> getCompositesStream() {
        Stream<RoleModel> composites = this.getChildRoles().map(c -> new RoleAdapter(this.session, this.realm, this.em, (RoleEntity)c));
        return composites.filter(Objects::nonNull);
    }

    private Stream<RoleEntity> getChildRoles() {
        return StreamsUtil.closing((Stream)this.em.createNamedQuery("getChildRoles", RoleEntity.class).setParameter("parentRoleId", (Object)this.getId()).getResultStream());
    }

    public Stream<RoleModel> getCompositesStream(String search, Integer first, Integer max) {
        return this.session.roles().getRolesStream(this.realm, this.getChildRoles().map(RoleEntity::getId), search, first, max);
    }

    public boolean hasRole(RoleModel role) {
        return this.equals(role) || KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, new HashSet());
    }

    private void persistAttributeValue(String name, String value) {
        RoleAttributeEntity attr = new RoleAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setRole(this.role);
        this.em.persist((Object)attr);
        this.role.getAttributes().add(attr);
    }

    public void setSingleAttribute(String name, String value) {
        this.setAttribute(name, Collections.singletonList(value));
    }

    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            this.persistAttributeValue(name, value);
        }
    }

    public void removeAttribute(String name) {
        List<RoleAttributeEntity> attributes = this.role.getAttributes();
        Query query = this.em.createNamedQuery("deleteRoleAttributesByNameAndUser");
        query.setParameter("name", (Object)name);
        query.setParameter("roleId", (Object)this.role.getId());
        query.executeUpdate();
        attributes.removeIf(attribute -> attribute.getName().equals(name));
    }

    public Stream<String> getAttributeStream(String name) {
        return this.role.getAttributes().stream().filter(a -> Objects.equals(a.getName(), name)).map(RoleAttributeEntity::getValue);
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (RoleAttributeEntity attribute : this.role.getAttributes()) {
            map.computeIfAbsent(attribute.getName(), name -> new ArrayList()).add(attribute.getValue());
        }
        return map;
    }

    public boolean isClientRole() {
        return this.role.isClientRole();
    }

    public String getContainerId() {
        return this.isClientRole() ? this.role.getClientId() : this.role.getRealmId();
    }

    public RoleContainerModel getContainer() {
        return this.isClientRole() ? this.realm.getClientById(this.role.getClientId()) : this.realm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RoleModel)) {
            return false;
        }
        RoleModel that = (RoleModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private RoleEntity toRoleEntity(RoleModel model) {
        if (model instanceof RoleAdapter) {
            return ((RoleAdapter)model).getEntity();
        }
        return (RoleEntity)this.em.getReference(RoleEntity.class, (Object)model.getId());
    }
}

