/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jdbc.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.transaction.spi.IsolationDelegate;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;

public final class JdbcIsolationDelegate
implements IsolationDelegate {
    private final JdbcConnectionAccess connectionAccess;
    private final SqlExceptionHelper sqlExceptionHelper;

    public JdbcIsolationDelegate(TransactionCoordinatorOwner transactionCoordinatorOwner) {
        this(transactionCoordinatorOwner.getJdbcSessionOwner());
    }

    public JdbcIsolationDelegate(JdbcSessionOwner jdbcSessionOwner) {
        this(jdbcSessionOwner.getJdbcConnectionAccess(), jdbcSessionOwner.getSqlExceptionHelper());
    }

    public JdbcIsolationDelegate(JdbcConnectionAccess connectionAccess, SqlExceptionHelper sqlExceptionHelper) {
        this.connectionAccess = connectionAccess;
        this.sqlExceptionHelper = sqlExceptionHelper;
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T delegateWork(WorkExecutorVisitable<T> work, boolean transacted) throws HibernateException {
        Connection connection;
        try {
            connection = this.connectionAccess.obtainConnection();
        }
        catch (SQLException sqle) {
            throw this.sqlExceptionHelper.convert(sqle, "Unable to obtain isolated JDBC connection");
        }
        try {
            T sqle2222;
            boolean wasAutoCommit;
            try {
                wasAutoCommit = JdbcIsolationDelegate.disableAutoCommit(transacted, connection);
            }
            catch (SQLException sqle2222) {
                throw this.sqlExceptionHelper.convert(sqle2222, "Unable to manage autocommit on isolated JDBC connection");
            }
            try {
                sqle2222 = JdbcIsolationDelegate.doWorkAndCommit(work, transacted, connection);
            }
            catch (Exception exception) {
                JdbcIsolationDelegate.rollBack(transacted, connection, exception);
                if (exception instanceof HibernateException) {
                    HibernateException he = (HibernateException)((Object)exception);
                    throw he;
                }
                if (exception instanceof SQLException) {
                    SQLException sqle3 = (SQLException)exception;
                    throw this.sqlExceptionHelper.convert(sqle3, "Error performing isolated work");
                }
                throw new HibernateException("Error performing isolated work", exception);
            }
            finally {
                JdbcIsolationDelegate.resetAutoCommit(transacted, wasAutoCommit, connection);
            }
            return sqle2222;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    private static <T> T doWorkAndCommit(WorkExecutorVisitable<T> work, boolean transacted, Connection connection) throws SQLException {
        T result = work.accept(new WorkExecutor(), connection);
        if (transacted) {
            connection.commit();
        }
        return result;
    }

    private void releaseConnection(Connection connection) {
        try {
            this.connectionAccess.releaseConnection(connection);
        }
        catch (Exception exception) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.unableToReleaseIsolatedConnection(exception);
        }
    }

    private static void rollBack(boolean transacted, Connection connection, Exception original) {
        try {
            if (transacted && !connection.isClosed()) {
                connection.rollback();
            }
        }
        catch (Exception exception) {
            JdbcLogging.JDBC_MESSAGE_LOGGER.unableToRollBackIsolatedConnection(exception);
            original.addSuppressed(exception);
        }
    }

    private static void resetAutoCommit(boolean transacted, boolean wasAutoCommit, Connection connection) {
        if (transacted && wasAutoCommit) {
            try {
                connection.setAutoCommit(true);
            }
            catch (Exception exception) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.unableToResetAutoCommitEnabled(exception);
            }
        }
    }

    private static boolean disableAutoCommit(boolean transacted, Connection connection) throws SQLException {
        if (transacted) {
            boolean wasAutoCommit = connection.getAutoCommit();
            if (wasAutoCommit) {
                connection.setAutoCommit(false);
            }
            return wasAutoCommit;
        }
        return false;
    }

    @Override
    public <T> T delegateCallable(Callable<T> callable, boolean transacted) throws HibernateException {
        try {
            return callable.call();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new HibernateException(exception);
        }
    }
}

