/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.commons.classloading;

public final class ClassLoaderHelper {
    private static final String JAVA = "java.";
    private static final String JDK_INTERNAL = "jdk.internal.";
    private static final String SUN_MISC = "sun.misc.";
    private static final String CLASS_SUFFIX = ".class";

    private ClassLoaderHelper() {
    }

    public static String fromClassNameToResourceName(String className) {
        return className.replace('.', '/').concat(CLASS_SUFFIX);
    }

    public static String fromResourceNameToClassName(String resourceName) {
        if (!resourceName.endsWith(CLASS_SUFFIX)) {
            throw new IllegalArgumentException(String.format("%s is not a valid resource name as it doesn't end with .class", resourceName));
        }
        return resourceName.substring(0, resourceName.length() - CLASS_SUFFIX.length()).replace('/', '.');
    }

    public static boolean isInJdkPackage(String name) {
        return name.startsWith(JAVA) || name.startsWith(JDK_INTERNAL) || name.startsWith(SUN_MISC);
    }
}

