/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import java.util.Vector;
import org.linuxsampler.lscp.Driver;
import org.linuxsampler.lscp.Parameter;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;

public abstract class AbstractDriver
implements Driver,
Parseable {
    private String name = null;
    private String desc = null;
    private String ver = null;
    private String[] prmNames = null;
    private final Vector<Parameter> prmList = new Vector();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getVersion() {
        return this.ver;
    }

    public void addParameter(Parameter parameter) {
        this.prmList.add(parameter);
    }

    @Override
    public Parameter[] getParameters() {
        return this.prmList.toArray(new Parameter[this.prmList.size()]);
    }

    @Override
    public String[] getParameterNames() {
        return this.prmNames;
    }

    @Override
    public boolean parse(String string) {
        if (string.startsWith("DESCRIPTION: ")) {
            this.desc = string.substring("DESCRIPTION: ".length(), string.length());
        } else if (string.startsWith("VERSION: ")) {
            this.ver = string.substring("VERSION: ".length(), string.length());
        } else if (string.startsWith("PARAMETERS: ")) {
            string = string.substring("PARAMETERS: ".length(), string.length());
            this.prmNames = Parser.parseList(string);
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

