/*
 * Copyright (C) 2022 Intel Corporation
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them
 * is governed by the express license under which they were provided to you ("License"). Unless
 * the License provides otherwise, you may not use, modify, copy, publish, distribute, disclose
 * or transmit this software or the related documents without Intel's prior written permission.
 *
 * This software and the related documents are provided as is, with no express or implied
 * warranties, other than those that are expressly stated in the License.
*/

__kernel void GlobalAdd7(__global float *pa, int size)
{
    const int id = (get_global_id(0)%128);

    float a = 1.f;

    for (int count = 0; count < 128; count++)
    {
        int index = (id + count) & 127;
        // stride 131072 floats
        index <<= 17;
        a += pa[index];
    }

    if (!a)
    {
        pa[id]=size;
    }
}
