/*******************************************************************************
* Copyright (C) 2001 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
 *
 *  Content:
 *            Usage example for pack/unpack service VM functions
 *
 *******************************************************************************/

#include <stdio.h>

#include "mkl.h"

/* Vector length */
#define LEN 10

void own_vspacki ()
{
  float fA[LEN],fB1[LEN];
  MKL_INT i=0,vec_len=LEN,incra=3;
  for(i=0;i<vec_len;i++) {    fA[i]=(float)i+1.0f;    fB1[i]=0.0f;  }

  vec_len=vec_len/incra+1;
  vsPackI(vec_len,fA,incra,fB1);

  fprintf(stdout, "\tvsPackI:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1f%16.1f\n",fA[i],fB1[i]);  }
}

void own_vspackm ()
{
  float fA[LEN],fB1[LEN];
  MKL_INT i=0,vec_len=LEN,ma[LEN];
  for(i=0;i<vec_len;i++) {    fA[i]=(float)i+1.0f;    fB1[i]=0.0f;    ma[i]=i&1;  }

  vsPackM(vec_len,fA,ma,fB1);

  fprintf(stdout, "\tvsPackM:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1f%16.1f\n",fA[i],fB1[i]);  }
}

void own_vspackv ()
{
  float fA[LEN],fB1[LEN];
  MKL_INT i=0,vec_len=LEN,ia[LEN];

  for(i=0;i<vec_len;i++) {    fA[i]=(float)i+1.0f;    fB1[i]=0.0f;    ia[i]=vec_len-i-1;  }

  vsPackV(vec_len,fA,ia,fB1);

  fprintf(stdout, "\tvsPackV:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1f%16.1f\n",fA[i],fB1[i]);  }
}

void own_vsunpacki ()
{
  float fA[LEN],fB1[LEN],fB2[LEN];
  MKL_INT i=0,vec_len=LEN,incra=3;
  for(i=0;i<vec_len;i++) {    fA[i]=(float)i+1.0f;    fB1[i]=0.0f;    fB2[i]=0.0f;  }

  vec_len=vec_len/incra+1;
  vsPackI(vec_len,fA,incra,fB1);
  vsUnpackI(vec_len,fB1,fB2,incra);

  fprintf(stdout, "\tvsUnpackI:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1f%16.1f%16.1f\n",fA[i],fB1[i],fB2[i]);  }
}

void own_vsunpackm ()
{
  float fA[LEN],fB1[LEN],fB2[LEN];
  MKL_INT i=0,vec_len=LEN,ma[LEN];
  for(i=0;i<vec_len;i++) {    fA[i]=(float)i+1.0f;    fB1[i]=0.0f;    fB2[i]=0.0f;    ma[i]=i&1;  }

  vsPackM(vec_len,fA,ma,fB1);
  vsUnpackM(vec_len,fB1,fB2,ma);

  fprintf(stdout, "\tvsUnpackM:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1f%16.1f%16.1f\n",fA[i],fB1[i],fB2[i]);  }
}

void own_vsunpackv ()
{
  float fA[LEN],fB1[LEN],fB2[LEN];
  MKL_INT i=0,vec_len=LEN,ia[LEN];
  for(i=0;i<vec_len;i++) {    fA[i]=(float)i+1.0f;    fB1[i]=0.0f;    fB2[i]=0.0f;    ia[i]=vec_len-i-1;  }

  vsPackV(vec_len,fA,ia,fB1);
  vsUnpackV(vec_len,fB1,fB2,ia);

  fprintf(stdout, "\tvsUnpackV:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1f%16.1f%16.1f\n",fA[i],fB1[i],fB2[i]);  }
}

void own_vdpacki ()
{
  double dA[LEN],dB1[LEN];
  MKL_INT i=0,vec_len=LEN,incra=3;
  for(i=0;i<vec_len;i++) { dA[i]=(double)i+1.0;  dB1[i]=0.0;  }

  vec_len=vec_len/incra+1;
  vdPackI(vec_len,dA,incra,dB1);

  fprintf(stdout, "\tvdPackI:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1lf%16.1lf\n",dA[i],dB1[i]);  }
}

void own_vdpackm ()
{
  double dA[LEN],dB1[LEN];
  MKL_INT i=0,vec_len=LEN,ma[LEN];
  for(i=0;i<vec_len;i++) {    dA[i]=(double)i+1.0;    dB1[i]=0.0;    ma[i]=i&1;  }

  vdPackM(vec_len,dA,ma,dB1);

  fprintf(stdout, "\tvdPackM:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1lf%16.1lf\n",dA[i],dB1[i]);  }
}

void own_vdpackv ()
{
  double dA[LEN],dB1[LEN];
  MKL_INT i=0,vec_len=LEN,ia[LEN];
  for(i=0;i<vec_len;i++) {    dA[i]=(double)i+1.0;    dB1[i]=0.0;    ia[i]=vec_len-i-1;  }

  vdPackV(vec_len,dA,ia,dB1);

  fprintf(stdout, "\tvdPackV:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1lf%16.1lf\n",dA[i],dB1[i]);  }
}

void own_vdunpacki()
{
  double dA[LEN],dB1[LEN],dB2[LEN];
  MKL_INT i=0,vec_len=LEN,incra=3;

  for(i=0;i<vec_len;i++) {    dA[i]=(double)i+1.0;    dB1[i]=0.0;    dB2[i]=0.0;  }

  vec_len=vec_len/incra+1;
  vdPackI(vec_len,dA,incra,dB1);
  vdUnpackI(vec_len,dB1,dB2,incra);

  fprintf(stdout, "\tvdUnpackI:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1lf%16.1lf%16.1lf\n",dA[i],dB1[i],dB2[i]);  }
}

void own_vdunpackm ()
{
  double dA[LEN],dB1[LEN],dB2[LEN];
  MKL_INT i=0,vec_len=LEN,ma[LEN];
  for(i=0;i<vec_len;i++) {    dA[i]=(double)i+1.0;    dB1[i]=0.0;    dB2[i]=0.0;    ma[i]=i&1;  }

  vdPackM(vec_len,dA,ma,dB1);
  vdUnpackM(vec_len,dB1,dB2,ma);

  fprintf(stdout, "\tvdUnpackM:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1lf%16.1lf%16.1lf\n",dA[i],dB1[i],dB2[i]);  }
}

void own_vdunpackv ()
{
  double dA[LEN],dB1[LEN],dB2[LEN];
  MKL_INT i=0,vec_len=LEN,ia[LEN];
  for(i=0;i<vec_len;i++) {    dA[i]=(double)i+1.0;    dB1[i]=0.0;    dB2[i]=0.0;    ia[i]=vec_len-i-1;  }

  vdPackV(vec_len,dA,ia,dB1);
  vdUnpackV(vec_len,dB1,dB2,ia);

  fprintf(stdout, "\tvdUnpackV:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t%16.1lf%16.1lf%16.1lf\n",dA[i],dB1[i],dB2[i]);  }
}

void own_vcpacki ()
{
  MKL_Complex8 cA[LEN],cB1[LEN];
  MKL_INT i=0,vec_len=LEN,incra=3;
  for(i=0;i<vec_len;i++) {    cA[i].real=(float)i+1.0f; cA[i].imag=(float)i+1.0f;    cB1[i].real=0.0f; cB1[i].imag=0.0f;  }

  vec_len=vec_len/incra+1;
  vcPackI(vec_len,cA,incra,cB1);

  fprintf(stdout, "\tvcPackI:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1f + i*%-5.1f %5.1f + i*%-5.1f\n",cA[i].real,cA[i].imag,cB1[i].real,cB1[i].imag);  }
}

void own_vcpackm ()
{
  MKL_Complex8 cA[LEN],cB1[LEN];
  MKL_INT i=0,vec_len=LEN,ma[LEN];
  for(i=0;i<vec_len;i++) {    cA[i].real=(float)i+1.0f; cA[i].imag=(float)i+1.0f;    cB1[i].real=0.0f; cB1[i].imag=0.0f;    ma[i]=i&1;  }

  vcPackM(vec_len,cA,ma,cB1);

  fprintf(stdout, "\tvcPackM:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1f + i*%-5.1f %5.1f + i*%-5.1f\n",cA[i].real,cA[i].imag,cB1[i].real,cB1[i].imag);  }
}

void own_vcpackv ()
{
  MKL_Complex8 cA[LEN],cB1[LEN];
  MKL_INT i=0,vec_len=LEN,ia[LEN];
  for(i=0;i<vec_len;i++) {    cA[i].real=(float)i+1.0f; cA[i].imag=(float)i+1.0f;    cB1[i].real=0.0f; cB1[i].imag=0.0f;    ia[i]=vec_len-i-1;  }

  vcPackV(vec_len,cA,ia,cB1);

  fprintf(stdout, "\tvcPackV:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1f + i*%-5.1f %5.1f + i*%-5.1f\n",cA[i].real,cA[i].imag,cB1[i].real,cB1[i].imag);  }
}

void own_vcunpacki ()
{
  MKL_Complex8 cA[LEN],cB1[LEN],cB2[LEN];
  MKL_INT i=0,vec_len=LEN,incra=3;
  for(i=0;i<vec_len;i++) {    cA[i].real=(float)i+1.0f; cA[i].imag=(float)i+1.0f;    cB1[i].real=0.0f; cB1[i].imag=0.0f;    cB2[i].real=0.0f; cB2[i].imag=0.0f;  }

  vec_len=vec_len/incra+1;
  vcPackI(vec_len,cA,incra,cB1);
  vcUnpackI(vec_len,cB1,cB2,incra);

  fprintf(stdout, "\tvcUnpackI:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1f + i*%-5.1f %5.1f + i*%-5.1f %5.1f + i*%-5.1f\n",cA[i].real,cA[i].imag,cB1[i].real,cB1[i].imag,cB2[i].real,cB2[i].imag);  }
}

void own_vcunpackm()
{
  MKL_Complex8 cA[LEN],cB1[LEN],cB2[LEN];
  MKL_INT i=0,vec_len=LEN,ma[LEN];
  for(i=0;i<vec_len;i++) {    cA[i].real=(float)i+1.0f; cA[i].imag=(float)i+1.0f;    cB1[i].real=0.0f; cB1[i].imag=0.0f;    cB2[i].real=0.0f; cB2[i].imag=0.0f;    ma[i]=i&1;  }

  vcPackM(vec_len,cA,ma,cB1);
  vcUnpackM(vec_len,cB1,cB2,ma);

  fprintf(stdout, "\tvcUnpackM:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1f + i*%-5.1f %5.1f + i*%-5.1f %5.1f + i*%-5.1f\n",cA[i].real,cA[i].imag,cB1[i].real,cB1[i].imag,cB2[i].real,cB2[i].imag);  }
}

void own_vcunpackv ()
{
  MKL_Complex8 cA[LEN],cB1[LEN],cB2[LEN];
  MKL_INT i=0,vec_len=LEN,ia[LEN];
  for(i=0;i<vec_len;i++) {    cA[i].real=(float)i+1.0f; cA[i].imag=(float)i+1.0f;    cB1[i].real=0.0f; cB1[i].imag=0.0f;    cB2[i].real=0.0f; cB2[i].imag=0.0f;    ia[i]=vec_len-i-1;  }

  vcPackV(vec_len,cA,ia,cB1);
  vcUnpackV(vec_len,cB1,cB2,ia);

  fprintf(stdout, "\tvcUnpackV:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1f + i*%-5.1f %5.1f + i*%-5.1f %5.1f + i*%-5.1f\n",cA[i].real,cA[i].imag,cB1[i].real,cB1[i].imag,cB2[i].real,cB2[i].imag);  }
}

void own_vzpacki ()
{
  MKL_Complex16 zA[LEN],zB1[LEN];
  MKL_INT i=0,vec_len=LEN,incra=3;
  for(i=0;i<vec_len;i++) {    zA[i].real=(double)i+1.0; zA[i].imag=(double)i+1.1;    zB1[i].real=0.0; zB1[i].imag=0.0;  }

  vec_len=vec_len/incra+1;
  vzPackI(vec_len,zA,incra,zB1);

  fprintf(stdout, "\tvzPackI:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf\n",zA[i].real,zA[i].imag,zB1[i].real,zB1[i].imag);  }
}

void own_vzpackm ()
{
  MKL_Complex16 zA[LEN],zB1[LEN];
  MKL_INT i=0,vec_len=LEN,ma[LEN];
  for(i=0;i<vec_len;i++) {    zA[i].real=(double)i+1.0; zA[i].imag=(double)i+1.0;    zB1[i].real=0.0; zB1[i].imag=0.0;    ma[i]=i&1;  }

  vzPackM(vec_len,zA,ma,zB1);

  fprintf(stdout, "\tvzPackM:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf\n",zA[i].real,zA[i].imag,zB1[i].real,zB1[i].imag);  }
}

void own_vzpackv ()
{
  MKL_Complex16 zA[LEN],zB1[LEN];
  MKL_INT i=0,vec_len=LEN,ia[LEN];
  for(i=0;i<vec_len;i++) {    zA[i].real=(double)i+1.0; zA[i].imag=(double)i+1.0;    zB1[i].real=0.0; zB1[i].imag=0.0;    ia[i]=vec_len-i-1;  }

  vzPackV(vec_len,zA,ia,zB1);

  fprintf(stdout, "\tvzPackV:\n");
  fprintf(stdout, "\t\t%16s%16s\n","Before packing","After packing");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf\n",zA[i].real,zA[i].imag,zB1[i].real,zB1[i].imag);  }
}

void own_vzunpacki ()
{
  MKL_Complex16 zA[LEN],zB1[LEN],zB2[LEN];
  MKL_INT i=0,vec_len=LEN,incra=3;
  for(i=0;i<vec_len;i++) {    zA[i].real=(double)i+1.0; zA[i].imag=(double)i+1.0;    zB1[i].real=0.0; zB1[i].imag=0.0;    zB2[i].real=0.0; zB2[i].imag=0.0;  }

  vec_len=vec_len/incra+1;
  vzPackI(vec_len,zA,incra,zB1);
  vzUnpackI(vec_len,zB1,zB2,incra);

  fprintf(stdout, "\tvzUnpackI:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf\n",zA[i].real,zA[i].imag,zB1[i].real,zB1[i].imag,zB2[i].real,zB2[i].imag);  }
}

void own_vzunpackm ()
{
  MKL_Complex16 zA[LEN],zB1[LEN],zB2[LEN];
  MKL_INT i=0,vec_len=LEN,ma[LEN];
  for(i=0;i<vec_len;i++) {    zA[i].real=(double)i+1.0; zA[i].imag=(double)i+1.0;    zB1[i].real=0.0; zB1[i].imag=0.0;    zB2[i].real=0.0; zB2[i].imag=0.0;    ma[i]=i&1;  }

  vzPackM(vec_len,zA,ma,zB1);
  vzUnpackM(vec_len,zB1,zB2,ma);

  fprintf(stdout, "\tvzUnpackM:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf\n",zA[i].real,zA[i].imag,zB1[i].real,zB1[i].imag,zB2[i].real,zB2[i].imag);  }
}

void own_vzunpackv ()
{
  MKL_Complex16 zA[LEN],zB1[LEN],zB2[LEN];
  MKL_INT i=0,vec_len=LEN,ia[LEN];
  for(i=0;i<vec_len;i++) {    zA[i].real=(double)i+1.0; zA[i].imag=(double)i+1.0;    zB1[i].real=0.0; zB1[i].imag=0.0;    zB2[i].real=0.0; zB2[i].imag=0.0;    ia[i]=vec_len-i-1;  }

  vzPackV(vec_len,zA,ia,zB1);
  vzUnpackV(vec_len,zB1,zB2,ia);

  fprintf(stdout, "\tvzUnpackV:\n");
  fprintf(stdout, "\t\t%16s%16s%16s\n","Before packing","After packing","After Unpacking");
  for(i=0;i<LEN;i++) {    fprintf(stdout, "\t\t %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf %5.1lf + i*%-5.1lf\n",zA[i].real,zA[i].imag,zB1[i].real,zB1[i].imag,zB2[i].real,zB2[i].imag);  }
}

/**
 * @brief Main function for pack/unpack test
 *
 * Main performs simple test of pack/unpack functions
 *
 * @param[in] argc         Number of arguments
 * @param[in] argv         Pointer to argument strings
 * @return                 -1 for FAIL or 0 for PASS
 *
 */
int main (int argc, char **argv)
{
    int ret = VML_STATUS_OK;   /* Return status */

    fprintf (stdout, "classic c vm_pack_unpack: started...\n"); fflush (stdout);

    /* single precision */
    own_vspacki ();   own_vspackm ();   own_vspackv ();
    own_vsunpacki (); own_vsunpackm (); own_vsunpackv ();

    /* double precision */
    own_vdpacki ();   own_vdpackm ();   own_vdpackv ();
    own_vdunpacki (); own_vdunpackm (); own_vdunpackv ();

    /* complex single precision */
    own_vcpacki ();   own_vcpackm ();   own_vcpackv ();
    own_vcunpacki (); own_vcunpackm (); own_vcunpackv ();

    /* complex double precision */
    own_vzpacki ();   own_vzpackm ();   own_vzpackv ();
    own_vzunpacki (); own_vzunpackm (); own_vzunpackv ();

    /* Check global VM status */
    ret = (vmlGetErrStatus() < VML_STATUS_OK)?-1:0;

    fprintf (stdout, "classic c vm_pack_unpack: %s\n\n", (ret)?"FAIL":"PASS");

    return ret;
} /* main */

