/*******************************************************************************
* Copyright (C) 2025 Intel Corporation
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/


#include "matrix_reader.h"

// This is a modified version of mm_read_mtx_crd_size from mmio.c file
MKL_INT mm_read_mtx_crd_size_mkl(FILE *f, MKL_INT *M, MKL_INT *N, MKL_INT *nz )
{
    char line[MM_MAX_LINE_LENGTH];
    MKL_INT num_items_read;

    /* set return null parameter values, in case we exit with errors */
    *M = *N = *nz = 0;

    /* now continue scanning until you reach the end-of-comments */
    do
    {
        if (fgets(line,MM_MAX_LINE_LENGTH,f) == NULL)
            return MM_PREMATURE_EOF;
    }while (line[0] == '%');


    /* line[] is either blank or has M,N, nz */
#ifdef MKL_ILP64
    if (sscanf(line, "%lld %lld %lld", M, N, nz) == 3)
#else
    if (sscanf(line, "%d %d %d", M, N, nz) == 3)
#endif
        return 0;

    else
    do
    {
#ifdef MKL_ILP64
        num_items_read = fscanf(f, "%lld %lld %lld", M, N, nz);
#else
        num_items_read = fscanf(f, "%d %d %d", M, N, nz);
#endif
        if (num_items_read == EOF) return MM_PREMATURE_EOF;
    }
    while (num_items_read != 3);

    return 0;
}



#undef DATA_TYPE
#undef x_mm_read_unsymmetric_sparse_mkl
#undef x_matrix_reader
#undef mkl_sparse_x_create_coo
#define DATA_TYPE double
#define x_mm_read_unsymmetric_sparse_mkl d_mm_read_unsymmetric_sparse_mkl
#define x_matrix_reader d_matrix_reader
#define mkl_sparse_x_create_coo mkl_sparse_d_create_coo
#include "matrix_reader.cxx"

#undef DATA_TYPE
#undef x_mm_read_unsymmetric_sparse_mkl
#undef x_matrix_reader
#undef mkl_sparse_x_create_coo
#define DATA_TYPE float
#define x_mm_read_unsymmetric_sparse_mkl s_mm_read_unsymmetric_sparse_mkl
#define x_matrix_reader s_matrix_reader
#define mkl_sparse_x_create_coo mkl_sparse_s_create_coo
#define SINGLE_PRECISION
#include "matrix_reader.cxx"
#undef SINGLE_PRECISION

#undef DATA_TYPE
#undef x_mm_read_unsymmetric_sparse_mkl
#undef x_matrix_reader
#undef mkl_sparse_x_create_coo
