#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 idris
version:              1.3.4
visibility:           public
id:                   idris-1.3.4-Iduj71xvpYSKMZuvnuZCDg
key:                  idris-1.3.4-Iduj71xvpYSKMZuvnuZCDg
license:              BSD-3-Clause
maintainer:           Niklas Larsson <niklas@mm.st>
author:               Edwin Brady
stability:            Beta
homepage:             https://www.idris-lang.org/
synopsis:             Functional Programming Language with Dependent Types
description:
    Idris is a general purpose language with full dependent types.
    It is compiled, with eager evaluation.
    Dependent types allow types to be predicated on values,
    meaning that some aspects of a program'\''s behaviour can be
    specified precisely in the type. The language is closely
    related to Epigram and Agda. There is a tutorial at
    <https://www.idris-lang.org/documentation>.
    Features include:

    * Full, first class, dependent types with dependent pattern matching

    * where clauses, with rule, case expressions,
    pattern matching let and lambda bindings

    * Interfaces (similar to type classes), monad comprehensions

    * do notation, idiom brackets, syntactic conveniences for lists,
    tuples, dependent pairs

    * Totality checking

    * Coinductive types

    * Indentation significant syntax, extensible syntax

    * Cumulative universes

    * Simple foreign function interface (to C)

    * Hugs style interactive environment

category:             Compilers/Interpreters, Dependent Types
abi:                  4bd08f527068e0c726be55905981b60f
exposed:              True
exposed-modules:
    IRTS.Bytecode IRTS.CodegenC IRTS.CodegenCommon
    IRTS.CodegenJavaScript IRTS.Compiler IRTS.Defunctionalise
    IRTS.DumpBC IRTS.Exports IRTS.Inliner IRTS.JavaScript.AST
    IRTS.JavaScript.Codegen IRTS.JavaScript.LangTransforms
    IRTS.JavaScript.Name IRTS.JavaScript.PrimOp
    IRTS.JavaScript.Specialize IRTS.Lang IRTS.LangOpts IRTS.Portable
    IRTS.Simplified IRTS.System Idris.ASTUtils Idris.AbsSyntax
    Idris.AbsSyntaxTree Idris.Apropos Idris.CaseSplit Idris.Chaser
    Idris.CmdOptions Idris.Colours Idris.Completion Idris.Core.Binary
    Idris.Core.CaseTree Idris.Core.Constraints Idris.Core.DeepSeq
    Idris.Core.Elaborate Idris.Core.Evaluate Idris.Core.Execute
    Idris.Core.ProofState Idris.Core.ProofTerm Idris.Core.TT
    Idris.Core.Typecheck Idris.Core.Unify Idris.Core.WHNF
    Idris.Coverage Idris.DSL Idris.DataOpts Idris.DeepSeq
    Idris.Delaborate Idris.Directives Idris.Docs Idris.Docstrings
    Idris.Elab.AsPat Idris.Elab.Clause Idris.Elab.Data
    Idris.Elab.Implementation Idris.Elab.Interface Idris.Elab.Provider
    Idris.Elab.Quasiquote Idris.Elab.Record Idris.Elab.Rewrite
    Idris.Elab.RunElab Idris.Elab.Term Idris.Elab.Transform
    Idris.Elab.Type Idris.Elab.Utils Idris.Elab.Value Idris.ElabDecls
    Idris.Erasure Idris.ErrReverse Idris.Error Idris.Help Idris.IBC
    Idris.IdeMode Idris.IdrisDoc Idris.Imports Idris.Info
    Idris.Info.Show Idris.Inliner Idris.Interactive Idris.Main
    Idris.ModeCommon Idris.Options Idris.Output Idris.Package
    Idris.Package.Common Idris.Package.Parser Idris.Parser
    Idris.Parser.Data Idris.Parser.Expr Idris.Parser.Helpers
    Idris.Parser.Ops Idris.Parser.Stack Idris.PartialEval
    Idris.Primitives Idris.ProofSearch Idris.Prover Idris.Providers
    Idris.REPL Idris.REPL.Browse Idris.REPL.Commands Idris.REPL.Parser
    Idris.Reflection Idris.Termination Idris.Transforms
    Idris.TypeSearch Idris.Unlit Idris.WhoCalls Util.DynamicLinker
    Util.ScreenSize Util.System

hidden-modules:
    Util.Pretty Util.Net Paths_idris Version_idris Tools_idris
    BuildFlags_idris

import-dirs:          /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/idris-1.3.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/idris
hs-libraries:         HSidris-1.3.4-Iduj71xvpYSKMZuvnuZCDg
extra-libraries:      gmp
depends:
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    annotated-wl-pprint-0.7.0-GFWp72SduKx5Zv0YaM2sPQ
    ansi-terminal-1.0.2-3wM6DfsGeit89xAznbDC0C
    ansi-wl-pprint-1.0.2-95YnaC3fNbfLsNzVSxIj4T array-0.5.6.0
    async-2.2.5-A7cw4gHfrNnBMjsgvHD8kq base-4.18.2.1
    base64-bytestring-1.2.1.0-B0w0hfBZVmq3UW6lmjr7G binary-0.8.9.1
    blaze-html-0.9.2.0-LUjYdeknUl1Ef7LhdtXXgs
    blaze-markup-0.8.3.0-Donjg3mDQKIJPFMPJHNoUU bytestring-0.11.5.3
    cheapskate-0.1.1.2-1kM7K2ZkrE2LjNdiSwGpWd
    code-page-0.2.1-8r7bPp8D9hK7XmJl89SAkA containers-0.6.7
    deepseq-1.4.8.1 directory-1.3.8.5 filepath-1.4.300.1
    fingertree-0.1.6.2-1ZnArgNWQOpCprzHcNGgkt
    fsnotify-0.4.4.0-67PYOzNLfYxLUmSaifyWCs haskeline-0.8.2.1
    ieee754-0.8.0-EGVgNa4vggOEmRT3C9pqtp
    libffi-0.2.1-6RvgivFZ04x2a0O1QsDmY2
    megaparsec-9.7.0-I0qZdfD2x7QA5TPaNUjmTK mtl-2.3.1
    network-3.1.4.0-DqImTC0JtBs7wAjAQOfbw6
    optparse-applicative-0.18.1.0-3S7fKkQk1IxEovxwORLzkN
    parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48 pretty-1.1.3.6
    process-1.6.19.0 regex-tdfa-1.3.2.5-qZoXOptISAJcpXFSPLOTl
    safe-0.3.21-EsRFO8M87PCEtDqVSuBNfo
    split-0.2.5-LIo01L9HFTI75RwsLzYVkn
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2 time-1.12.2
    transformers-0.6.1.0 uniplate-1.6.13-8Pbvi4nCeGU4g9X001jnYk
    unix-2.8.4.0 unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    vector-0.13.2.0-JoP5POFPMLsLn1of7TvjGI
    vector-binary-instances-0.2.5.2-JWkqM8yORCCLW0o5JYUR8k
    zip-archive-0.4.3.2-LZVIXJHNIlm9n9yyOiWrMh

haddock-interfaces:   /usr/share/doc/idris/html/idris.haddock
haddock-html:         /usr/share/doc/idris/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

