/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirInlineBodyVariableAssignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;)V", "checkers"})
public final class FirInlineBodyVariableAssignmentChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirInlineBodyVariableAssignmentChecker INSTANCE = new FirInlineBodyVariableAssignmentChecker();

    private FirInlineBodyVariableAssignmentChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirVariableAssignment expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext = context2.getInlineFunctionBodyContext();
        if (inlineFunctionBodyContext == null) {
            return;
        }
        FirInlineDeclarationChecker.InlineFunctionBodyContext inlineFunctionBodyContext2 = inlineFunctionBodyContext;
        FirReference firReference = ReferenceUtilsKt.getCalleeReference(expression2);
        FirCallableSymbol firCallableSymbol = firReference != null ? FirReferenceUtilsKt.toResolvedCallableSymbol$default(firReference, false, 1, null) : null;
        FirPropertySymbol firPropertySymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
        if (firPropertySymbol == null) {
            return;
        }
        FirPropertySymbol propertySymbol = firPropertySymbol;
        FirPropertyAccessorSymbol firPropertyAccessorSymbol = propertySymbol.getSetterSymbol();
        if (firPropertyAccessorSymbol == null) {
            return;
        }
        FirPropertyAccessorSymbol setterSymbol = firPropertyAccessorSymbol;
        inlineFunctionBodyContext2.check(context2, reporter, expression2, setterSymbol);
    }
}

