/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DyldCacheSlidProvider
implements ByteProvider {
    private String name;
    private ByteProvider origProvider;
    private DyldCacheMappingInfo mappingInfo;
    private Map<DyldCacheMappingInfo, Map<Long, DyldFixup>> slideFixupMap;
    private TaskMonitor monitor;

    public DyldCacheSlidProvider(DyldCacheMappingInfo mappingInfo, DyldCacheUtils.SplitDyldCache splitDyldCache, int splitCacheIndex, Map<DyldCacheMappingInfo, Map<Long, DyldFixup>> slideFixupMap, TaskMonitor monitor) {
        this.name = splitDyldCache.getName(splitCacheIndex);
        this.origProvider = splitDyldCache.getProvider(splitCacheIndex);
        this.mappingInfo = mappingInfo;
        this.slideFixupMap = slideFixupMap;
        this.monitor = monitor;
    }

    public byte readByte(long index) throws IOException {
        if (!this.mappingInfo.contains(index, false)) {
            return this.origProvider.readByte(index);
        }
        Map<Long, DyldFixup> fixups = this.slideFixupMap.get(this.mappingInfo);
        if (fixups == null) {
            return this.origProvider.readByte(index);
        }
        long aligned = index & 0xFFFFFFFFFFFFFFFCL;
        DyldFixup fixup = fixups.get(aligned);
        if (fixup == null && (fixup = fixups.get(aligned = index & 0xFFFFFFFFFFFFFFF8L)) != null && fixup.size() != 8) {
            fixup = null;
        }
        if (fixup == null) {
            return this.origProvider.readByte(index);
        }
        return (byte)(fixup.value() >> (int)((index - aligned) * 8L));
    }

    public byte[] readBytes(long index, long length) throws IOException {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("unsupported length");
        }
        if (index < 0L) {
            throw new IllegalArgumentException("invalid index");
        }
        byte[] ret = new byte[(int)length];
        this.monitor.initialize(length, "Reading " + this.name);
        int i = 0;
        while ((long)i < length) {
            this.monitor.incrementProgress();
            ret[i] = this.readByte(index + (long)i);
            ++i;
        }
        return ret;
    }

    public File getFile() {
        return this.origProvider.getFile();
    }

    public String getName() {
        return this.name;
    }

    public String getAbsolutePath() {
        return this.origProvider.getAbsolutePath();
    }

    public long length() throws IOException {
        return this.origProvider.length();
    }

    public boolean isValidIndex(long i) {
        return this.origProvider.isValidIndex(i);
    }

    public void close() throws IOException {
    }
}

