/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MemoryRange64
implements StructConverter {
    public static final String NAME = "MINIDUMP_MEMORY_RANGE_64";
    private long startOfMemoryRange;
    private long dataSize;
    private DumpFileReader reader;
    private long index;

    MemoryRange64(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setStartOfMemoryRange(this.reader.readNextLong());
        this.setDataSize(this.reader.readNextLong());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "StartOfMemoryRange", null);
        struct.add(QWORD, 8, "DataSize", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public long getStartOfMemoryRange() {
        return this.startOfMemoryRange;
    }

    public void setStartOfMemoryRange(long startOfMemoryRange) {
        this.startOfMemoryRange = startOfMemoryRange;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }
}

