/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.ChildAtom;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.sql.SQLException;

public class HasNamedChildBSimFilterType
extends BSimFilterType {
    public static final String XML_VALUE = "namedchild";

    public HasNamedChildBSimFilterType() {
        super("Calls external function", XML_VALUE, "external subfunction");
    }

    @Override
    public boolean isChildFilter() {
        return true;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution resolution) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("EXISTS (SELECT 1 FROM callgraphtable WHERE src = desctable.id AND dest = ");
        buf.append(resolution.id1);
        buf.append(')');
        effect.addWhere(this, buf.toString());
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        String argName = effect.assignArgument();
        effect.addChildId("Collections.binarySearch(childid,params." + argName + ")>=0");
        effect.addFuncParam(argName, resolution.idString);
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        return true;
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        ChildAtom childatom = (ChildAtom)atom;
        return new IDSQLResolution.ExternalFunction(childatom.exename, childatom.name);
    }

    @Override
    public IDElasticResolution generateIDElasticResolution(FilterAtom atom) {
        ChildAtom childatom = (ChildAtom)atom;
        return new IDElasticResolution.ExternalFunction(childatom.exename, childatom.name);
    }
}

