/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.filter.TextFilter;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.TableFilter;
import java.util.List;
import java.util.Objects;

public class TableTextFilter<ROW_OBJECT>
implements TableFilter<ROW_OBJECT> {
    private TextFilter textFilter;
    private RowFilterTransformer<ROW_OBJECT> transformer;

    public TableTextFilter(TextFilter textFilter, RowFilterTransformer<ROW_OBJECT> transformer) {
        this.textFilter = textFilter;
        this.transformer = transformer;
    }

    @Override
    public boolean isSubFilterOf(TableFilter<?> tableFilter) {
        if (!(tableFilter instanceof TableTextFilter)) {
            return false;
        }
        TableTextFilter other = (TableTextFilter)tableFilter;
        if (!this.textFilter.isSubFilterOf(other.textFilter)) {
            return false;
        }
        Class<?> clazz = this.transformer.getClass();
        Class<?> otherClazz = other.transformer.getClass();
        return clazz.equals(otherClazz);
    }

    @Override
    public boolean acceptsRow(ROW_OBJECT rowObject) {
        List<String> transform = this.transformer.transform(rowObject);
        for (String string : transform) {
            if (!this.textFilter.matches(string)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableTextFilter other = (TableTextFilter)obj;
        if (!Objects.equals(this.textFilter, other.textFilter)) {
            return false;
        }
        return Objects.equals(this.transformer, other.transformer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - filter='" + this.textFilter.getFilterText() + "'";
    }
}

