/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableEventMap
extends CliAbstractTable {
    public CliTableEventMap(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliEventMapRow(this.readTableIndex(reader, CliTypeTable.TypeDef), this.readTableIndex(reader, CliTypeTable.Event)));
        }
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "EventMap Row", 0);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.TypeDef), "Parent", null);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.Event), "EventList", "First of a contiguous run in Event table, ending with next EventMap reference or end of table.");
        return rowDt;
    }

    public class CliEventMapRow
    extends CliAbstractTableRow {
        public int parentIndex;
        public int eventIndex;

        public CliEventMapRow(int parentIndex, int eventIndex) {
            this.parentIndex = parentIndex;
            this.eventIndex = eventIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("Parent %s EventList %s", CliTableEventMap.this.getRowRepresentationSafe(CliTypeTable.TypeDef, this.parentIndex), CliTableEventMap.this.getRowRepresentationSafe(CliTypeTable.Event, this.eventIndex));
        }
    }
}

