/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ArchitectureDataDirectory
extends DataDirectory
implements StructConverter {
    private static final String NAME = "IMAGE_DIRECTORY_ENTRY_ARCHITECTURE";
    private String copyright;

    ArchitectureDataDirectory(NTHeader ntHeader, BinaryReader reader) throws IOException {
        this.processDataDirectory(ntHeader, reader);
    }

    @Override
    public String getDirectoryName() {
        return NAME;
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader nt) throws DuplicateNameException, CodeUnitInsertionException {
        monitor.setMessage(program.getName() + ": architecture...");
        Address addr = PeUtils.getMarkupAddress(program, isBinary, nt, this.virtualAddress);
        if (!program.getMemory().contains(addr)) {
            return;
        }
        this.createDirectoryBookmark(program, addr);
        PeUtils.createData(program, addr, this.toDataType(), log);
    }

    @Override
    public boolean parse() throws IOException {
        int ptr = this.getPointer();
        if (ptr < 0) {
            return false;
        }
        if (this.getSize() > 1000) {
            Msg.info((Object)this, (Object)("Requesting ASCII string of size " + this.getSize()));
            return false;
        }
        this.copyright = this.reader.readAsciiString(ptr, this.getSize()).trim();
        return true;
    }

    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        if (this.size > 0) {
            struct.add((DataType)new StringDataType(), this.size, "Copyright", null);
        }
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

