/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51Fixup;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordTypes;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Omf51FixupRecord
extends OmfRecord {
    private boolean largeBlockId;
    private List<Omf51Fixup> fixups = new ArrayList<Omf51Fixup>();

    public Omf51FixupRecord(BinaryReader reader, boolean largeBlockId) throws IOException {
        super(reader);
        this.largeBlockId = largeBlockId;
    }

    @Override
    public void parseData() throws IOException, OmfException {
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            this.fixups.add(new Omf51Fixup(this.dataReader, this.largeBlockId));
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(Omf51RecordTypes.getName(this.recordType), 0);
        struct.add(BYTE, "type", null);
        struct.add(WORD, "length", null);
        StructureDataType fixupStruct = new StructureDataType("Omf51Fixup", 0);
        fixupStruct.setCategoryPath(new CategoryPath("/OMF"));
        fixupStruct.add(WORD, "refLoc", null);
        fixupStruct.add(BYTE, "refType", null);
        fixupStruct.add(BYTE, "blockType", null);
        fixupStruct.add(this.largeBlockId ? WORD : BYTE, "blockId", null);
        fixupStruct.add(WORD, "offset", null);
        struct.add((DataType)new ArrayDataType((DataType)fixupStruct, this.fixups.size()), "fixups", null);
        struct.add(BYTE, "checksum", null);
        struct.setCategoryPath(new CategoryPath("/OMF"));
        return struct;
    }

    public List<Omf51Fixup> getFixups() {
        return this.fixups;
    }
}

