/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.add;

import docking.DialogComponentProvider;
import docking.widgets.button.GButton;
import docking.widgets.button.GRadioButton;
import docking.widgets.label.GLabel;
import docking.widgets.list.GList;
import generic.theme.GIcon;
import ghidra.feature.vt.gui.wizard.add.AddRemoveAddressRangeDialog;
import ghidra.feature.vt.gui.wizard.add.AddToSessionData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.layout.MiddleLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChooseAddressSetEditorPanel
extends JPanel {
    private static Icon ADD_ICON = new GIcon("icon.version.tracking.add");
    private static Icon SUBTRACT_ICON = new GIcon("icon.version.tracking.subtract");
    private PluginTool tool;
    private final String name;
    private final Program program;
    private boolean hasSelection = false;
    private AddressSet myCurrentAddressSet;
    private AddToSessionData.AddressSetChoice currentAddressSetChoice;
    private JRadioButton entireProgramButton;
    private JRadioButton toolSelectionButton;
    private JRadioButton myRangesButton;
    private JButton addRangeButton;
    private JButton subtractRangeButton;
    private JButton removeRangeButton;
    private JPanel bottomButtons;
    private AddressSetListModel listModel;
    private GList<AddressRange> list;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>();

    public ChooseAddressSetEditorPanel(PluginTool tool, String name, Program program, AddressSetView selectionAddressSet, AddressSetView myInitialAddressSet, AddToSessionData.AddressSetChoice initialAddressSetChoice) {
        super(new BorderLayout());
        this.tool = tool;
        this.name = name;
        this.program = program;
        if (selectionAddressSet != null && !selectionAddressSet.isEmpty()) {
            this.hasSelection = true;
        }
        this.myCurrentAddressSet = myInitialAddressSet != null && !myInitialAddressSet.isEmpty() ? new AddressSet(myInitialAddressSet) : (this.hasSelection ? new AddressSet(selectionAddressSet) : new AddressSet((AddressSetView)program.getMemory()));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name));
        this.add((Component)this.createChooseSourcePanel(), "North");
        this.add(this.createRangeListPanel(), "Center");
        switch (initialAddressSetChoice) {
            case SELECTION: {
                this.toolSelectionButton.setSelected(true);
                this.choseToolSelection();
                break;
            }
            case MANUALLY_DEFINED: {
                this.myRangesButton.setSelected(true);
                this.choseMyRanges();
                break;
            }
            default: {
                this.entireProgramButton.setSelected(true);
                this.choseEntireProgram();
            }
        }
    }

    private JPanel createChooseSourcePanel() {
        JPanel chooseSourcePanel = new JPanel((LayoutManager)new VerticalLayout(5));
        ButtonGroup originGroup = new ButtonGroup();
        this.entireProgramButton = new GRadioButton("Use Entire " + this.name + " Program", false);
        this.toolSelectionButton = new GRadioButton("Use " + this.name + " Tool's Selection", false);
        this.myRangesButton = new GRadioButton("Specify My Own Address Ranges", false);
        originGroup.add(this.entireProgramButton);
        originGroup.add(this.toolSelectionButton);
        originGroup.add(this.myRangesButton);
        this.entireProgramButton.setToolTipText("Don't limit the address ranges. Use all addresses in the " + this.name + " program.");
        this.toolSelectionButton.setToolTipText("Limit the address ranges from the " + this.name + " program to those that are selected in the " + this.name + " Tool.");
        this.myRangesButton.setToolTipText("Limit the address ranges from the " + this.name + " program to those that I am specifying here.");
        this.entireProgramButton.addActionListener(ev -> this.choseEntireProgram());
        this.toolSelectionButton.addActionListener(ev -> this.choseToolSelection());
        this.myRangesButton.addActionListener(ev -> this.choseMyRanges());
        chooseSourcePanel.add(this.entireProgramButton);
        chooseSourcePanel.add(this.toolSelectionButton);
        chooseSourcePanel.add(this.myRangesButton);
        this.toolSelectionButton.setEnabled(this.hasSelection);
        return chooseSourcePanel;
    }

    protected void choseEntireProgram() {
        this.currentAddressSetChoice = AddToSessionData.AddressSetChoice.ENTIRE_PROGRAM;
        this.validateAddRemoveButton();
        this.list.setEnabled(false);
        this.validateRemoveButton();
    }

    protected void choseToolSelection() {
        this.currentAddressSetChoice = AddToSessionData.AddressSetChoice.SELECTION;
        this.validateAddRemoveButton();
        this.list.setEnabled(false);
        this.validateRemoveButton();
    }

    protected void choseMyRanges() {
        this.currentAddressSetChoice = AddToSessionData.AddressSetChoice.MANUALLY_DEFINED;
        this.validateAddRemoveButton();
        this.list.setEnabled(true);
        this.validateRemoveButton();
    }

    protected void setAddressSet(AddressSet addressSet) {
        this.listModel.setData(addressSet.toList());
        this.list.clearSelection();
        this.notifyListeners();
    }

    private Component createRemoveRangePanel() {
        this.bottomButtons = new JPanel();
        this.bottomButtons.setLayout((LayoutManager)new MiddleLayout());
        this.removeRangeButton = new GButton("Remove Selected Range(s)");
        this.removeRangeButton.addActionListener(e -> this.removeRange());
        this.bottomButtons.add(this.removeRangeButton);
        return this.bottomButtons;
    }

    private Component createRangeListPanel() {
        this.addRangeButton = new GButton(ADD_ICON);
        this.addRangeButton.addActionListener(e -> this.showAddRangeDialog());
        this.addRangeButton.setToolTipText("Add the range to the set of included addresses");
        this.subtractRangeButton = new GButton(SUBTRACT_ICON);
        this.subtractRangeButton.addActionListener(e -> this.showSubtractRangeDialog());
        this.subtractRangeButton.setToolTipText("Remove the range from the set of included addresses");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addRangeButton);
        buttonPanel.add(this.subtractRangeButton);
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)new GLabel("Address Ranges:"), "West");
        headerPanel.add((Component)buttonPanel, "East");
        this.listModel = new AddressSetListModel(this.myCurrentAddressSet.toList());
        this.list = new GList((ListModel)this.listModel);
        this.list.setSelectionMode(2);
        this.list.getSelectionModel().addListSelectionListener(e -> this.validateRemoveButton());
        JScrollPane scrollPane = new JScrollPane((Component)this.list);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        panel.add((Component)headerPanel, "North");
        panel.add((Component)scrollPane, "Center");
        panel.add(this.createRemoveRangePanel(), "South");
        return panel;
    }

    protected void showAddRangeDialog() {
        AddRemoveAddressRangeDialog addRangeDialog = new AddRemoveAddressRangeDialog("Add", this.name, this.program, r -> this.addRange((AddressRange)r));
        this.tool.showDialog((DialogComponentProvider)addRangeDialog, (Component)this.getRootPane());
    }

    protected void showSubtractRangeDialog() {
        AddRemoveAddressRangeDialog removeRangeDialog = new AddRemoveAddressRangeDialog("Remove", this.name, this.program, r -> this.subtractRange((AddressRange)r));
        this.tool.showDialog((DialogComponentProvider)removeRangeDialog, (Component)this.getRootPane());
    }

    public synchronized AddressSetView getAddressSetView() {
        return new AddressSet((AddressSetView)this.myCurrentAddressSet);
    }

    public synchronized boolean isUsingSelection() {
        return this.toolSelectionButton.isSelected();
    }

    private synchronized void removeRange() {
        int[] selectedIndices = this.list.getSelectedIndices();
        AddressSet removeRanges = new AddressSet();
        for (int selectedIndex : selectedIndices) {
            AddressRange addressRange = this.listModel.getElementAt(selectedIndex);
            removeRanges.add(addressRange);
        }
        this.myCurrentAddressSet.delete((AddressSetView)removeRanges);
        this.listModel.setData(this.myCurrentAddressSet.toList());
        this.list.clearSelection();
        this.notifyListeners();
    }

    private synchronized void addRange(AddressRange range) {
        this.myCurrentAddressSet.add(range);
        this.listModel.setData(this.myCurrentAddressSet.toList());
        this.notifyListeners();
    }

    private synchronized void subtractRange(AddressRange range) {
        this.myCurrentAddressSet.delete(range);
        this.listModel.setData(this.myCurrentAddressSet.toList());
        this.notifyListeners();
    }

    private void notifyListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void validateRemoveButton() {
        int selectedIndex = this.list.getSelectedIndex();
        boolean enabled = selectedIndex != -1 && this.myRangesButton.isSelected();
        this.removeRangeButton.setEnabled(enabled);
    }

    private void validateAddRemoveButton() {
        boolean isUsingMyRanges = this.myRangesButton.isSelected();
        this.addRangeButton.setEnabled(isUsingMyRanges);
        this.subtractRangeButton.setEnabled(isUsingMyRanges);
    }

    public AddToSessionData.AddressSetChoice getAddressSetChoice() {
        return this.currentAddressSetChoice;
    }

    static class AddressSetListModel
    extends AbstractListModel<AddressRange> {
        private List<AddressRange> addressList;

        AddressSetListModel(List<AddressRange> list) {
            this.addressList = list;
        }

        public void setData(List<AddressRange> list) {
            this.addressList = list;
            this.fireContentsChanged(this, 0, list.size());
        }

        @Override
        public AddressRange getElementAt(int index) {
            return this.addressList.get(index);
        }

        @Override
        public int getSize() {
            return this.addressList.size();
        }
    }
}

