/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.DisassemblerContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.DefaultProgramContext;
import java.math.BigInteger;
import java.util.List;

public class AssemblyDefaultContext
implements DisassemblerContext,
DefaultProgramContext {
    protected final SleighLanguage lang;
    protected final Address at;
    protected AssemblyPatternBlock curctx;
    protected AssemblyPatternBlock defctx;

    public AssemblyDefaultContext(SleighLanguage lang) {
        this(lang, null);
    }

    protected AssemblyDefaultContext(SleighLanguage lang, Address at) {
        this.lang = lang;
        this.at = at;
        Register ctxreg = lang.getContextBaseRegister();
        if (ctxreg == Register.NO_CONTEXT) {
            this.defctx = AssemblyPatternBlock.nop();
            this.curctx = AssemblyPatternBlock.nop();
        } else {
            int size = ctxreg.getMinimumByteSize();
            this.defctx = AssemblyPatternBlock.fromLength(size);
            this.curctx = AssemblyPatternBlock.fromLength(size);
        }
        lang.applyContextSettings(this);
    }

    public void setContextRegister(byte[] val) {
        this.curctx = AssemblyPatternBlock.fromBytes(0, val);
    }

    public void setContextRegister(AssemblyPatternBlock ctx) {
        this.curctx = this.curctx.combine(ctx);
    }

    public AssemblyPatternBlock getDefault() {
        return this.defctx;
    }

    public AssemblyPatternBlock getDefaultAt(Address addr) {
        return new AssemblyDefaultContext(this.lang, addr).getDefault();
    }

    @Override
    public void setValue(Register register, BigInteger value) throws ContextChangeException {
    }

    @Override
    public void setRegisterValue(RegisterValue value) throws ContextChangeException {
    }

    @Override
    public void clearRegister(Register register) throws ContextChangeException {
    }

    @Override
    public Register getBaseContextRegister() {
        return this.lang.getContextBaseRegister();
    }

    @Override
    public List<Register> getRegisters() {
        return this.lang.getRegisters();
    }

    @Override
    public Register getRegister(String name) {
        return this.lang.getRegister(name);
    }

    @Override
    public BigInteger getValue(Register register, boolean signed) {
        if (signed) {
            throw new UnsupportedOperationException();
        }
        if (!register.isProcessorContext()) {
            return null;
        }
        BigInteger res = this.curctx.toBigInteger(register.getMinimumByteSize());
        if (register.isBaseRegister()) {
            return res;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public RegisterValue getRegisterValue(Register register) {
        return new RegisterValue(register, this.getValue(register, false));
    }

    @Override
    public boolean hasValue(Register register) {
        return register.isProcessorContext();
    }

    @Override
    public void setFutureRegisterValue(Address address, RegisterValue value) {
    }

    @Override
    public void setFutureRegisterValue(Address fromAddr, Address toAddr, RegisterValue value) {
    }

    @Override
    public void setDefaultValue(RegisterValue registerValue, Address start, Address end) {
        if (!registerValue.getRegister().isProcessorContext()) {
            return;
        }
        if (this.at != null && (start.compareTo(this.at) > 0 || this.at.compareTo(end) > 0)) {
            return;
        }
        this.defctx = this.defctx.combine(AssemblyPatternBlock.fromRegisterValue(registerValue));
    }

    @Override
    public RegisterValue getDefaultValue(Register register, Address address) {
        throw new UnsupportedOperationException();
    }
}

