/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.model;

import java.util.Objects;

public class Dimension {
    public final int width;
    public final int height;

    public static Dimension of(int width, int height) {
        return new Dimension(width, height);
    }

    private Dimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Dimension union(Dimension other) {
        return new Dimension(Math.max(this.width, other.width), Math.min(this.height, other.height));
    }

    public Dimension intersection(Dimension other) {
        return new Dimension(Math.min(this.width, other.width), Math.min(this.height, other.height));
    }

    public String toString() {
        return "Dimension{width=" + this.width + ", height=" + this.height + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dimension dimension = (Dimension)o;
        return this.width == dimension.width && this.height == dimension.height;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height);
    }
}

