/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.font;

import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.font.GVTGlyphMetrics;
import io.sf.carte.echosvg.gvt.text.TextPaintInfo;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Vector;

public class Glyph {
    private String unicode;
    private Vector<String> names;
    private String orientation;
    private String arabicForm;
    private String lang;
    private Point2D horizOrigin;
    private Point2D vertOrigin;
    private float horizAdvX;
    private float vertAdvY;
    private int glyphCode;
    private AffineTransform transform;
    private Point2D.Float position;
    private GVTGlyphMetrics metrics;
    private Shape outline;
    private Rectangle2D bounds;
    private TextPaintInfo tpi;
    private TextPaintInfo cacheTPI;
    private Shape dShape;
    private GraphicsNode glyphChildrenNode;

    public Glyph(String string, List<String> list, String string2, String string3, String string4, Point2D point2D, Point2D point2D2, float f, float f2, int n, TextPaintInfo textPaintInfo, Shape shape, GraphicsNode graphicsNode) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (point2D == null) {
            throw new IllegalArgumentException();
        }
        if (point2D2 == null) {
            throw new IllegalArgumentException();
        }
        this.unicode = string;
        this.names = new Vector<String>(list);
        this.orientation = string2;
        this.arabicForm = string3;
        this.lang = string4;
        this.horizOrigin = point2D;
        this.vertOrigin = point2D2;
        this.horizAdvX = f;
        this.vertAdvY = f2;
        this.glyphCode = n;
        this.position = new Point2D.Float(0.0f, 0.0f);
        this.outline = null;
        this.bounds = null;
        this.tpi = textPaintInfo;
        this.dShape = shape;
        this.glyphChildrenNode = graphicsNode;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public Vector<String> getNames() {
        return this.names;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public String getArabicForm() {
        return this.arabicForm;
    }

    public String getLang() {
        return this.lang;
    }

    public Point2D getHorizOrigin() {
        return this.horizOrigin;
    }

    public Point2D getVertOrigin() {
        return this.vertOrigin;
    }

    public float getHorizAdvX() {
        return this.horizAdvX;
    }

    public float getVertAdvY() {
        return this.vertAdvY;
    }

    public int getGlyphCode() {
        return this.glyphCode;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
        this.outline = null;
        this.bounds = null;
    }

    public Point2D getPosition() {
        return this.position;
    }

    public void setPosition(Point2D point2D) {
        this.position.x = (float)point2D.getX();
        this.position.y = (float)point2D.getY();
        this.outline = null;
        this.bounds = null;
    }

    public GVTGlyphMetrics getGlyphMetrics() {
        if (this.metrics == null) {
            Rectangle2D rectangle2D = this.getGeometryBounds();
            this.metrics = new GVTGlyphMetrics(this.getHorizAdvX(), this.getVertAdvY(), new Rectangle2D.Double(rectangle2D.getX() - this.position.getX(), rectangle2D.getY() - this.position.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()), 3);
        }
        return this.metrics;
    }

    public GVTGlyphMetrics getGlyphMetrics(float f, float f2) {
        return new GVTGlyphMetrics(this.getHorizAdvX() - f, this.getVertAdvY() - f2, this.getGeometryBounds(), 3);
    }

    public Rectangle2D getGeometryBounds() {
        return this.getOutline().getBounds2D();
    }

    public Rectangle2D getBounds2D() {
        Shape shape;
        if (this.bounds != null && TextPaintInfo.equivilent(this.tpi, this.cacheTPI)) {
            return this.bounds;
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.position.getX(), this.position.getY());
        if (this.transform != null) {
            affineTransform.concatenate(this.transform);
        }
        Rectangle2D rectangle2D = null;
        if (this.dShape != null && this.tpi != null) {
            if (this.tpi.fillPaint != null) {
                rectangle2D = affineTransform.createTransformedShape(this.dShape).getBounds2D();
            }
            if (this.tpi.strokeStroke != null && this.tpi.strokePaint != null) {
                shape = this.tpi.strokeStroke.createStrokedShape(this.dShape);
                Rectangle2D rectangle2D2 = affineTransform.createTransformedShape(shape).getBounds2D();
                if (rectangle2D == null) {
                    rectangle2D = rectangle2D2;
                } else {
                    rectangle2D.add(rectangle2D2);
                }
            }
        }
        if (this.glyphChildrenNode != null) {
            shape = this.glyphChildrenNode.getTransformedBounds(affineTransform);
            if (rectangle2D == null) {
                rectangle2D = shape;
            } else {
                rectangle2D.add((Rectangle2D)shape);
            }
        }
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(this.position.getX(), this.position.getY(), 0.0, 0.0);
        }
        this.cacheTPI = new TextPaintInfo(this.tpi);
        return rectangle2D;
    }

    public Shape getOutline() {
        if (this.outline == null) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.position.getX(), this.position.getY());
            if (this.transform != null) {
                affineTransform.concatenate(this.transform);
            }
            Shape shape = null;
            if (this.glyphChildrenNode != null) {
                shape = this.glyphChildrenNode.getOutline();
            }
            GeneralPath generalPath = null;
            if (this.dShape != null && shape != null) {
                generalPath = new GeneralPath(this.dShape);
                generalPath.append(shape, false);
            } else {
                generalPath = this.dShape != null && shape == null ? new GeneralPath(this.dShape) : (this.dShape == null && shape != null ? new GeneralPath(shape) : new GeneralPath());
            }
            this.outline = affineTransform.createTransformedShape(generalPath);
        }
        return this.outline;
    }

    public void draw(Graphics2D graphics2D) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.position.getX(), this.position.getY());
        if (this.transform != null) {
            affineTransform.concatenate(this.transform);
        }
        if (this.dShape != null && this.tpi != null) {
            Shape shape = affineTransform.createTransformedShape(this.dShape);
            Paint paint = this.tpi.getFillPaint();
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill(shape);
            }
            if (this.tpi.strokeStroke != null && this.tpi.strokePaint != null) {
                graphics2D.setStroke(this.tpi.strokeStroke);
                graphics2D.setPaint(this.tpi.getStrokePaint());
                graphics2D.draw(shape);
            }
        }
        if (this.glyphChildrenNode != null) {
            this.glyphChildrenNode.setTransform(affineTransform);
            this.glyphChildrenNode.paint(graphics2D);
        }
    }
}

