/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av.impl;

import com.jogamp.common.av.AudioFormat;
import com.jogamp.common.av.AudioSink;
import com.jogamp.common.av.AudioSinkFactory;
import com.jogamp.common.net.Uri;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.av.VideoPixelFormat;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.io.PrintStream;
import java.security.PrivilegedAction;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.util.av.AudioSampleFormat;
import jogamp.opengl.util.av.GLMediaPlayerImpl;
import jogamp.opengl.util.av.impl.FFMPEGDynamicLibraryBundleInfo;
import jogamp.opengl.util.av.impl.FFMPEGNatives;

public class FFMPEGMediaPlayer
extends GLMediaPlayerImpl {
    static final boolean PREFER_SYSTEM_LIBS;
    private static final int ENOSYS = 38;
    private static final FFMPEGNatives natives;
    private static final int avUtilMajorVersionCC;
    private static final int avFormatMajorVersionCC;
    private static final int avCodecMajorVersionCC;
    private static final int avDeviceMajorVersionCC;
    private static final int swResampleMajorVersionCC;
    private static final int swScaleMajorVersionCC;
    private static final boolean available;
    private final Object moviePtrLock = new Object();
    private long moviePtr = 0L;
    private VideoPixelFormat vPixelFmt = VideoPixelFormat.RGBA;
    private int vPlanes = 0;
    private int vBitsPerPixel = 0;
    private int vBytesPerPixelPerPlane = 0;
    private int vWidth = 0;
    private int vHeight = 0;
    private int texWidth = 0;
    private int texHeight = 0;
    private String singleTexComp = "r";
    private final GLPixelStorageModes psm;
    private AudioFormat avChosenAudioFormat;
    private int audioSamplesPerFrameAndChannel = 0;
    public static final String dev_video_linux = "/dev/video";
    private volatile GLMediaPlayer.Chapter[] chapters = new GLMediaPlayer.Chapter[0];

    public static final boolean isAvailable() {
        return available;
    }

    private static final void printNativeInfoImpl(PrintStream printStream) {
        printStream.println("FFmpeg Codec   : " + FFMPEGDynamicLibraryBundleInfo.avCodec + " [cc " + avCodecMajorVersionCC + "]");
        printStream.println("FFmpeg Format  : " + FFMPEGDynamicLibraryBundleInfo.avFormat + " [cc " + avFormatMajorVersionCC + "]");
        printStream.println("FFmpeg Util    : " + FFMPEGDynamicLibraryBundleInfo.avUtil + " [cc " + avUtilMajorVersionCC + "]");
        printStream.println("FFmpeg Device  : " + FFMPEGDynamicLibraryBundleInfo.avDevice + " [cc " + avDeviceMajorVersionCC + ", loaded " + FFMPEGDynamicLibraryBundleInfo.avDeviceLoaded() + "]");
        printStream.println("FFmpeg Resample: " + FFMPEGDynamicLibraryBundleInfo.swResample + " [cc " + swResampleMajorVersionCC + ", loaded " + FFMPEGDynamicLibraryBundleInfo.swResampleLoaded() + "]");
        printStream.println("FFmpeg Scale   : " + FFMPEGDynamicLibraryBundleInfo.swScale + " [cc " + swScaleMajorVersionCC + ", loaded " + FFMPEGDynamicLibraryBundleInfo.swScaleLoaded() + "]");
        printStream.println("FFmpeg Class   : " + (null != natives ? natives.getClass().getSimpleName() : "n/a"));
    }

    @Override
    public final void printNativeInfo(PrintStream printStream) {
        FFMPEGMediaPlayer.printNativeInfoImpl(printStream);
    }

    public FFMPEGMediaPlayer() {
        if (!available) {
            throw new RuntimeException("FFMPEGMediaPlayer not available");
        }
        this.psm = new GLPixelStorageModes();
        this.initSelf();
    }

    private void initSelf() {
        this.moviePtr = natives.createInstance0(this, DEBUG_NATIVE);
        if (0L == this.moviePtr) {
            throw new GLException("Couldn't create FFMPEGInstance");
        }
        this.audioSink = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void destroyImpl() {
        Object object = this.moviePtrLock;
        synchronized (object) {
            if (this.moviePtr != 0L) {
                natives.destroyInstance0(this.moviePtr);
                this.moviePtr = 0L;
            }
        }
        this.destroyAudioSink();
    }

    private final void destroyAudioSink() {
        AudioSink audioSink = this.audioSink;
        if (null != audioSink) {
            this.audioSink = null;
            audioSink.destroy();
        }
    }

    @Override
    protected void stopImpl() {
        this.destroyImpl();
        this.initSelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void initStreamImpl(int n, String string, int n2, String string2, int n3) throws IOException {
        Object object = this.moviePtrLock;
        synchronized (object) {
            int n4;
            String string3;
            if (0L == this.moviePtr) {
                throw new GLException("FFMPEG native instance null");
            }
            if (DEBUG) {
                System.err.println("initStream: p1 " + this);
            }
            String string4 = IOUtil.getUriFilePathOrASCII((Uri)this.getUri());
            this.destroyAudioSink();
            this.audioSink = -2 == n2 ? AudioSinkFactory.createNull() : AudioSinkFactory.createDefault((ClassLoader)FFMPEGMediaPlayer.class.getClassLoader());
            int n5 = this.getAudioChannelLimit();
            if (n5 >= 1) {
                this.audioSink.setChannelLimit(n5);
            }
            AudioFormat audioFormat = this.audioSink.getPreferredFormat();
            if (DEBUG) {
                System.err.println("initStream: p2 aid " + n2 + "/" + string + ", preferred " + audioFormat + " on " + this.audioSink + ", " + this);
            }
            boolean bl = null != this.cameraPath;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            String string5 = null;
            if (bl) {
                switch (PlatformPropsImpl.OS_TYPE) {
                    case ANDROID: 
                    case FREEBSD: 
                    case HPUX: 
                    case LINUX: 
                    case SUNOS: {
                        string3 = dev_video_linux + this.cameraPath.decode();
                        break;
                    }
                    default: {
                        string3 = this.cameraPath.decode();
                    }
                }
                if (null != this.cameraProps) {
                    string5 = (String)this.cameraProps.get("size");
                    n4 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "width");
                    if (n4 > 0) {
                        n6 = n4;
                    }
                    if ((n4 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "height")) > 0) {
                        n7 = n4;
                    }
                    if ((n4 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "rate")) > 0) {
                        n8 = n4;
                    }
                }
            } else {
                string3 = string4;
            }
            n4 = audioFormat.channelCount;
            int n9 = audioFormat.sampleRate;
            if (DEBUG) {
                System.err.println("initStream: p3 cameraPath " + this.cameraPath + ", isCameraInput " + bl);
                System.err.println("initStream: p3 stream " + this.getUri() + " -> " + string4 + " -> " + string3);
                System.err.println("initStream: p3 vid " + n + ", sizes " + string5 + ", reqVideo " + n6 + "x" + n7 + "@" + n8 + ", aid " + n2 + ", aMaxChannelCount " + n4 + ", aPrefSampleRate " + n9);
            }
            natives.setStream0(this.moviePtr, string3, bl, n, string5, n6, n7, n8, string, n2, n4, n9, string2, n3);
        }
    }

    @Override
    protected void updateMetadata() {
        GLMediaPlayer.Chapter[] chapterArray = new GLMediaPlayer.Chapter[natives.getChapterCount0(this.moviePtr)];
        for (int i = 0; i < chapterArray.length; ++i) {
            chapterArray[i] = new GLMediaPlayer.Chapter(natives.getChapterID0(this.moviePtr, i), natives.getChapterStartPTS0(this.moviePtr, i), natives.getChapterEndPTS0(this.moviePtr, i), natives.getChapterTitle0(this.moviePtr, i));
        }
        this.chapters = chapterArray;
    }

    @Override
    public GLMediaPlayer.Chapter[] getChapters() {
        return this.chapters;
    }

    @Override
    protected final void initGLImpl(final GL gL) throws IOException, GLException {
        int n;
        int n2;
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        if (null != gL && -2 != this.getVID()) {
            final GLContextImpl gLContextImpl = (GLContextImpl)gL.getContext();
            SecurityUtil.doPrivileged((PrivilegedAction)new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ProcAddressTable procAddressTable = gLContextImpl.getGLProcAddressTable();
                    long l = procAddressTable.getAddressFor("glTexImage2D");
                    long l2 = procAddressTable.getAddressFor("glTexSubImage2D");
                    long l3 = procAddressTable.getAddressFor("glGetError");
                    long l4 = procAddressTable.getAddressFor("glFlush");
                    long l5 = procAddressTable.getAddressFor("glFinish");
                    long l6 = !gL.isGLcore() && 36197 != FFMPEGMediaPlayer.this.getTextureTarget() ? procAddressTable.getAddressFor("glEnable") : 0L;
                    long l7 = procAddressTable.getAddressFor("glBindTexture");
                    natives.setGLFuncs0(FFMPEGMediaPlayer.this.moviePtr, l, l2, l3, l4, l5, l6, l7, gL.isNPOTTextureAvailable());
                    return null;
                }
            });
            n2 = 1024;
        } else {
            n2 = 512;
        }
        if (DEBUG) {
            System.err.println("initGL: p3 aid " + this.getAID() + ", avChosen " + this.avChosenAudioFormat + " on " + this.audioSink);
        }
        if (-2 == this.getAID() || null == this.audioSink) {
            if (null != this.audioSink) {
                this.audioSink.destroy();
            }
            this.audioSink = AudioSinkFactory.createNull();
            this.audioSink.init(AudioSink.DefaultFormat, 0, n2);
        } else {
            int n3 = this.audioSamplesPerFrameAndChannel > 0 ? Math.round(1000.0f * this.avChosenAudioFormat.getSamplesDuration(this.audioSamplesPerFrameAndChannel)) : 32;
            n = this.audioSink.init(this.avChosenAudioFormat, n3, n2);
            if (n == 0) {
                System.err.println("AudioSink " + this.audioSink.getClass().getName() + " does not support " + this.avChosenAudioFormat + ", using Null");
                this.audioSink.destroy();
                this.audioSink = AudioSinkFactory.createNull();
                this.audioSink.init(this.avChosenAudioFormat, 0, n2);
            }
        }
        if (DEBUG) {
            System.err.println("initGL: p4 chosen " + this.avChosenAudioFormat);
            System.err.println("initGL: p4 chosen aid " + this.getAID() + ", " + this.audioSink);
        }
        if (null != gL && -2 != this.getVID()) {
            int n4;
            int n5;
            n = 6408;
            switch (this.vBytesPerPixelPerPlane) {
                case 1: {
                    if (gL.isGL3ES3()) {
                        n5 = 6403;
                        n = 6403;
                        this.singleTexComp = "r";
                    } else {
                        n5 = 6406;
                        n = 6406;
                        this.singleTexComp = "a";
                    }
                    n4 = 1;
                    break;
                }
                case 2: {
                    if (this.vPixelFmt == VideoPixelFormat.YUYV422 || this.vPixelFmt == VideoPixelFormat.UYVY422) {
                        n5 = 6408;
                        n = 6408;
                        n4 = 4;
                        break;
                    }
                    n5 = 33319;
                    n = 33319;
                    n4 = 2;
                    break;
                }
                case 3: {
                    n5 = 6407;
                    n = 6407;
                    n4 = 3;
                    break;
                }
                case 4: {
                    if (this.vPixelFmt == VideoPixelFormat.BGRA) {
                        n5 = 32993;
                        n = 6408;
                    } else {
                        n5 = 6408;
                        n = 6408;
                    }
                    n4 = 4;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported bytes-per-pixel / plane " + this.vBytesPerPixelPerPlane);
                }
            }
            this.setTextureFormat(n, n5);
            this.setTextureType(5121);
            this.setIsGLOriented(false);
            if (DEBUG) {
                float f = (float)(this.texWidth * this.texHeight) * (float)n4 / 1000000.0f;
                System.err.printf("initGL: p5: video %s, bpp %d, %d x %d, %d b/pp, %d planes, tex %d x %d x %d -> %.2fMB%n", this.vPixelFmt.toString(), this.vBitsPerPixel, this.vWidth, this.vHeight, this.vBytesPerPixelPerPlane, this.vPlanes, this.texWidth, this.texHeight, n4, Float.valueOf(f));
            }
        }
    }

    @Override
    protected final TextureSequence.TextureFrame createTexImage(GL gL, int n) {
        return new TextureSequence.TextureFrame(this.createTexImageImpl(gL, n, this.texWidth, this.texHeight));
    }

    final boolean isAudioFormatSupported(int n, int n2, int n3) {
        AudioSampleFormat audioSampleFormat = AudioSampleFormat.valueOf(n);
        AudioFormat audioFormat = this.avAudioFormat2Local(audioSampleFormat, n2, n3);
        boolean bl = this.audioSink.isSupported(audioFormat);
        if (DEBUG) {
            System.err.println("AudioSink.isSupported: " + bl + ": av[fmt " + (Object)((Object)audioSampleFormat) + ", rate " + n2 + ", chan " + n3 + "] -> " + audioFormat);
        }
        return bl;
    }

    private final AudioFormat avAudioFormat2Local(AudioSampleFormat audioSampleFormat, int n, int n2) {
        boolean bl;
        int n3;
        boolean bl2 = true;
        boolean bl3 = true;
        switch (audioSampleFormat) {
            case S32: {
                bl2 = false;
            }
            case S32P: {
                n3 = 32;
                bl = true;
                break;
            }
            case S16: {
                bl2 = false;
            }
            case S16P: {
                n3 = 16;
                bl = true;
                break;
            }
            case U8: {
                bl2 = false;
            }
            case U8P: {
                n3 = 8;
                bl = false;
                break;
            }
            case DBL: {
                bl2 = false;
            }
            case DBLP: {
                n3 = 64;
                bl = true;
                bl3 = false;
                break;
            }
            case FLT: {
                bl2 = false;
            }
            case FLTP: {
                n3 = 32;
                bl = true;
                bl3 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sampleformat: " + (Object)((Object)audioSampleFormat));
            }
        }
        return new AudioFormat(n, n3, n2, bl, bl3, bl2, true);
    }

    void setupFFAttributes(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        AudioSampleFormat audioSampleFormat;
        this.vPixelFmt = VideoPixelFormat.RGBA;
        this.vPlanes = 0;
        this.vBitsPerPixel = 0;
        this.vBytesPerPixelPerPlane = 0;
        this.vWidth = 0;
        this.vHeight = 0;
        this.texWidth = 0;
        this.texHeight = 0;
        int[] nArray = new int[]{0, 0, 0};
        if (-2 != n) {
            this.vPixelFmt = VideoPixelFormat.valueOf(n2);
            this.vPlanes = n3;
            this.vBitsPerPixel = n4;
            this.vBytesPerPixelPerPlane = n5;
            this.vWidth = n9;
            this.vHeight = n10;
            nArray[0] = n6;
            nArray[1] = n7;
            nArray[2] = n8;
            switch (this.vPixelFmt) {
                case YUVJ420P: 
                case YUV420P: {
                    this.texWidth = nArray[0] + nArray[1];
                    this.texHeight = n10;
                    break;
                }
                case YUVJ422P: 
                case YUV422P: {
                    this.texWidth = nArray[0] + nArray[1] + nArray[2];
                    this.texHeight = n10;
                    break;
                }
                case YUYV422: 
                case UYVY422: 
                case BGR24: {
                    this.texWidth = nArray[0];
                    this.texHeight = n10;
                    break;
                }
                case RGB24: 
                case ARGB: 
                case RGBA: 
                case ABGR: 
                case BGRA: {
                    this.texWidth = nArray[0];
                    this.texHeight = n10;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported pixelformat: " + (Object)((Object)this.vPixelFmt));
                }
            }
        }
        this.avChosenAudioFormat = null;
        this.audioSamplesPerFrameAndChannel = 0;
        if (-2 != n11) {
            audioSampleFormat = AudioSampleFormat.valueOf(n12);
            this.avChosenAudioFormat = this.avAudioFormat2Local(audioSampleFormat, n13, n14);
            this.audioSamplesPerFrameAndChannel = n15;
        } else {
            audioSampleFormat = null;
        }
        if (DEBUG) {
            System.err.println("audio: id " + n11 + ", fmt " + (Object)((Object)audioSampleFormat) + ", " + this.avChosenAudioFormat + ", aFrameSize/fc " + n15);
            System.err.printf("video: id %d, %s, bpp %d, %d x %d, %d b/pp, %d planes, tex %d x %d%n", n, this.vPixelFmt.toString(), this.vBitsPerPixel, this.vWidth, this.vHeight, this.vBytesPerPixelPerPlane, this.vPlanes, this.texWidth, this.texHeight);
            for (int i = 0; i < 3; ++i) {
                System.err.println("video: p[" + i + "]: " + nArray[i]);
            }
            System.err.println("video: total tex " + this.texWidth + "x" + this.texHeight);
            System.err.println(this.toString());
        }
    }

    void updateVidAttributes(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
    }

    @Override
    public String setTextureLookupFunctionName(String string) throws IllegalStateException {
        if (null != string && string.length() > 0) {
            if (string.equals("texture2D")) {
                throw new IllegalArgumentException("Build in 'texture2D' lookup-func-name not allowed!");
            }
            this.textureLookupFunctionName = string;
        } else {
            this.textureLookupFunctionName = "ffmpegTexture2D";
        }
        this.resetTextureFragmentShaderHashCode();
        return this.textureLookupFunctionName;
    }

    @Override
    public final String getTextureLookupFragmentShaderImpl() {
        float f = (float)this.getWidth() / (float)this.texWidth;
        String string = this.getTextureLookupFunctionName();
        if (string.equals("texture2D")) {
            throw new IllegalArgumentException("Build in 'texture2D' lookup-func-name not allowed!");
        }
        switch (this.vPixelFmt) {
            case YUVJ420P: 
            case YUV420P: {
                return "// YUV420P: planar YUV 4:2:0, 12bpp, (1 Cr & Cb sample per 2x2 Y samples)\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n  const vec2 u_off = vec2(" + f + ", 0.0);\n  const vec2 v_off = vec2(" + f + ", 0.5);\n  vec2 tc_half = texCoord*0.5;\n  float y,u,v,r,g,b;\n  y = texture2D(image, texCoord)." + this.singleTexComp + ";\n  u = texture2D(image, u_off+tc_half)." + this.singleTexComp + ";\n  v = texture2D(image, v_off+tc_half)." + this.singleTexComp + ";\n  y = 1.1643*(y-0.0625);\n  u = u-0.5;\n  v = v-0.5;\n  r = y+1.5958*v;\n  g = y-0.39173*u-0.81290*v;\n  b = y+2.017*u;\n  return vec4(r, g, b, 1);\n}\n";
            }
            case YUVJ422P: 
            case YUV422P: {
                return "// YUV422P: planar YUV 4:2:2, 16bpp, (1 Cr & Cb sample per 2x1 Y samples)\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n  const vec2 u_off = vec2(" + f + "      , 0.0);\n  const vec2 v_off = vec2(" + f + " * 1.5, 0.0);\n  vec2 tc_halfw = vec2(texCoord.x*0.5, texCoord.y);\n  float y,u,v,r,g,b;\n  y = texture2D(image, texCoord)." + this.singleTexComp + ";\n  u = texture2D(image, u_off+tc_halfw)." + this.singleTexComp + ";\n  v = texture2D(image, v_off+tc_halfw)." + this.singleTexComp + ";\n  y = 1.1643*(y-0.0625);\n  u = u-0.5;\n  v = v-0.5;\n  r = y+1.5958*v;\n  g = y-0.39173*u-0.81290*v;\n  b = y+2.017*u;\n  return vec4(r, g, b, 1);\n}\n";
            }
            case YUYV422: {
                return "// YUYV422: packed YUV 4:2:2, 2 x 16bpp, [Y0 Cb] [Y1 Cr]\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    float y1,u,y2,v,y,r,g,b;\n  vec2 tc_halfw = vec2(texCoord.x*0.5, texCoord.y);\n  vec4 yuyv = texture2D(image, tc_halfw).rgba;\n  y1 = yuyv.r;\n  u  = yuyv.g;\n  y2 = yuyv.b;\n  v  = yuyv.a;\n  y = mix( y1, y2, mod(gl_FragCoord.x, 2) ); /* avoid branching! */\n  y = 1.1643*(y-0.0625);\n  u = u-0.5;\n  v = v-0.5;\n  r = y+1.5958*v;\n  g = y-0.39173*u-0.81290*v;\n  b = y+2.017*u;\n  return vec4(r, g, b, 1);\n}\n";
            }
            case UYVY422: {
                return "// UYVY422: packed YUV 4:2:2, 2 x 16bpp, Cb Y0 Cr Y1\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    float y1,u,y2,v,y,r,g,b;\n  vec2 tc_halfw = vec2(texCoord.x*0.5, texCoord.y);\n  vec4 uyvy = texture2D(image, tc_halfw).rgba;\n  u  = uyvy.r;\n  y1 = uyvy.g;\n  v  = uyvy.b;\n  y2 = uyvy.a;\n  y = mix( y1, y2, mod(gl_FragCoord.x, 2) ); /* avoid branching! */\n  y = 1.1643*(y-0.0625);\n  u = u-0.5;\n  v = v-0.5;\n  r = y+1.5958*v;\n  g = y-0.39173*u-0.81290*v;\n  b = y+2.017*u;\n  return vec4(r, g, b, 1);\n}\n";
            }
            case BGR24: {
                return "// BGR24\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    vec3 bgr = texture2D(image, texCoord).rgb;\n  return vec4(bgr.b, bgr.g, bgr.r, 1);\n}\n";
            }
            case RGB24: {
                return "// RGB24\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    vec3 t = texture2D(image, texCoord).rgb;\n  return vec4(t.rgb, 1);\n}\n";
            }
            case ARGB: {
                return "// ARGB\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    vec4 t = texture2D(image, texCoord);\n  return vec4(t.g, t.b, t.a, t.r);\n}\n";
            }
            case RGBA: {
                return "// RGBA\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    return texture2D(image, texCoord);\n}\n";
            }
            case ABGR: {
                return "// ABGR\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    vec4 t = texture2D(image, texCoord);\n  return vec4(t.a, t.b, t.g, t.r);\n}\n";
            }
            case BGRA: {
                return "// BGR24\nvec4 " + string + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n    vec3 bgr = texture2D(image, texCoord).rgb;\n  return vec4(bgr.b, bgr.g, bgr.r, 1);\n}\n";
            }
        }
        throw new InternalError("Add proper mapping of: vPixelFmt " + (Object)((Object)this.vPixelFmt));
    }

    @Override
    public final String getTextureFragmentShaderHashID() {
        return this.getTextureLookupFragmentShaderImpl();
    }

    @Override
    public final boolean resumeImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        int n = natives.play0(this.moviePtr);
        if (DEBUG_NATIVE && n != 0 && n != -38) {
            System.err.println("ffmpeg play err: " + n);
        }
        return true;
    }

    @Override
    public final boolean pauseImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        int n = natives.pause0(this.moviePtr);
        if (DEBUG_NATIVE && n != 0 && n != -38) {
            System.err.println("ffmpeg pause err: " + n);
        }
        return true;
    }

    @Override
    protected final synchronized int seekImpl(int n) {
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        return natives.seek0(this.moviePtr, n);
    }

    @Override
    protected void preNextTextureImpl(GL gL) {
        this.psm.setUnpackAlignment(gL, 1);
        gL.glActiveTexture(33984 + this.getTextureUnit());
    }

    @Override
    protected void postNextTextureImpl(GL gL) {
        this.psm.restore(gL);
    }

    @Override
    protected final int getNextTextureImpl(GL gL, TextureSequence.TextureFrame textureFrame, Texture texture, boolean[] blArray) {
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        if (null != gL) {
            n2 = textureFrame.getTexture().getTextureObject();
        }
        for (int i = 0; Integer.MIN_VALUE == n && 10 > i; ++i) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (null != gL && !blArray[0]) {
                n2 = textureFrame.getTexture().getTextureObject();
                if (null != texture) {
                    n3 = texture.getTextureObject();
                    n4 = texture.getWidth();
                    n5 = texture.getHeight();
                }
            }
            n = natives.readNextPacket0(this.moviePtr, this.getTextureTarget(), n2, this.getTextureFormat(), this.getTextureType(), 3553, n3, n4, n5, texture, blArray);
        }
        if (null != textureFrame) {
            textureFrame.setPTS(n);
        }
        return n;
    }

    static {
        boolean bl;
        String string = PropertyAccess.getProperty((String)"jogl.ffmpeg.lib", (boolean)true);
        PREFER_SYSTEM_LIBS = null == string || !string.equals("internal");
        boolean bl2 = FFMPEGDynamicLibraryBundleInfo.initSingleton();
        if (FFMPEGDynamicLibraryBundleInfo.libsLoaded()) {
            natives = FFMPEGDynamicLibraryBundleInfo.getNatives();
            if (null != natives) {
                avCodecMajorVersionCC = natives.getAvCodecMajorVersionCC0();
                avFormatMajorVersionCC = natives.getAvFormatMajorVersionCC0();
                avUtilMajorVersionCC = natives.getAvUtilMajorVersionCC0();
                avDeviceMajorVersionCC = natives.getAvDeviceMajorVersionCC0();
                swResampleMajorVersionCC = natives.getSwResampleMajorVersionCC0();
                swScaleMajorVersionCC = natives.getSwScaleMajorVersionCC0();
            } else {
                avUtilMajorVersionCC = 0;
                avFormatMajorVersionCC = 0;
                avCodecMajorVersionCC = 0;
                avDeviceMajorVersionCC = 0;
                swResampleMajorVersionCC = 0;
                swScaleMajorVersionCC = 0;
            }
            FFMPEGDynamicLibraryBundleInfo.VersionedLib versionedLib = FFMPEGDynamicLibraryBundleInfo.avCodec;
            FFMPEGDynamicLibraryBundleInfo.VersionedLib versionedLib2 = FFMPEGDynamicLibraryBundleInfo.avFormat;
            FFMPEGDynamicLibraryBundleInfo.VersionedLib versionedLib3 = FFMPEGDynamicLibraryBundleInfo.avUtil;
            FFMPEGDynamicLibraryBundleInfo.VersionedLib versionedLib4 = FFMPEGDynamicLibraryBundleInfo.avDevice;
            FFMPEGDynamicLibraryBundleInfo.VersionedLib versionedLib5 = FFMPEGDynamicLibraryBundleInfo.swResample;
            FFMPEGDynamicLibraryBundleInfo.VersionedLib versionedLib6 = FFMPEGDynamicLibraryBundleInfo.swScale;
            int n = versionedLib.version.getMajor();
            int n2 = versionedLib2.version.getMajor();
            int n3 = versionedLib3.version.getMajor();
            int n4 = versionedLib4.version.getMajor();
            int n5 = versionedLib5.version.getMajor();
            int n6 = versionedLib6.version.getMajor();
            boolean bl3 = bl = !(avCodecMajorVersionCC != n || avFormatMajorVersionCC != n2 || avUtilMajorVersionCC != n3 || avDeviceMajorVersionCC != n4 && 0 != n4 || swResampleMajorVersionCC != n5 || swScaleMajorVersionCC != n6 && 0 != n6);
            if (!bl) {
                System.err.println("FFmpeg Not Matching Compile-Time / Runtime Major-Version");
            }
            if (!bl || DEBUG) {
                FFMPEGMediaPlayer.printNativeInfoImpl(System.err);
            }
        } else {
            natives = null;
            avUtilMajorVersionCC = 0;
            avFormatMajorVersionCC = 0;
            avCodecMajorVersionCC = 0;
            avDeviceMajorVersionCC = 0;
            swResampleMajorVersionCC = 0;
            swScaleMajorVersionCC = 0;
            bl = false;
        }
        available = bl2 && bl && null != natives;
    }
}

