/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.config;

import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class PostgreExplainPlanConfigurator
implements DBEObjectConfigurator<DBCQueryPlannerConfiguration> {
    private static boolean analyse;
    private static boolean verbose;
    private static boolean costs;
    private static boolean settings;
    private static boolean buffers;
    private static boolean wal;
    private static boolean timing;
    private static PostgreDataSource dataSource;

    public DBCQueryPlannerConfiguration configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object container, final @NotNull DBCQueryPlannerConfiguration configuration, @NotNull Map<String, Object> options) {
        DBPDataSource dbpDataSource;
        if (container instanceof DBCQueryPlanner && (dbpDataSource = ((DBCQueryPlanner)container).getDataSource()) instanceof PostgreDataSource) {
            dataSource = (PostgreDataSource)dbpDataSource;
        }
        return (DBCQueryPlannerConfiguration)new UITask<DBCQueryPlannerConfiguration>(this){

            protected DBCQueryPlannerConfiguration runTask() {
                PlanConfigDialog dialog = new PlanConfigDialog();
                if (dialog.open() == 0) {
                    Map parameters = configuration.getParameters();
                    parameters.put("ANALYZE", analyse);
                    parameters.put("VERBOSE", verbose);
                    if (PostgreExplainPlanConfigurator.isVersionSupports(9, 0)) {
                        parameters.put("COSTS", costs);
                        parameters.put("BUFFERS", buffers);
                    }
                    if (PostgreExplainPlanConfigurator.isVersionSupports(12, 0)) {
                        parameters.put("SETTINGS", settings);
                    }
                    if (PostgreExplainPlanConfigurator.isVersionSupports(13, 0)) {
                        parameters.put("WAL", wal);
                    }
                    if (PostgreExplainPlanConfigurator.isVersionSupports(9, 2)) {
                        parameters.put("TIMING", timing);
                    }
                    return configuration;
                }
                return null;
            }
        }.execute();
    }

    private static boolean isVersionSupports(int major, int minor) {
        return dataSource != null && dataSource.isServerVersionAtLeast(major, minor);
    }

    static {
        costs = true;
        timing = true;
    }

    private static class PlanConfigDialog
    extends BaseDialog {
        private Button walCheckbox;
        private Button timingCheckbox;
        private Button buffersCheckbox;

        public PlanConfigDialog() {
            super(UIUtils.getActiveWorkbenchShell(), PostgreMessages.dialog_query_planner_settings_title, null);
        }

        @NotNull
        protected Composite createDialogArea(@NotNull Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            final boolean isServerAtLeast13 = dataSource != null && dataSource.isServerVersionAtLeast(13, 0);
            boolean isServerAtLeast9 = dataSource != null && dataSource.isServerVersionAtLeast(9, 0);
            Composite settingsGroup = UIUtils.createTitledComposite((Composite)dialogArea, (String)PostgreMessages.dialog_query_planner_settings_control_label, (int)2, (int)1808);
            final Button analyseCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)PostgreMessages.dialog_query_planner_settings_analyze, (String)PostgreMessages.dialog_query_planner_settings_analyze_tip, (boolean)analyse, (int)2);
            analyseCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PlanConfigDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean analyseCheckboxSelection = analyseCheckbox.getSelection();
                    analyse = analyseCheckbox.getSelection();
                    if (this.this$0.walCheckbox != null) {
                        this.this$0.walCheckbox.setEnabled(analyseCheckboxSelection);
                        if (this.this$0.walCheckbox.getSelection() && !analyseCheckboxSelection) {
                            this.this$0.walCheckbox.setSelection(false);
                            wal = false;
                        }
                    }
                    if (this.this$0.timingCheckbox != null) {
                        this.this$0.timingCheckbox.setEnabled(analyseCheckboxSelection);
                        if (!analyseCheckboxSelection) {
                            timing = false;
                        } else if (this.this$0.timingCheckbox.getSelection() && !timing) {
                            timing = true;
                        }
                    }
                    if (this.this$0.buffersCheckbox != null && !isServerAtLeast13) {
                        this.this$0.buffersCheckbox.setEnabled(analyseCheckboxSelection);
                        if (this.this$0.buffersCheckbox.getSelection() && !analyseCheckboxSelection) {
                            this.this$0.buffersCheckbox.setSelection(false);
                            buffers = false;
                        }
                    }
                }
            });
            final Button verboseCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)PostgreMessages.dialog_query_planner_settings_verbose, (String)PostgreMessages.dialog_query_planner_settings_verbose_tip, (boolean)verbose, (int)2);
            verboseCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                public void widgetSelected(SelectionEvent e) {
                    verbose = verboseCheckbox.getSelection();
                }
            });
            if (isServerAtLeast9) {
                final Button costsCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)PostgreMessages.dialog_query_planner_settings_costs, (String)PostgreMessages.dialog_query_planner_settings_costs_tip, (boolean)costs, (int)2);
                costsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                    public void widgetSelected(SelectionEvent e) {
                        costs = costsCheckbox.getSelection();
                    }
                });
            }
            if (PostgreExplainPlanConfigurator.isVersionSupports(12, 0)) {
                final Button settingsCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)PostgreMessages.dialog_query_planner_settings, (String)PostgreMessages.dialog_query_planner_settings_tip, (boolean)settings, (int)2);
                settingsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(this){

                    public void widgetSelected(SelectionEvent e) {
                        settings = settingsCheckbox.getSelection();
                    }
                });
            }
            if (isServerAtLeast9) {
                this.buffersCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)PostgreMessages.dialog_query_planner_settings_buffers, (String)PostgreMessages.dialog_query_planner_settings_buffers_tip, (boolean)buffers, (int)2);
                this.buffersCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        buffers = buffersCheckbox.getSelection();
                    }
                });
                if (!isServerAtLeast13) {
                    this.buffersCheckbox.setEnabled(analyseCheckbox.getSelection());
                }
            }
            if (isServerAtLeast13) {
                this.walCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)PostgreMessages.dialog_query_planner_settings_wal, (String)PostgreMessages.dialog_query_planner_settings_wal_tip, (boolean)wal, (int)2);
                this.walCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        wal = walCheckbox.getSelection();
                    }
                });
                this.walCheckbox.setEnabled(analyseCheckbox.getSelection());
            }
            if (PostgreExplainPlanConfigurator.isVersionSupports(9, 2)) {
                this.timingCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)PostgreMessages.dialog_query_planner_settings_timing, (String)PostgreMessages.dialog_query_planner_settings_timing_tip, (boolean)timing, (int)2);
                this.timingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        timing = timingCheckbox.getSelection();
                    }
                });
                this.timingCheckbox.setEnabled(analyseCheckbox.getSelection());
            }
            return dialogArea;
        }
    }
}

