/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreUIUtils;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupRestoreSettings;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreDatabaseBackupSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreToolWizardPageSettings;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

class PostgreBackupWizardPageSettings
extends PostgreToolWizardPageSettings<PostgreBackupWizard> {
    private Combo formatCombo;
    private Combo compressCombo;
    private Combo encodingCombo;
    private Button useInsertsCheck;
    private Button noPrivilegesCheck;
    private Button noOwnerCheck;
    private Button dropObjects;
    private Button createDatabase;

    PostgreBackupWizardPageSettings(PostgreBackupWizard wizard) {
        super(wizard, PostgreMessages.wizard_backup_page_setting_title_setting);
        this.setTitle(PostgreMessages.wizard_backup_page_setting_title);
        this.setDescription(PostgreMessages.wizard_backup_page_setting_description);
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SelectionAdapter changeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreBackupWizardPageSettings.this.updateState();
            }
        };
        Composite formatGroup = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.wizard_backup_page_setting_group_setting, (int)2, (int)768);
        this.formatCombo = UIUtils.createLabelCombo((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_format, (int)12);
        this.formatCombo.setLayoutData((Object)new GridData(32));
        for (PostgreBackupRestoreSettings.ExportFormat format : PostgreBackupRestoreSettings.ExportFormat.values()) {
            this.formatCombo.add(format.getTitle());
        }
        PostgreDatabaseBackupSettings settings = (PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings();
        this.formatCombo.select(settings.getFormat().ordinal());
        this.formatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreBackupWizardPageSettings.this.fixOutputFileExtension();
                PostgreBackupWizardPageSettings.this.updateState();
            }
        });
        this.compressCombo = UIUtils.createLabelCombo((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_compression, (int)12);
        this.compressCombo.setLayoutData((Object)new GridData(32));
        this.compressCombo.add("");
        for (int i = 0; i <= 9; ++i) {
            String compStr = String.valueOf(i);
            this.compressCombo.add(compStr);
            if (!compStr.equals(settings.getCompression())) continue;
            this.compressCombo.select(i);
        }
        if (this.compressCombo.getSelectionIndex() < 0) {
            this.compressCombo.select(0);
        }
        this.compressCombo.addSelectionListener((SelectionListener)changeListener);
        UIUtils.createControlLabel((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_label_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)formatGroup, null);
        this.encodingCombo.addSelectionListener((SelectionListener)changeListener);
        this.encodingCombo.setText(settings.getEncoding());
        this.useInsertsCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_use_insert, (String)PostgreMessages.wizard_backup_page_setting_checkbox_use_insert_tip, (boolean)settings.isUseInserts(), (int)2);
        this.useInsertsCheck.addSelectionListener((SelectionListener)changeListener);
        this.noPrivilegesCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_privileges, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_privileges_tip, (boolean)settings.isNoPrivileges(), (int)2);
        this.noPrivilegesCheck.addSelectionListener((SelectionListener)changeListener);
        this.noOwnerCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_owner, (String)PostgreMessages.wizard_backup_page_setting_checkbox_no_owner_tip, (boolean)settings.isNoOwner(), (int)2);
        this.noOwnerCheck.addSelectionListener((SelectionListener)changeListener);
        this.dropObjects = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_drop_objects, (String)PostgreMessages.wizard_backup_page_setting_checkbox_drop_objects_tip, (boolean)settings.isDropObjects(), (int)2);
        this.dropObjects.addSelectionListener((SelectionListener)changeListener);
        this.createDatabase = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_page_setting_checkbox_create_database, (String)PostgreMessages.wizard_backup_page_setting_checkbox_create_database_tip, (boolean)settings.isCreateDatabase(), (int)2);
        this.createDatabase.addSelectionListener((SelectionListener)changeListener);
        Composite outputGroup = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.wizard_backup_page_setting_group_output, (int)2, (int)768);
        this.createOutputFolderInput(outputGroup, (AbstractImportExportSettings)settings);
        this.createExtraArgsInput(outputGroup);
        Composite extraGroup = UIUtils.createComposite((Composite)composite, (int)2);
        this.createSecurityGroup(extraGroup);
        PostgreUIUtils.addCompatibilityInfoLabelForForks(composite, this.wizard, null);
        this.setControl((Control)composite);
    }

    protected String getExtension() {
        return this.getChosenExportFormat().getExt();
    }

    protected void updateState() {
        this.saveState();
        this.updatePageCompletion();
        this.getContainer().updateButtons();
    }

    public void saveState() {
        super.saveState();
        PostgreDatabaseBackupSettings settings = (PostgreDatabaseBackupSettings)((PostgreBackupWizard)this.wizard).getSettings();
        String fileName = this.outputFolderText.getText();
        settings.setOutputFolderPattern(CommonUtils.isEmpty((String)fileName) ? null : fileName);
        settings.setOutputFilePattern(this.outputFileText.getText());
        settings.setFormat(this.getChosenExportFormat());
        settings.setCompression(this.compressCombo.getText());
        settings.setEncoding(this.encodingCombo.getText());
        settings.setUseInserts(this.useInsertsCheck.getSelection());
        settings.setNoPrivileges(this.noPrivilegesCheck.getSelection());
        settings.setNoOwner(this.noOwnerCheck.getSelection());
        settings.setDropObjects(this.dropObjects.getSelection());
        settings.setCreateDatabase(this.createDatabase.getSelection());
    }

    private PostgreBackupRestoreSettings.ExportFormat getChosenExportFormat() {
        return PostgreBackupRestoreSettings.ExportFormat.values()[this.formatCombo.getSelectionIndex()];
    }
}

