/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import com.dbeaver.jdbc.driver.libsql.LibSqlConstants;
import com.dbeaver.jdbc.driver.libsql.LibSqlException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import org.jkiss.code.NotNull;

public class LibSqlUtils {
    public static String quote(String identifier) {
        return "'" + identifier + "'";
    }

    public static String unquote(String name) {
        if (name == null) {
            return name;
        }
        if ((name = name.trim()).length() > 2 && (name.startsWith("`") && name.endsWith("`") || name.startsWith("\"") && name.endsWith("\"") || name.startsWith("[") && name.endsWith("]"))) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public static String escape(String val) {
        if (val.indexOf(39) == 1) {
            return val;
        }
        int len = val.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            if (val.charAt(i) == '\'') {
                buf.append('\'');
            }
            buf.append(val.charAt(i));
        }
        return buf.toString();
    }

    public static ResultSet executeQuery(Connection connection, String query) throws SQLException {
        try (Statement stat = connection.createStatement();){
            ResultSet resultSet = stat.executeQuery(query);
            return resultSet;
        }
    }

    @NotNull
    public static String validateAndFormatUrl(@NotNull String url) throws LibSqlException {
        Matcher matcher = LibSqlConstants.CONNECTION_URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new LibSqlException("Invalid connection URL: " + url + ".\nExpected URL formats: jdbc:dbeaver:libsql:<server-url>, libsql://");
        }
        String formattedUrl = url;
        if (formattedUrl.startsWith("jdbc:dbeaver:libsql:")) {
            formattedUrl = formattedUrl.replaceFirst("jdbc:dbeaver:libsql:", "");
        }
        if (formattedUrl.startsWith("libsql://")) {
            formattedUrl = formattedUrl.replaceFirst("libsql://", "https://");
        }
        return formattedUrl;
    }
}

