/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.gis.IGeometryValueEditor;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.gis.panel.GISEditorUtils;
import org.jkiss.dbeaver.ui.gis.panel.GISLeafletViewer;
import org.jkiss.dbeaver.ui.gis.panel.SelectSRIDDialog;
import org.jkiss.dbeaver.ui.gis.panel.SetCRSAction;

class SelectCRSAction
extends Action {
    private IGeometryValueEditor valueEditor;

    SelectCRSAction(IGeometryValueEditor valueEditor) {
        super((String)(valueEditor.getValueSRID() == 0 ? "Simple" : "EPSG:" + valueEditor.getValueSRID()), 4);
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CHART_LINE));
        this.valueEditor = valueEditor;
    }

    public void run() {
        if (this.valueEditor instanceof GISLeafletViewer && Arrays.stream(((GISLeafletViewer)this.valueEditor).getCurrentValue()).map(DBGeometry::getSRID).distinct().count() > 1L) {
            DBWorkbench.getPlatformUI().showWarningMessageBox("Warning", "Can't change coordinate reference system because geometries have different SRID.");
        } else {
            SelectSRIDDialog manageCRSDialog = new SelectSRIDDialog(UIUtils.getActiveWorkbenchShell(), this.valueEditor.getValueSRID());
            if (manageCRSDialog.open() == 0) {
                this.valueEditor.setValueSRID(manageCRSDialog.getSelectedSRID());
            }
        }
    }

    public IMenuCreator getMenuCreator() {
        return new MenuCreator(control -> {
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(manager -> {
                menuManager.add((IAction)new SetCRSAction(this.valueEditor, 4326));
                menuManager.add((IAction)new SetCRSAction(this.valueEditor, 3857));
                menuManager.add((IAction)new SetCRSAction(this.valueEditor, 3395));
                menuManager.add((IAction)new SetCRSAction(this.valueEditor, 0));
                menuManager.add((IContributionItem)new Separator());
                List<Integer> recentSRIDs = GISEditorUtils.getRecentSRIDs();
                if (!recentSRIDs.isEmpty()) {
                    for (Integer recentSRID : recentSRIDs) {
                        menuManager.add((IAction)new SetCRSAction(this.valueEditor, recentSRID));
                    }
                    menuManager.add((IContributionItem)new Separator());
                }
                menuManager.add((IAction)new Action(GISMessages.panel_select_crs_action_menu_manager_other){

                    public void run() {
                        SelectCRSAction.this.run();
                    }
                });
                menuManager.add((IAction)new Action(this, GISMessages.panel_select_crs_action_menu_manager_config){

                    public void run() {
                        UIUtils.showPreferencesFor(null, null, (String[])new String[]{"org.jkiss.dbeaver.preferences.gis"});
                    }
                });
            });
            return menuManager;
        });
    }
}

