/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dnd.TreeNodeTransfer;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectCreateBase;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerObjectCreateCopy
extends NavigatorHandlerObjectCreateBase {
    static final Log log = Log.getLog(NavigatorHandlerObjectCreateCopy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Control focusControl = activeShell.getDisplay().getFocusControl();
        if (focusControl instanceof Text) {
            ((Text)focusControl).paste();
            return null;
        }
        if (focusControl instanceof StyledText) {
            ((StyledText)focusControl).paste();
            return null;
        }
        if (focusControl instanceof Combo) {
            ((Combo)focusControl).paste();
            return null;
        }
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        DBNNode curNode = NavigatorUtils.getSelectedNode(selection);
        if (curNode == null) {
            return null;
        }
        DBPProject toProject = curNode.getOwnerProject();
        Clipboard clipboard = new Clipboard(Display.getDefault());
        LinkedList<String> failedToPasteResources = new LinkedList<String>();
        try {
            Collection cbNodes = (Collection)clipboard.getContents((Transfer)TreeNodeTransfer.getInstance());
            if (cbNodes != null) {
                for (DBNNode nodeObject : cbNodes) {
                    if (!(nodeObject instanceof DBNResource) || !(curNode instanceof DBNResource) || toProject.hasRealmPermission("project-resource-edit")) continue;
                    failedToPasteResources.add(nodeObject.getName());
                }
                if (failedToPasteResources.isEmpty()) {
                    if (curNode instanceof DBNPathBase) {
                        DBNPathBase pathTarget = (DBNPathBase)curNode;
                        try {
                            UIUtils.runWithMonitor(monitor -> {
                                pathTarget.dropNodes(monitor, cbNodes);
                                return null;
                            });
                        }
                        catch (DBException e) {
                            DBWorkbench.getPlatformUI().showError("Paste error", "Can't paste nodes", (Throwable)e);
                            failedToPasteResources.addAll(cbNodes.stream().map(DBNNode::getNodeDisplayName).toList());
                        }
                    } else {
                        for (DBNNode nodeObject : cbNodes) {
                            if (nodeObject instanceof DBNDatabaseNode) {
                                DBNDatabaseNode otherNode = (DBNDatabaseNode)nodeObject;
                                this.createNewObject(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), curNode, otherNode);
                                continue;
                            }
                            if (curNode instanceof DBNResource) {
                                DBNResource currentResource = (DBNResource)curNode;
                                try {
                                    UIUtils.runWithMonitor(monitor -> {
                                        this.pastNodeToResource(monitor, currentResource, nodeObject);
                                        return null;
                                    });
                                }
                                catch (DBException e) {
                                    DBWorkbench.getPlatformUI().showError("Paste error", "Can't paste node '" + nodeObject.getName() + "'", (Throwable)e);
                                    failedToPasteResources.add(nodeObject.getName());
                                }
                                continue;
                            }
                            log.error((Object)("Paste is not supported for " + String.valueOf(curNode)));
                        }
                    }
                }
            } else if (curNode instanceof DBNResource) {
                String[] files = (String[])clipboard.getContents((Transfer)FileTransfer.getInstance());
                if (files != null) {
                    File file;
                    for (String fileName : files) {
                        file = new File(fileName);
                        if (!file.exists() || toProject.hasRealmPermission("project-resource-edit")) continue;
                        failedToPasteResources.add(fileName);
                    }
                    if (failedToPasteResources.isEmpty()) {
                        for (String fileName : files) {
                            file = new File(fileName);
                            if (!file.exists()) continue;
                            this.pasteResource(file, (DBNResource)curNode);
                        }
                    }
                } else {
                    log.debug((Object)"Paste error: unsupported clipboard format. File or folder were expected.");
                    Display.getCurrent().beep();
                }
            } else {
                log.debug((Object)"Paste error: clipboard contains data in unsupported format");
                Display.getCurrent().beep();
            }
            if (!failedToPasteResources.isEmpty()) {
                DBWorkbench.getPlatformUI().showError(UINavigatorMessages.failed_to_paste_due_to_permissions_title, NLS.bind((String)UINavigatorMessages.failed_to_paste_due_to_permissions_message, (Object)toProject.getDisplayName(), (Object)String.join((CharSequence)",\n", failedToPasteResources)));
            }
        }
        finally {
            clipboard.dispose();
        }
        return null;
    }

    private void pastNodeToResource(@NotNull DBRProgressMonitor monitor, @NotNull DBNResource currentNode, @NotNull DBNNode nodeToPaste) throws DBException {
        if (currentNode.supportsPaste(nodeToPaste)) {
            currentNode.pasteNodes(List.of(nodeToPaste));
        } else if (nodeToPaste instanceof DBNResource) {
            DBNResource fromResource = (DBNResource)nodeToPaste;
            this.pasteResource(fromResource, currentNode);
        } else if (currentNode.supportsDrop(nodeToPaste)) {
            currentNode.dropNodes(monitor, List.of(nodeToPaste));
        } else {
            log.error((Object)("Paste or drop is not supported for " + String.valueOf(currentNode)));
        }
    }

    private void pasteResource(DBNResource resourceNode, DBNResource toFolder) {
        IResource resource = resourceNode.getResource();
        IResource targetResource = toFolder.getResource();
        IContainer targetFolder = targetResource instanceof IContainer ? (IContainer)targetResource : targetResource.getParent();
        try {
            UIUtils.runInProgressService(monitor -> {
                try {
                    this.copyResource(monitor, resource, targetFolder);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Copy error", "Error copying resource", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void copyResource(@NotNull DBRProgressMonitor monitor, @NotNull IResource resource, @NotNull IContainer targetFolder) throws CoreException, IOException {
        Object targetName;
        IProgressMonitor nestedMonitor;
        block18: {
            nestedMonitor = RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor);
            String extension = resource.getFileExtension();
            targetName = resource.getName();
            if (resource.getParent().equals((Object)targetFolder)) {
                String plainName = extension != null && !extension.isEmpty() && ((String)targetName).endsWith(extension) ? ((String)targetName).substring(0, ((String)targetName).length() - extension.length() - 1) : targetName;
                int i = 1;
                while (true) {
                    Object testName = plainName + "-" + i;
                    if (!CommonUtils.isEmpty((String)extension)) {
                        testName = (String)testName + "." + extension;
                    }
                    if (targetFolder.findMember((String)testName) == null) {
                        targetName = testName;
                        break block18;
                    }
                    ++i;
                }
            }
            if (targetFolder.findMember((String)targetName) != null) {
                throw new IOException("Target resource '" + (String)targetName + "' already exists");
            }
        }
        if (resource instanceof IFile) {
            Map props;
            IFile targetFile;
            if (targetFolder instanceof IFolder && !targetFolder.exists()) {
                ((IFolder)targetFolder).create(true, true, nestedMonitor);
            }
            if (!(targetFile = targetFolder.getFile((IPath)new Path((String)targetName))).exists()) {
                targetFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, nestedMonitor);
            }
            if ((props = resource.getPersistentProperties()) != null && !props.isEmpty()) {
                for (Map.Entry entry : props.entrySet()) {
                    targetFile.setPersistentProperty((QualifiedName)entry.getKey(), (String)entry.getValue());
                }
            }
            try (InputStream is = ((IFile)resource).getContents();){
                targetFile.setContents(is, true, true, nestedMonitor);
            }
        } else if (resource instanceof IFolder) {
            // empty if block
        }
    }

    private void pasteResource(File file, DBNResource toFolder) {
        IContainer container;
        IResource targetResource = toFolder.getResource();
        IContainer targetFolder = targetResource instanceof IContainer ? (container = (IContainer)targetResource) : targetResource.getParent();
        try {
            UIUtils.runInProgressService(monitor -> {
                try {
                    this.copyFileInFolder(monitor, targetFolder, file);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Copy error", "Error copying resource", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void copyFileInFolder(DBRProgressMonitor monitor, IContainer targetFolder, File file) throws IOException, CoreException {
        block10: {
            block9: {
                File[] folderFile;
                if (monitor.isCanceled()) {
                    return;
                }
                if (!file.isDirectory()) break block9;
                IFolder subFolder = targetFolder.getFolder((IPath)new Path(file.getName()));
                if (!subFolder.exists()) {
                    subFolder.create(true, true, monitor.getNestedMonitor());
                }
                if ((folderFile = file.listFiles()) == null) break block10;
                for (File subFile : folderFile) {
                    this.copyFileInFolder(monitor, (IContainer)subFolder, subFile);
                }
                break block10;
            }
            IFile targetFile = targetFolder.getFile((IPath)new Path(file.getName()));
            if (targetFile.exists()) {
                throw new IOException("Target file '" + String.valueOf(targetFile.getFullPath()) + "' already exists");
            }
            try (FileInputStream is = new FileInputStream(file);){
                targetFile.create((InputStream)is, true, monitor.getNestedMonitor());
            }
        }
    }
}

