/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

public enum DataExporterArrayFormat {
    SQUARE_BRACKETS('[', ']'),
    CURLY_BRACKETS('{', '}'),
    BRACKETS('(', ')');

    private char prefix;
    private char suffix;

    private DataExporterArrayFormat(char prefix, char suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static DataExporterArrayFormat getArrayFormat(String bracketPair) {
        for (DataExporterArrayFormat df : DataExporterArrayFormat.values()) {
            if ((bracketPair = bracketPair.trim()).charAt(0) != df.prefix || bracketPair.charAt(bracketPair.length() - 1) != df.suffix) continue;
            return df;
        }
        throw new IllegalStateException("No suitable DataExporterArrayFormat found");
    }

    public static DataExporterArrayFormat getArrayFormatOnPrefix(char prefix) {
        for (DataExporterArrayFormat df : DataExporterArrayFormat.values()) {
            if (prefix != df.prefix) continue;
            return df;
        }
        return CURLY_BRACKETS;
    }

    public char getPrefix() {
        return this.prefix;
    }

    public char getSuffix() {
        return this.suffix;
    }
}

