/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.engine.AIEngineProperties;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIEngineRegistry;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionCategoryDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsEventListener;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PropertySerializationUtils;
import org.jkiss.utils.CommonUtils;

public class AISettingsManager {
    private static final Log log = Log.getLog(AISettingsManager.class);
    public static final String AI_CONFIGURATION_FILE_NAME = "ai-configuration.json";
    private static final String AI_DISABLED_KEY = "aiDisabled";
    private static final String ACTIVE_ENGINE_KEY = "activeEngine";
    private static final String PROPERTIES_KEY = "properties";
    private static final String ENGINE_CONFIGURATIONS_KEY = "engineConfigurations";
    private static final String FUNCTIONS_ENABLED_KEY = "functionsEnabled";
    private static final String ENABLED_FUNCTION_CATEGORIES_KEY = "enabledFunctionCategories";
    private static final String ENABLED_FUNCTIONS_KEY = "enabledFunctions";
    private static final String INITIALIZED_DEFAULT_CATEGORIES_KEY = "initializedDefaultCategories";
    private static final String CUSTOM_INSTRUCTIONS_KEY = "customInstructions";
    public static final String ENGINE_PROPERTIES = "properties";
    private static AISettingsManager instance = null;
    public static final Gson READ_PROPS_GSON = AISettingsManager.createPropertiesLoadGson();
    public static final Gson SAVE_PROPS_GSON = AISettingsManager.createPropertiesSaveGson();
    private final Set<AISettingsEventListener> settingsChangedListeners = Collections.synchronizedSet(new HashSet());

    private AISettingsManager() {
        WorkspaceConfigEventManager.addConfigChangedListener((String)AI_CONFIGURATION_FILE_NAME, o -> {
            this.getSettingsHolder().reset();
            this.raiseChangedEvent(this);
        });
    }

    public static synchronized AISettingsManager getInstance() {
        if (instance == null) {
            instance = new AISettingsManager();
        }
        return instance;
    }

    public void addChangedListener(AISettingsEventListener listener) {
        this.settingsChangedListeners.add(listener);
    }

    public void removeChangedListener(AISettingsEventListener listener) {
        this.settingsChangedListeners.remove(listener);
    }

    private void raiseChangedEvent(AISettingsManager registry) {
        for (AISettingsEventListener listener : (AISettingsEventListener[])this.settingsChangedListeners.toArray(AISettingsEventListener[]::new)) {
            listener.onSettingsUpdate(registry);
        }
    }

    private AISettingsHolder getSettingsHolder() {
        return AISettingsLocalHolder.INSTANCE;
    }

    @NotNull
    public AISettings getSettings() {
        return this.getSettingsHolder().getSettings();
    }

    @NotNull
    private static AISettings loadSettingsFromConfig() {
        Map configMap = null;
        try {
            String content = AISettingsManager.loadConfig();
            if (!CommonUtils.isEmpty((String)content)) {
                configMap = (Map)READ_PROPS_GSON.fromJson((Reader)new StringReader(content), JSONUtils.MAP_TYPE_TOKEN);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading AI settings, falling back to defaults.", (Throwable)e);
        }
        if (configMap == null) {
            configMap = new LinkedHashMap();
        }
        AISettings settings = new AISettings();
        LinkedHashMap<String, AIEngineProperties> engineConfigurationMap = new LinkedHashMap<String, AIEngineProperties>();
        if (!configMap.isEmpty()) {
            Map customInstructions;
            List initializedCategories;
            settings.setAiDisabled(JSONUtils.getBoolean(configMap, (String)AI_DISABLED_KEY));
            settings.setActiveEngine(JSONUtils.getString(configMap, (String)ACTIVE_ENGINE_KEY));
            JSONUtils.getObject(configMap, (String)"properties").forEach(settings::setProperty);
            List enabledCategories = JSONUtils.getStringList(configMap, (String)ENABLED_FUNCTION_CATEGORIES_KEY);
            if (!enabledCategories.isEmpty()) {
                settings.getFunctionSettings().setEnabledFunctionCategories(new HashSet<String>(enabledCategories));
            }
            settings.getFunctionSettings().setFunctionsEnabled(JSONUtils.getBoolean(configMap, (String)FUNCTIONS_ENABLED_KEY, (boolean)true));
            List enabledFunctions = JSONUtils.getStringList(configMap, (String)ENABLED_FUNCTIONS_KEY);
            if (!enabledFunctions.isEmpty()) {
                settings.getFunctionSettings().setEnabledFunctions(new HashSet<String>(enabledFunctions));
            }
            if (!(initializedCategories = JSONUtils.getStringList(configMap, (String)INITIALIZED_DEFAULT_CATEGORIES_KEY)).isEmpty()) {
                settings.getFunctionSettings().setInitializedDefaultCategories(new HashSet<String>(initializedCategories));
            }
            if (!CommonUtils.isEmpty((Map)(customInstructions = (Map)configMap.get(CUSTOM_INSTRUCTIONS_KEY)))) {
                settings.setCustomInstructions(customInstructions);
            }
            Map ecRoot = JSONUtils.getObject(configMap, (String)ENGINE_CONFIGURATIONS_KEY);
            for (Map.Entry entry : ecRoot.entrySet()) {
                String engineId = (String)entry.getKey();
                AIEngineDescriptor engineDescriptor = AIEngineRegistry.getInstance().getEngineDescriptor(engineId);
                if (engineDescriptor == null) {
                    log.error((Object)("AI engine '" + engineId + "' not found. Ignore config"));
                    continue;
                }
                Object v = entry.getValue();
                if (!(v instanceof Map)) continue;
                Map map = (Map)v;
                try {
                    Map properties = JSONUtils.getObject((Map)map, (String)"properties");
                    JsonElement engineConfigTree = READ_PROPS_GSON.toJsonTree((Object)properties, Map.class);
                    AIEngineProperties engineSettings = (AIEngineProperties)READ_PROPS_GSON.fromJson(engineConfigTree, engineDescriptor.getPropertiesType());
                    engineConfigurationMap.put(engineDescriptor.getId(), engineSettings);
                }
                catch (JsonSyntaxException e) {
                    log.error((Object)("Error parsing '" + engineId + "' properties"), (Throwable)e);
                }
            }
        }
        AIFunctionRegistry functionRegistry = AIFunctionRegistry.getInstance();
        Map<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>> functionsByCategory = functionRegistry.getFunctionsByCategory();
        for (Map.Entry<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>> entry : functionsByCategory.entrySet()) {
            AIFunctionCategoryDescriptor category = entry.getKey();
            List<AIFunctionDescriptor> functions = entry.getValue();
            if (!category.isEnabledByDefault() || settings.getFunctionSettings().isCategoryInitialized(category.getId())) continue;
            settings.getFunctionSettings().enableFunctionCategory(category.getId());
            for (AIFunctionDescriptor function : functions) {
                settings.getFunctionSettings().enableFunction(function.getId());
            }
            settings.getFunctionSettings().markCategoryAsInitialized(category.getId());
        }
        settings.setEngineConfigurations(engineConfigurationMap);
        if (settings.activeEngine() == null || !settings.hasConfiguration(settings.activeEngine())) {
            settings.setActiveEngine("openai");
        }
        return settings;
    }

    public void modifySettings(@NotNull Consumer<AISettings> consumer) {
        AISettings settings = this.getSettings();
        consumer.accept(settings);
        this.saveSettings(settings);
    }

    public void saveSettings(@NotNull AISettings settings) {
        try {
            Map<String, String> map;
            Set<String> initializedCategories;
            Set<String> enabledFunctions;
            if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
                log.warn((Object)"The user has no permission to save AI configuration");
                return;
            }
            JsonObject json = new JsonObject();
            json.addProperty(AI_DISABLED_KEY, Boolean.valueOf(settings.isAiDisabled()));
            json.addProperty(ACTIVE_ENGINE_KEY, settings.activeEngine());
            JsonObject propertiesObject = new JsonObject();
            for (Map.Entry<String, Object> property : settings.getAllProperties().entrySet()) {
                JsonElement propValue = SAVE_PROPS_GSON.toJsonTree(property.getValue());
                propertiesObject.add(property.getKey(), propValue);
            }
            json.add("properties", (JsonElement)propertiesObject);
            json.add(FUNCTIONS_ENABLED_KEY, (JsonElement)new JsonPrimitive(Boolean.valueOf(settings.getFunctionSettings().isFunctionsEnabled())));
            Set<String> enabledCategories = settings.getFunctionSettings().getEnabledFunctionCategories();
            if (!enabledCategories.isEmpty()) {
                JsonArray categoriesArray = new JsonArray();
                for (String string : enabledCategories) {
                    categoriesArray.add(string);
                }
                json.add(ENABLED_FUNCTION_CATEGORIES_KEY, (JsonElement)categoriesArray);
            }
            if (!(enabledFunctions = settings.getFunctionSettings().getEnabledFunctions()).isEmpty()) {
                JsonArray functionsArray = new JsonArray();
                for (String string : enabledFunctions) {
                    functionsArray.add(string);
                }
                json.add(ENABLED_FUNCTIONS_KEY, (JsonElement)functionsArray);
            }
            if (!(initializedCategories = settings.getFunctionSettings().getInitializedDefaultCategories()).isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (String string : initializedCategories) {
                    jsonArray.add(string);
                }
                json.add(INITIALIZED_DEFAULT_CATEGORIES_KEY, (JsonElement)jsonArray);
            }
            if (!(map = settings.getCustomInstructions()).isEmpty()) {
                JsonObject jsonObject = new JsonObject();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    jsonObject.addProperty(entry.getKey(), entry.getValue());
                }
                json.add(CUSTOM_INSTRUCTIONS_KEY, (JsonElement)jsonObject);
            }
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry<String, AIEngineProperties> entry : settings.getEngineConfigurations().entrySet()) {
                JsonObject jo;
                JsonElement savedProps = SAVE_PROPS_GSON.toJsonTree((Object)entry.getValue());
                if (!(savedProps instanceof JsonObject) || (jo = (JsonObject)savedProps).isEmpty()) continue;
                JsonObject props = new JsonObject();
                props.add("properties", savedProps);
                jsonObject.add(entry.getKey(), (JsonElement)props);
            }
            json.add(ENGINE_CONFIGURATIONS_KEY, (JsonElement)jsonObject);
            String string = SAVE_PROPS_GSON.toJson((JsonElement)json);
            DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(AI_CONFIGURATION_FILE_NAME, string);
            if (!AISettingsManager.saveSecretsAsPlainText()) {
                settings.saveSecrets();
            }
            this.getSettingsHolder().setSettings(settings);
        }
        catch (Exception e) {
            log.error((Object)"Error saving AI configuration", (Throwable)e);
        }
        this.raiseChangedEvent(this);
    }

    @Nullable
    private static String loadConfig() throws DBException {
        return DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(AI_CONFIGURATION_FILE_NAME);
    }

    public static boolean isConfigExists() throws DBException {
        String content = AISettingsManager.loadConfig();
        return CommonUtils.isNotEmpty((String)content);
    }

    public static boolean saveSecretsAsPlainText() {
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        return application.isMultiuser() || application.isDistributed();
    }

    @NotNull
    private static Gson createPropertiesLoadGson() {
        return new GsonBuilder().setStrictness(Strictness.LENIENT).create();
    }

    @NotNull
    private static Gson createPropertiesSaveGson() {
        if (AISettingsManager.saveSecretsAsPlainText()) {
            return AISettingsManager.createPropertiesLoadGson();
        }
        return PropertySerializationUtils.baseNonSecurePropertiesGsonBuilder().create();
    }

    private static class AISettingsLocalHolder
    implements AISettingsHolder {
        public static final AISettingsHolder INSTANCE = new AISettingsLocalHolder();
        private AISettings settings = null;

        private AISettingsLocalHolder() {
        }

        @Override
        public synchronized AISettings getSettings() {
            if (this.settings == null) {
                AISettings loaded = AISettingsManager.loadSettingsFromConfig();
                if (this.settings == null) {
                    this.settings = loaded;
                }
            }
            return this.settings;
        }

        @Override
        public synchronized void setSettings(AISettings mruSettings) {
            this.settings = mruSettings;
        }

        @Override
        public synchronized void reset() {
            this.settings = null;
        }
    }

    private static interface AISettingsHolder {
        public AISettings getSettings();

        public void setSettings(AISettings var1);

        public void reset();
    }
}

