/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rcp;

import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.impl.app.BaseProjectImpl;
import org.jkiss.dbeaver.model.impl.app.BaseWorkspaceImpl;
import org.jkiss.dbeaver.model.rcp.DesktopProjectImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.registry.internal.RegistryMessages;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class EclipseWorkspaceImpl
extends BaseWorkspaceImpl
implements DBPWorkspaceEclipse {
    private static final Log log = Log.getLog(EclipseWorkspaceImpl.class);
    private final String workspaceId;
    private final ProjectListener projectListener;
    private final IWorkspace eclipseWorkspace;
    protected final Map<IProject, DesktopProjectImpl> projects = new LinkedHashMap<IProject, DesktopProjectImpl>();
    private final List<DBPProjectListener> projectListeners = new ArrayList<DBPProjectListener>();

    public EclipseWorkspaceImpl(DBPPlatform platform, IWorkspace eclipseWorkspace) {
        super(platform, eclipseWorkspace.getRoot().getLocation().toPath());
        this.eclipseWorkspace = eclipseWorkspace;
        this.workspaceId = this.initWorkspaceId();
        if (!this.isReadOnly()) {
            this.projectListener = new ProjectListener();
            this.getEclipseWorkspace().addResourceChangeListener((IResourceChangeListener)this.projectListener);
        } else {
            this.projectListener = null;
        }
    }

    @Override
    @NotNull
    public IWorkspace getEclipseWorkspace() {
        return this.eclipseWorkspace;
    }

    public final void initializeProjects() {
        this.initializeWorkspaceSession();
        try {
            this.loadWorkspaceProjects();
        }
        catch (DBException ex) {
            log.error((Object)"Can't load workspace projects", (Throwable)ex);
        }
        if (DBWorkbench.getPlatform().getApplication().isStandalone() && CommonUtils.isEmpty(this.projects) && this.isDefaultProjectNeeded() && !this.isReadOnly()) {
            try {
                this.createDefaultProject();
            }
            catch (CoreException e) {
                log.error((Object)"Can't create default project", (Throwable)e);
            }
        }
        if (this.getActiveProject() == null && !this.projects.isEmpty() && !this.isReadOnly()) {
            this.setActiveProject(this.projects.values().iterator().next());
        }
        if (this.activeProject != null && !this.activeProject.isOpen()) {
            try {
                this.activeProject.ensureOpen();
            }
            catch (IllegalStateException e) {
                log.error((Object)"Error opening active project", (Throwable)e);
            }
        }
    }

    @Override
    public void setActiveProject(@NotNull DBPProject project) {
        DBPProject oldActiveProject = this.activeProject;
        this.activeProject = project;
        if (!CommonUtils.equalObjects((Object)oldActiveProject, (Object)project)) {
            this.platform.getPreferenceStore().setValue("project.active", project == null ? "" : project.getName());
            this.fireActiveProjectChange(oldActiveProject, this.activeProject);
        }
    }

    @NotNull
    public List<DBPProject> getProjects() {
        return new ArrayList<DBPProject>(this.projects.values());
    }

    @Nullable
    public DBPProject getProject(@NotNull IProject project) {
        return this.projects.get(project);
    }

    @Nullable
    public DBPProject getProject(@NotNull String projectName) {
        IProject eProject = this.eclipseWorkspace.getRoot().getProject(projectName);
        if (!eProject.exists()) {
            return null;
        }
        return this.getProject(eProject);
    }

    protected boolean isDefaultProjectNeeded() {
        return DBWorkbench.getPlatform().getApplication().getDefaultProjectName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectListener(@NotNull DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectListener(@NotNull DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.projectListener != null) {
            this.getEclipseWorkspace().removeResourceChangeListener((IResourceChangeListener)this.projectListener);
        }
        if (!this.projectListeners.isEmpty()) {
            log.warn((Object)("Some project listeners are still register: " + String.valueOf(this.projectListeners)));
            this.projectListeners.clear();
        }
        Map<IProject, DesktopProjectImpl> map = this.projects;
        synchronized (map) {
            for (BaseProjectImpl baseProjectImpl : this.projects.values()) {
                baseProjectImpl.dispose();
            }
            this.projects.clear();
        }
        super.dispose();
    }

    protected void loadWorkspaceProjects() throws DBException {
        String activeProjectName = this.getPlatform().getPreferenceStore().getString("project.active");
        IWorkspaceRoot root = this.getEclipseWorkspace().getRoot();
        Object[] allProjects = root.getProjects();
        if (ArrayUtils.isEmpty((Object[])allProjects)) {
            try {
                DBWorkbench.getPlatformUI().executeWithProgressBlocking("Reload", (DBRRunnableWithResult)new DBRRunnableWithResult<Future<Object>>(){

                    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        EclipseWorkspaceImpl.this.reloadWorkspace(monitor);
                    }
                });
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
            allProjects = root.getProjects();
        }
        for (Object project : allProjects) {
            if (!project.exists() || project.isHidden() || !this.isProjectAccessible((IProject)project)) continue;
            DesktopProjectImpl projectMetadata = this.projects.get(project);
            if (projectMetadata == null) {
                projectMetadata = this.createProjectFrom((IProject)project);
            }
            this.projects.put((IProject)project, projectMetadata);
            if (this.activeProject == null || !CommonUtils.isEmpty((String)activeProjectName) && project.getName().equals(activeProjectName)) {
                this.activeProject = projectMetadata;
            }
            projectMetadata.hideConfigurationFiles();
        }
    }

    protected void reloadWorkspace(DBRProgressMonitor monitor) {
    }

    protected boolean isProjectAccessible(IProject project) {
        return true;
    }

    protected DesktopProjectImpl createProjectFrom(IProject project) {
        return new DesktopProjectImpl(this, project, this.getAuthContext());
    }

    private IProject createDefaultProject() throws CoreException {
        String baseProjectName = DBWorkbench.getPlatform().getApplication().getDefaultProjectName();
        Object projectName = baseProjectName;
        int i = 1;
        while (true) {
            IProject project;
            if (!(project = this.getEclipseWorkspace().getRoot().getProject((String)projectName)).exists()) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                project.create((IProgressMonitor)monitor);
                project.open((IProgressMonitor)monitor);
                IProjectDescription description = this.getEclipseWorkspace().newProjectDescription(project.getName());
                description.setComment(RegistryMessages.project_description_comment);
                description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
                project.setDescription(description, (IProgressMonitor)monitor);
                return project;
            }
            projectName = baseProjectName + i;
            ++i;
        }
    }

    @NotNull
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @Override
    public void save(DBRProgressMonitor monitor) throws DBException {
        try {
            this.eclipseWorkspace.save(true, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            throw new DBException("Error saving Eclipse workspace", (Throwable)e);
        }
    }

    protected void fireProjectAdd(BaseProjectImpl project) {
        for (DBPProjectListener listener : this.getListenersCopy()) {
            listener.handleProjectAdd((DBPProject)project);
        }
    }

    protected void fireProjectRemove(BaseProjectImpl project) {
        for (DBPProjectListener listener : this.getListenersCopy()) {
            listener.handleProjectRemove((DBPProject)project);
        }
    }

    protected void fireActiveProjectChange(DBPProject oldActiveProject, DBPProject activeProject) {
        for (DBPProjectListener listener : this.getListenersCopy()) {
            listener.handleActiveProjectChange(oldActiveProject, activeProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DBPProjectListener[] getListenersCopy() {
        DBPProjectListener[] listeners;
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            listeners = this.projectListeners.toArray(new DBPProjectListener[0]);
        }
        return listeners;
    }

    private void handleResourceChange(DesktopProjectImpl projectMetadata, IResourceDelta delta) {
        if (delta.getKind() == 2) {
            IPath movedToPath = delta.getMovedToPath();
            if (movedToPath != null) {
                IPath oldPath = delta.getProjectRelativePath();
                IPath newPath = movedToPath.makeRelativeTo(projectMetadata.getEclipseProject().getFullPath());
                projectMetadata.moveResourceCache(oldPath, newPath);
            } else {
                projectMetadata.removeResourceFromCache(delta.getProjectRelativePath());
            }
        } else {
            for (IResourceDelta childDelta : delta.getAffectedChildren(31, 8)) {
                this.handleResourceChange(projectMetadata, childDelta);
            }
        }
    }

    protected String initWorkspaceId() {
        Path workspaceConfigPath = this.getAbsolutePath();
        if (!Files.exists(workspaceConfigPath.resolve("dbeaver-workspace.properties"), new LinkOption[0])) {
            workspaceConfigPath = this.getMetadataFolder();
        }
        return EclipseWorkspaceImpl.readWorkspaceId((Path)workspaceConfigPath);
    }

    public boolean isAdmin() {
        return this.hasRealmPermission("admin");
    }

    private class ProjectListener
    implements IResourceChangeListener {
        private ProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                Arrays.stream(event.getDelta().getAffectedChildren()).filter(delta -> delta.getResource() instanceof IProject).sorted(Comparator.comparingInt(IResourceDelta::getKind).reversed()).forEach(delta -> {
                    IProject project = (IProject)delta.getResource();
                    if (!EclipseWorkspaceImpl.this.projects.containsKey(project)) {
                        if (delta.getKind() == 1) {
                            DesktopProjectImpl projectMetadata = EclipseWorkspaceImpl.this.createProjectFrom(project);
                            EclipseWorkspaceImpl.this.projects.put(project, projectMetadata);
                            EclipseWorkspaceImpl.this.fireProjectAdd(projectMetadata);
                            if (EclipseWorkspaceImpl.this.activeProject == null) {
                                EclipseWorkspaceImpl.this.activeProject = projectMetadata;
                                EclipseWorkspaceImpl.this.fireActiveProjectChange(null, EclipseWorkspaceImpl.this.activeProject);
                            }
                        }
                    } else if (delta.getKind() == 2) {
                        DesktopProjectImpl projectMetadata = EclipseWorkspaceImpl.this.projects.remove(project);
                        projectMetadata.dispose();
                        EclipseWorkspaceImpl.this.fireProjectRemove(projectMetadata);
                        if (projectMetadata == EclipseWorkspaceImpl.this.activeProject) {
                            EclipseWorkspaceImpl.this.activeProject = null;
                            EclipseWorkspaceImpl.this.fireActiveProjectChange(projectMetadata, null);
                        }
                    } else {
                        DesktopProjectImpl projectMetadata = EclipseWorkspaceImpl.this.projects.get(project);
                        if (projectMetadata != null) {
                            EclipseWorkspaceImpl.this.handleResourceChange(projectMetadata, (IResourceDelta)delta);
                        }
                    }
                });
            }
        }
    }
}

