/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFile;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFolder;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class EFSNIOContainer
extends EFSNIOResource
implements IContainer {
    protected EFSNIOContainer(EFSNIOFileSystemRoot root, java.nio.file.Path path) {
        super(root, path);
    }

    public int getType() {
        return 0;
    }

    public boolean exists(IPath path) {
        IResource member = this.findMember(path);
        return member.exists();
    }

    public IResource findMember(IPath path) {
        if (path.isEmpty()) {
            return this;
        }
        java.nio.file.Path member = this.getNioPath().resolve(path.toString());
        LinkedList<java.nio.file.Path> backendResources = new LinkedList<java.nio.file.Path>();
        for (java.nio.file.Path it = member; it != this.getNioPath(); it = it.getParent()) {
            backendResources.addFirst(it);
        }
        for (java.nio.file.Path it : backendResources) {
            if (Files.isDirectory(it, new LinkOption[0])) continue;
            return new EFSNIOFile(this.getRoot(), it);
        }
        return null;
    }

    public IResource findMember(IPath path, boolean includePhantoms) {
        return this.findMember(path);
    }

    public IResource findMember(String path, boolean includePhantoms) {
        return this.findMember(path);
    }

    public IResource findMember(String path) {
        return this.findMember((IPath)new Path(path));
    }

    public String getDefaultCharset() {
        return "UTF-8";
    }

    public String getDefaultCharset(boolean checkImplicit) {
        return this.getDefaultCharset();
    }

    public IFile getFile(IPath path) {
        java.nio.file.Path childBackendFile = this.getNioPath().resolve(path.toString());
        return new EFSNIOFile(this.getRoot(), childBackendFile);
    }

    public IFolder getFolder(IPath path) {
        java.nio.file.Path childBackendFolder = this.getNioPath().resolve(path.toString());
        return new EFSNIOFolder(this.getRoot(), childBackendFolder);
    }

    public IResource[] members() throws CoreException {
        ArrayList members = new ArrayList();
        try (Stream<java.nio.file.Path> files = Files.list(this.getNioPath());){
            files.forEach(member -> {
                if (Files.isDirectory(member, new LinkOption[0])) {
                    members.add(new EFSNIOFolder(this.getRoot(), (java.nio.file.Path)member));
                } else {
                    members.add(new EFSNIOFile(this.getRoot(), (java.nio.file.Path)member));
                }
            });
        }
        catch (Exception e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)e));
        }
        return members.toArray(new IResource[0]);
    }

    public IResource[] members(boolean includePhantoms) throws CoreException {
        return this.members();
    }

    public IResource[] members(int memberFlags) throws CoreException {
        return this.members();
    }

    public IFile[] findDeletedMembersWithHistory(int depth, IProgressMonitor monitor) {
        return new IFile[0];
    }

    @Deprecated
    public void setDefaultCharset(String charset) throws CoreException {
        throw new EFSNIOResource.FeatureNotSupportedException();
    }

    public void setDefaultCharset(String charset, IProgressMonitor monitor) throws CoreException {
        throw new EFSNIOResource.FeatureNotSupportedException();
    }

    public IResourceFilterDescription createFilter(int type, FileInfoMatcherDescription matcherDescription, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new EFSNIOResource.FeatureNotSupportedException();
    }

    public IResourceFilterDescription[] getFilters() {
        return new IResourceFilterDescription[0];
    }

    @Override
    protected boolean visit(IResourceVisitor visitor, int depth) throws CoreException {
        if (!super.visit(visitor, depth)) {
            return false;
        }
        if (depth < 1) {
            return false;
        }
        --depth;
        for (IResource member : this.members()) {
            ((EFSNIOResource)member).visit(visitor, depth);
        }
        return true;
    }
}

