/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandAggregator;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.edit.DBEStructEditor;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class SQLStructEditor<OBJECT_TYPE extends DBSObject, CONTAINER_TYPE extends DBSObject>
extends SQLObjectEditor<OBJECT_TYPE, CONTAINER_TYPE>
implements DBEStructEditor<OBJECT_TYPE> {
    protected abstract void addStructObjectCreateActions(DBRProgressMonitor var1, DBCExecutionContext var2, List<DBEPersistAction> var3, StructCreateCommand var4, Map<String, Object> var5) throws DBException;

    @Override
    public StructCreateCommand makeCreateCommand(OBJECT_TYPE object, Map<String, Object> options) {
        return new StructCreateCommand(this, object, ModelMessages.model_jdbc_create_new_object, options);
    }

    protected Collection<SQLObjectEditor.NestedObjectCommand> getNestedOrderedCommands(StructCreateCommand structCommand) {
        ArrayList<SQLObjectEditor.NestedObjectCommand> nestedCommands = new ArrayList<SQLObjectEditor.NestedObjectCommand>(structCommand.getObjectCommands().values());
        nestedCommands.sort((o1, o2) -> {
            Object object1 = o1.getObject();
            Object object2 = o2.getObject();
            if (object1 == structCommand.getObject()) {
                return 1;
            }
            if (object2 == structCommand.getObject()) {
                return -1;
            }
            int order1 = -1;
            int order2 = 1;
            Class<DBSObject>[] childTypes = this.getChildTypes();
            int childTypesLength = childTypes.length;
            for (int i = 0; i < childTypesLength; ++i) {
                Class<DBSObject> childType = childTypes[i];
                if (childType.isAssignableFrom(object1.getClass())) {
                    order1 = i;
                }
                if (!childType.isAssignableFrom(object2.getClass())) continue;
                order2 = i;
            }
            return order1 - order2;
        });
        return nestedCommands;
    }

    @Override
    protected void createObjectReferences(DBRProgressMonitor monitor, DBECommandContext commandContext, SQLObjectEditor.ObjectCreateCommand createCommand) throws DBException {
        DBSObject object = (DBSObject)createCommand.getObject();
        DBERegistry editorsRegistry = DBWorkbench.getPlatform().getEditorsRegistry();
        for (Class<DBSObject> childType : this.getChildTypes()) {
            SQLObjectEditor<DBSObject, DBSObject> nestedEditor;
            Collection<DBSObject> children = this.getChildObjects(monitor, object, childType);
            if (CommonUtils.isEmpty(children) || (nestedEditor = this.getObjectEditor(editorsRegistry, childType)) == null) continue;
            for (DBSObject child : children) {
                if (!this.isIncludeChildObjectReference(monitor, child)) continue;
                SQLObjectEditor.ObjectCreateCommand childCreateCommand = nestedEditor.makeCreateCommand(child, createCommand.getOptions());
                commandContext.addCommand(childCreateCommand, null, false);
            }
        }
    }

    protected <T extends DBSObject> SQLObjectEditor<T, OBJECT_TYPE> getObjectEditor(DBERegistry editorsRegistry, Class<? extends T> type) {
        Class<? extends T> childType = this.getChildType(type);
        return childType == null ? null : editorsRegistry.getObjectManager(childType, SQLObjectEditor.class);
    }

    protected boolean isIncludeChildObjectReference(DBRProgressMonitor monitor, DBSObject childObject) throws DBException {
        return true;
    }

    protected <T> Class<? extends T> getChildType(Class<T> type) {
        for (Class<DBSObject> childType : this.getChildTypes()) {
            if (!type.isAssignableFrom(childType)) continue;
            return childType;
        }
        return null;
    }

    @Override
    protected final void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand objectChangeCommand, @NotNull Map<String, Object> options) {
        throw new IllegalStateException("addObjectCreateActions should never be called in struct editor");
    }

    @Override
    public Collection<? extends DBSObject> getChildObjects(DBRProgressMonitor monitor, OBJECT_TYPE object, Class<? extends DBSObject> childType) throws DBException {
        return null;
    }

    public static class StructCreateCommand
    extends SQLObjectEditor.ObjectCreateCommand
    implements DBECommandAggregator<OBJECT_TYPE> {
        private final Map<DBPObject, SQLObjectEditor.NestedObjectCommand<?, ?>> objectCommands;
        final /* synthetic */ SQLStructEditor this$0;

        public StructCreateCommand(OBJECT_TYPE object, String table, Map<String, Object> options) {
            this.this$0 = this$0;
            super((SQLObjectEditor)this$0, object, table, options);
            this.objectCommands = new LinkedHashMap();
            this.objectCommands.put((DBPObject)this.getObject(), this);
        }

        public Map<DBPObject, SQLObjectEditor.NestedObjectCommand<?, ?>> getObjectCommands() {
            return this.objectCommands;
        }

        @Override
        public boolean aggregateCommand(DBECommand<?> command) {
            Object object;
            if (command instanceof SQLObjectEditor.NestedObjectCommand && (object = command.getObject()) instanceof DBSObject && DBUtils.isParentOf((DBSObject)object, (DBSObject)this.getObject())) {
                this.objectCommands.put((DBPObject)object, (SQLObjectEditor.NestedObjectCommand)command);
                return true;
            }
            return false;
        }

        @Override
        public void resetAggregatedCommands() {
            this.objectCommands.clear();
            this.objectCommands.put((DBPObject)this.getObject(), this);
        }

        @Override
        @NotNull
        public DBEPersistAction[] getPersistActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull Map<String, Object> options) throws DBException {
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            this.this$0.addStructObjectCreateActions(monitor, executionContext, actions, this, options);
            this.this$0.addObjectExtraActions(monitor, executionContext, actions, this, options);
            return actions.toArray(new DBEPersistAction[0]);
        }
    }
}

