/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model.meta;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(IoTDBMetaModel.class);

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) {
        JDBCResultSet rs;
        JDBCStatement stmt;
        String sql;
        JDBCSession session;
        String device1 = sourceObject.getParentObject().getName();
        String device2 = sourceObject.getName();
        String device = device1 + "." + device2;
        boolean isAligned = false;
        StringBuilder ddl = new StringBuilder(200);
        try {
            session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Execute SQL for IoTDB-tree");
            try {
                sql = String.format("show devices %s", device);
                stmt = session.createStatement();
                try {
                    rs = stmt.executeQuery(sql);
                    try {
                        if (rs != null && rs.next()) {
                            isAligned = "true".equals(rs.getString("IsAligned"));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error executing sql", (Throwable)e);
        }
        try {
            session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Execute SQL for IoTDB-tree");
            try {
                sql = String.format("show timeseries %s.**", device);
                stmt = session.createStatement();
                try {
                    rs = stmt.executeQuery(sql);
                    try {
                        if (rs != null) {
                            while (rs.next()) {
                                ddl.append("delete timeseries ").append(rs.getString("Timeseries")).append(";\n");
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error executing sql", (Throwable)e);
        }
        ddl.append("\n");
        try {
            session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Execute SQL for IoTDB-tree");
            try {
                sql = String.format("show timeseries %s.**", device);
                stmt = session.createStatement();
                try {
                    rs = stmt.executeQuery(sql);
                    try {
                        if (rs != null) {
                            if (isAligned) {
                                String prefix = device + ".";
                                ddl.append("create aligned timeseries ").append(device).append("(");
                                while (rs.next()) {
                                    String timeseries = rs.getString("Timeseries").replaceFirst("^" + prefix, "");
                                    ddl.append(timeseries).append(" ");
                                    ddl.append(rs.getString("DataType")).append(" ");
                                    ddl.append("encoding=").append(rs.getString("Encoding")).append(" ");
                                    ddl.append("compressor=").append(rs.getString("Compression")).append(", ");
                                }
                                ddl.setLength(ddl.length() - 2);
                                ddl.append(");\n");
                            } else {
                                while (rs.next()) {
                                    ddl.append("create timeseries ").append(rs.getString("Timeseries"));
                                    ddl.append(" with datatype=").append(rs.getString("DataType"));
                                    ddl.append(", encoding=").append(rs.getString("Encoding")).append(";\n");
                                }
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error executing sql", (Throwable)e);
        }
        return ddl.toString();
    }

    public boolean isTrimObjectNames() {
        return true;
    }
}

