/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICompositeDialogPageContainer;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class MultiPageWizardDialog
extends TitleAreaDialog
implements IWizardContainer,
IWizardContainer2,
IPageChangeProvider,
IPreferencePageContainer {
    private IWizard wizard;
    private Composite pageArea;
    private Tree pagesTree;
    private IDialogPage prevPage;
    private ProgressMonitorPart monitorPart;
    private SashForm wizardSash;
    private final AtomicInteger runningOperations = new AtomicInteger();
    private String finishButtonLabel = IDialogConstants.OK_LABEL;
    private final String closeButtonLabel = IDialogConstants.CLOSE_LABEL;
    private final ListenerList<IPageChangedListener> pageChangedListeners = new ListenerList();
    private Composite leftBottomPanel;
    private final Set<IWizardPage> resizedPages = new HashSet<IWizardPage>();

    public MultiPageWizardDialog(IWorkbenchWindow window, IWizard wizard) {
        this(window, wizard, null);
    }

    public MultiPageWizardDialog(IWorkbenchWindow window, IWizard wizard, IStructuredSelection selection) {
        super(window.getShell());
        this.wizard = wizard;
        this.wizard.setContainer((IWizardContainer)this);
        if (wizard instanceof IWorkbenchWizard) {
            if (selection == null && window.getSelectionService().getSelection() instanceof IStructuredSelection) {
                selection = (IStructuredSelection)window.getSelectionService().getSelection();
            }
            ((IWorkbenchWizard)wizard).init(window.getWorkbench(), selection);
        }
    }

    protected Point getInitialSize() {
        Point minSize = new Point(700, 500);
        Point suggestedSize = super.getInitialSize();
        return new Point(Math.max(minSize.x, suggestedSize.x), Math.max(minSize.y, suggestedSize.y));
    }

    public IWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(IWizard newWizard) {
        this.wizard = newWizard;
        this.wizard.setContainer((IWizardContainer)this);
        UIUtils.disposeChildControls(this.leftBottomPanel);
        this.createBottomLeftArea(this.leftBottomPanel);
        this.leftBottomPanel.getParent().layout(true, true);
        this.updateNavigationTree();
        this.updateButtons();
    }

    @NotNull
    protected Set<PageCompletionMark> getShownCompletionMarks() {
        return EnumSet.of(PageCompletionMark.ERROR);
    }

    protected Tree getPagesTree() {
        return this.pagesTree;
    }

    protected boolean isResizable() {
        return true;
    }

    public int getShellStyle() {
        if (this.isModalWizard() || UIUtils.isInDialog()) {
            return 66608;
        }
        return 0xC70 | MultiPageWizardDialog.getDefaultOrientation();
    }

    protected boolean isModalWizard() {
        return true;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        MultiPageWizardDialog.applyDialogFont((Control)contents);
        this.showPage((IWizardPage)this.pagesTree.getItem(0).getData());
        IWizardPage firstPage = this.getStartingPage();
        this.setTitle(firstPage.getTitle());
        this.setTitleImage(firstPage.getImage());
        this.setMessage(firstPage.getDescription());
        this.showPage(firstPage);
        this.updateButtons();
        this.updateWindowTitle();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)new GridData(1808));
        mainComposite.setFont(parent.getFont());
        UIUtils.createLabelSeparator(mainComposite, 256);
        this.wizard.addPages();
        this.wizardSash = new SashForm(mainComposite, 256);
        this.wizardSash.setLayoutData((Object)new GridData(1808));
        Composite leftPane = UIUtils.createPlaceholder((Composite)this.wizardSash, 1);
        this.pagesTree = new Tree(leftPane, 65540);
        this.pagesTree.setLayoutData((Object)new GridData(1808));
        this.leftBottomPanel = UIUtils.createComposite(leftPane, 1);
        this.createBottomLeftArea(this.leftBottomPanel);
        this.pageArea = UIUtils.createPlaceholder((Composite)this.wizardSash, 1);
        GridData gd = new GridData(1808);
        this.pageArea.setLayoutData((Object)gd);
        this.pageArea.setLayout((Layout)new GridLayout(1, true));
        this.wizardSash.setWeights(new int[]{220, 780});
        this.updateNavigationTree();
        this.pagesTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selection = MultiPageWizardDialog.this.pagesTree.getSelection();
                if (selection.length > 0) {
                    Object newPage = selection[0].getData();
                    if (MultiPageWizardDialog.this.runningOperations.get() > 0 || newPage instanceof IWizardPageNavigable && !((IWizardPageNavigable)newPage).isPageNavigable()) {
                        TreeItem prevItem;
                        if (MultiPageWizardDialog.this.prevPage != null && (prevItem = UIUtils.getTreeItem(MultiPageWizardDialog.this.pagesTree, (Object)MultiPageWizardDialog.this.prevPage)) != null) {
                            MultiPageWizardDialog.this.pagesTree.select(prevItem);
                        }
                        return;
                    }
                }
                MultiPageWizardDialog.this.changePage();
            }
        });
        UIUtils.createLabelSeparator(mainComposite, 256);
        this.monitorPart = new ProgressMonitorPart(mainComposite, null, true){

            public void setCanceled(boolean b) {
                super.setCanceled(b);
                if (b) {
                    MultiPageWizardDialog.this.cancelCurrentOperation();
                }
            }
        };
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        gd.verticalIndent = 0;
        this.monitorPart.setLayoutData((Object)gd);
        this.monitorPart.setVisible(false);
        return mainComposite;
    }

    protected void createBottomLeftArea(Composite pane) {
    }

    protected void cancelCurrentOperation() {
    }

    protected boolean isShowTreeIcons() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePage() {
        TreeItem[] selection = this.pagesTree.getSelection();
        if (selection.length != 1) {
            return;
        }
        TreeItem newItem = selection[0];
        if (this.prevPage == newItem.getData()) {
            return;
        }
        this.pageArea.setRedraw(false);
        try {
            IDialogPage page;
            Control pageControl;
            GridData gd;
            if (this.prevPage != null && this.prevPage.getControl() != null) {
                gd = (GridData)this.prevPage.getControl().getLayoutData();
                gd.exclude = true;
                this.prevPage.setVisible(false);
                IDialogPage iDialogPage = this.prevPage;
                if (iDialogPage instanceof ActiveWizardPage) {
                    ActiveWizardPage awp = (ActiveWizardPage)iDialogPage;
                    awp.deactivatePage();
                }
            }
            if ((pageControl = (page = (IDialogPage)newItem.getData()).getControl()) == null) {
                page.createControl(this.pageArea);
                pageControl = page.getControl();
                MultiPageWizardDialog.applyDialogFont((Control)pageControl);
                if (pageControl != null) {
                    gd = (GridData)pageControl.getLayoutData();
                    if (gd == null) {
                        gd = new GridData(1808);
                        pageControl.setLayoutData((Object)gd);
                    }
                    gd.exclude = false;
                }
            }
            if (pageControl != null) {
                gd = (GridData)pageControl.getLayoutData();
                gd.exclude = false;
                page.setVisible(true);
            }
            this.setTitle(page.getTitle());
            this.setMessage(page.getDescription());
            this.prevPage = page;
            this.pageArea.layout();
            if (this.prevPage.getControl() != null) {
                // empty if block
            }
            if (page instanceof ActiveWizardPage) {
                ActiveWizardPage awp = (ActiveWizardPage)page;
                awp.updatePageCompletion();
            }
        }
        catch (Throwable e) {
            DBWorkbench.getPlatformUI().showError("Page switch", "Error switching active page", e);
        }
        finally {
            this.pageArea.setRedraw(true);
        }
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.getCurrentPage()));
        this.updatePageCompleteMark(null);
    }

    protected boolean isAutoLayoutAvailable() {
        return true;
    }

    public void disableButtonsOnProgress() {
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
    }

    public void enableButtonsAfterProgress() {
        this.getButton(0).setEnabled(true);
        this.getButton(1).setEnabled(true);
    }

    public void setCompleteMarkAfterProgress() {
        if (!this.isShowTreeIcons()) {
            return;
        }
        TreeItem[] selection = this.pagesTree.getSelection();
        if (selection.length != 1) {
            return;
        }
        TreeItem selectedItem = selection[0];
        selectedItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.OK_MARK));
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.getWizard().performCancel();
        } else if (buttonId == 0) {
            if (!this.getWizard().performFinish()) {
                return;
            }
        } else if (buttonId == 16) {
            this.finishPressed();
        } else if (buttonId == 15) {
            this.nextPressed();
        } else if (buttonId == 14) {
            this.backPressed();
        }
        super.buttonPressed(buttonId);
    }

    public IWizardPage getCurrentPage() {
        Object[] selection = this.pagesTree.getSelection();
        if (ArrayUtils.isEmpty((Object[])selection)) {
            return null;
        }
        IDialogPage page = (IDialogPage)selection[0].getData();
        return page instanceof IWizardPage ? (IWizardPage)page : null;
    }

    public void showPage(IWizardPage page) {
        for (TreeItem item : this.pagesTree.getItems()) {
            if (item.getData() == page) {
                this.pagesTree.setSelection(item);
                this.changePage();
                return;
            }
            for (TreeItem child : item.getItems()) {
                if (child.getData() != page) continue;
                this.pagesTree.setSelection(child);
                this.changePage();
                return;
            }
        }
        for (TreeItem item : this.pagesTree.getItems()) {
            Object[] subPages;
            if (!(item.getData() instanceof ICompositeDialogPageContainer) || ArrayUtils.isEmpty((Object[])(subPages = ((ICompositeDialogPageContainer)item.getData()).getDialogPages(false, false)))) continue;
            for (Object subPage : subPages) {
                if (subPage != page) continue;
                this.pagesTree.setSelection(item);
                this.changePage();
                ((ICompositeDialogPageContainer)item.getData()).showSubPage((IDialogPage)page);
                return;
            }
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNavigationTree() {
        this.pagesTree.setRedraw(false);
        try {
            IWizardPage[] pages;
            Object selectedPage = this.getSelectedPage();
            this.pagesTree.removeAll();
            for (IWizardPage iWizardPage : pages = this.wizard.getPages()) {
                this.addNavigationItem(null, (IDialogPage)iWizardPage);
            }
            for (IWizardPage iWizardPage : this.pagesTree.getItems()) {
                if (iWizardPage.getData() != selectedPage) continue;
                this.pagesTree.select((TreeItem)iWizardPage);
                break;
            }
            this.updatePageCompleteMark(null);
        }
        finally {
            this.pagesTree.setRedraw(true);
        }
    }

    protected boolean isFullscreenPage(@NotNull IDialogPage page) {
        return page.getControl() instanceof CTabFolder;
    }

    private void updatePageCompleteMark(TreeItem parent) {
        Set<PageCompletionMark> shownCompletionMarks = this.getShownCompletionMarks();
        IWizardPage currentPage = this.getCurrentPage();
        for (TreeItem item : parent == null ? this.pagesTree.getItems() : parent.getItems()) {
            Object object = item.getData();
            if (!(object instanceof IDialogPage)) continue;
            IDialogPage page = (IDialogPage)object;
            if (this.isShowTreeIcons()) {
                DBPImage itemImage = MultiPageWizardDialog.computePageIcon(page, currentPage, shownCompletionMarks::contains);
                item.setImage(itemImage == null ? null : DBeaverIcons.getImage(itemImage));
            }
            item.setForeground(this.computePageColor(page));
            this.updatePageCompleteMark(item);
        }
    }

    private TreeItem addNavigationItem(TreeItem parentItem, IDialogPage page) {
        Object[] subPages;
        if (page instanceof IWizardPageNavigable && !((IWizardPageNavigable)page).isPageApplicable()) {
            return null;
        }
        TreeItem item = parentItem == null ? new TreeItem(this.pagesTree, 0) : new TreeItem(parentItem, 0);
        item.setText(CommonUtils.toString((Object)page.getTitle(), (String)page.getClass().getSimpleName()));
        item.setForeground(this.computePageColor(page));
        item.setData((Object)page);
        if (page instanceof IDialogPageProvider && !ArrayUtils.isEmpty((Object[])(subPages = ((IDialogPageProvider)page).getDialogPages(true, this.resizeHasOccurred)))) {
            for (Object subPage : subPages) {
                this.addNavigationItem(item, (IDialogPage)subPage);
            }
        }
        return item;
    }

    @Nullable
    private static DBPImage computePageIcon(@NotNull IDialogPage page, @NotNull IWizardPage currentPage, @NotNull Predicate<PageCompletionMark> canShowMark) {
        if (page == currentPage) {
            return canShowMark.test(PageCompletionMark.COMPLETE) ? UIIcon.RS_FORWARD : null;
        }
        if (page.getControl() == null) {
            return canShowMark.test(PageCompletionMark.COMPLETE) ? UIIcon.DOTS_BUTTON : null;
        }
        if (page instanceof IWizardPage) {
            IWizardPage wizardPage = (IWizardPage)page;
            if (wizardPage.isPageComplete()) {
                return canShowMark.test(PageCompletionMark.COMPLETE) ? UIIcon.OK_MARK : null;
            }
            return canShowMark.test(PageCompletionMark.ERROR) ? DBIcon.SMALL_ERROR : null;
        }
        return null;
    }

    @Nullable
    private Color computePageColor(@NotNull IDialogPage page) {
        IWizardPageNavigable pageNavigable;
        if (page instanceof IWizardPageNavigable && !(pageNavigable = (IWizardPageNavigable)page).isPageNavigable()) {
            Display display = this.getShell().getDisplay();
            return display.getSystemColor(UIStyles.isDarkTheme() ? 18 : 17);
        }
        return null;
    }

    protected void updatePageCompletion() {
        IWizardPage page = this.getCurrentPage();
        if (page instanceof ActiveWizardPage) {
            ActiveWizardPage awp = (ActiveWizardPage)page;
            awp.updatePageCompletion();
        }
    }

    public void updateButtons() {
        IWizardPage currentPage;
        Button finishButton = this.getButton(0);
        if (finishButton != null && !finishButton.isDisposed()) {
            finishButton.setEnabled(this.wizard.canFinish());
        }
        if ((currentPage = this.getCurrentPage()) != null) {
            Button prevButton;
            Button nextButton = this.getButton(15);
            if (nextButton != null) {
                nextButton.setEnabled(this.getCurrentPage().isPageComplete() && this.wizard.getNextPage(currentPage) != null);
            }
            if ((prevButton = this.getButton(14)) != null) {
                prevButton.setEnabled(this.wizard.getPreviousPage(currentPage) != null);
            }
        }
        this.updatePageCompleteMark(null);
    }

    public void updateMessage() {
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage == null) {
            return;
        }
        String message = currentPage.getMessage();
        if (message == null) {
            this.setMessage(currentPage.getDescription());
        } else if (currentPage instanceof IMessageProvider) {
            IMessageProvider provider = (IMessageProvider)currentPage;
            this.setMessage(message, provider.getMessageType());
        } else {
            this.setMessage(message);
        }
        this.setErrorMessage(currentPage.getErrorMessage());
    }

    public void updateTitle() {
        this.updateWindowTitle();
    }

    public void updateTitleBar() {
    }

    public void updateWindowTitle() {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setText(this.getWizard().getWindowTitle());
            this.updateMessage();
        }
    }

    public boolean close() {
        if (this.runningOperations.get() > 0) {
            return false;
        }
        if (this.wizard != null) {
            this.wizard.dispose();
        }
        return super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean isDisableControlsOnRun;
        if (this.monitorPart != null) {
            this.monitorPart.setVisible(true);
            this.monitorPart.attachToCancelComponent(null);
        }
        ControlEnableState pageEnableState = (isDisableControlsOnRun = this.isDisableControlsOnRun()) ? ControlEnableState.disable((Control)this.wizardSash) : null;
        ControlEnableState buttonsEnableState = isDisableControlsOnRun ? ControlEnableState.disable((Control)this.getButtonBar()) : null;
        try {
            this.runningOperations.incrementAndGet();
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)this.monitorPart, (Display)this.getShell().getDisplay());
        }
        finally {
            this.runningOperations.decrementAndGet();
            if (buttonsEnableState != null) {
                buttonsEnableState.restore();
            }
            if (pageEnableState != null) {
                pageEnableState.restore();
            }
            if (this.monitorPart != null && !this.monitorPart.isDisposed()) {
                this.monitorPart.done();
                this.monitorPart.setVisible(false);
            }
        }
    }

    protected boolean isDisableControlsOnRun() {
        return false;
    }

    protected void showPage(String pageName) {
        for (IWizardPage page : this.getWizard().getPages()) {
            if (!pageName.equals(page.getName())) continue;
            this.showPage(page);
            break;
        }
    }

    @NotNull
    protected Control createButtonBar(@NotNull Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setFont(parent.getFont());
        Composite leftButtonsComposite = this.createButtonBarComposite(composite, 16384);
        Composite rightButtonsComposite = this.createButtonBarComposite(composite, 131072);
        this.createButtonsForLeftButtonBar(leftButtonsComposite);
        this.createButtonsForButtonBar(rightButtonsComposite);
        if (leftButtonsComposite.getChildren().length == 0) {
            --((GridLayout)composite.getLayout()).numColumns;
            leftButtonsComposite.dispose();
        }
        if (rightButtonsComposite.getChildren().length == 0) {
            --((GridLayout)composite.getLayout()).numColumns;
            rightButtonsComposite.dispose();
        }
        return composite;
    }

    @NotNull
    protected Composite createButtonBarComposite(@NotNull Composite parent, int alignment) {
        GridLayout layout = new GridLayout(0, true);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        GridData data = new GridData(alignment, 0x1000000, true, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        return composite;
    }

    protected void createButtonsForLeftButtonBar(@NotNull Composite parent) {
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 0, this.finishButtonLabel, this.getShell().getDefaultButton() == null);
        this.createButton(parent, 1, this.closeButtonLabel, false);
    }

    protected void setFinishButtonLabel(String finishButtonLabel) {
        this.finishButtonLabel = finishButtonLabel;
    }

    public Object getSelectedPage() {
        return this.getCurrentPage();
    }

    @NotNull
    protected IWizardPage getStartingPage() {
        return (IWizardPage)this.pagesTree.getItem(0).getData();
    }

    protected void finishPressed() {
    }

    public void nextPressed() {
        IWizard wizard = this.getWizard();
        IWizardPage currentPage = this.getCurrentPage();
        if (!currentPage.isPageComplete()) {
            return;
        }
        IWizardPage nextPage = wizard.getNextPage(currentPage);
        if (nextPage != null) {
            this.showPage(nextPage);
        }
    }

    public void backPressed() {
        IWizardPage currentPage;
        IWizard wizard = this.getWizard();
        IWizardPage prevPage = wizard.getPreviousPage(currentPage = this.getCurrentPage());
        if (prevPage != null) {
            this.showPage(prevPage);
        }
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.remove((Object)listener);
    }

    private void firePageChanged(final PageChangedEvent event) {
        for (final IPageChangedListener l : this.pageChangedListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(this){

                public void run() {
                    l.pageChanged(event);
                }
            });
        }
        this.updateSize();
    }

    public void updateSize() {
        this.updateSize(this.getCurrentPage());
    }

    private void updateSize(IWizardPage page) {
        if (page == null || page.getControl() == null || this.resizedPages.contains(page)) {
            return;
        }
        this.updateSizeForPage(page);
        this.pageArea.layout();
        this.resizedPages.add(page);
    }

    private void updateSizeForPage(IWizardPage page) {
        ActiveWizardPage awp;
        if (this.isAutoLayoutAvailable() && (!(page instanceof ActiveWizardPage) || (awp = (ActiveWizardPage)page).isAutoResizeEnabled())) {
            UIUtils.asyncExec(() -> {
                Point pageCompSize = page.getControl().computeSize(-1, -1);
                for (Composite parent = page.getControl().getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof SashForm)) continue;
                    pageCompSize = parent.computeSize(-1, -1);
                    break;
                }
                Point shellCompSize = this.getShell().computeSize(-1, -1);
                if (shellCompSize.y > pageCompSize.y) {
                    pageCompSize.y = shellCompSize.y;
                }
                UIUtils.resizeShell(this.getShell(), pageCompSize);
            });
        }
    }

    private void updateSizeForWizard(IWizard sizingWizard) {
        IWizardPage[] pages;
        Point delta = new Point(0, 0);
        for (IWizardPage page : pages = sizingWizard.getPages()) {
            Point pageDelta = this.calculatePageSizeDelta(page);
            delta.x = Math.max(delta.x, pageDelta.x);
            delta.y = Math.max(delta.y, pageDelta.y);
        }
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
        }
    }

    private Point calculatePageSizeDelta(IWizardPage page) {
        Control pageControl = page.getControl();
        if (pageControl == null) {
            return new Point(0, 0);
        }
        Point contentSize = pageControl.computeSize(-1, -1, true);
        Rectangle rect = this.pageArea.getClientArea();
        Point containerSize = new Point(rect.width, rect.height);
        return new Point(Math.max(0, contentSize.x - containerSize.x), Math.max(0, contentSize.y - containerSize.y));
    }

    private void setShellSize(int width, int height) {
        Rectangle size = this.getShell().getBounds();
        size.height = height;
        size.width = width;
        this.getShell().setBounds(this.getConstrainedShellBounds(size));
    }

    protected static enum PageCompletionMark {
        COMPLETE,
        ERROR;

    }
}

