/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.file.FileOpenHandler;
import org.jkiss.dbeaver.model.file.FileTypeAction;
import org.jkiss.dbeaver.model.file.FileTypeHandlerDescriptor;
import org.jkiss.dbeaver.model.file.FileTypeHandlerRegistry;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.LocalFileStorage;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.IDataSourceContainerUpdate;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.IInMemoryEditorInput;
import org.jkiss.dbeaver.ui.editors.ILazyEditorInput;
import org.jkiss.dbeaver.ui.editors.IRevertableEditor;
import org.jkiss.dbeaver.ui.editors.IncludedScriptFileEditorInput;
import org.jkiss.dbeaver.ui.editors.file.FileActionSelectorDialog;
import org.jkiss.dbeaver.ui.editors.internal.EditorsMessages;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class EditorUtils {
    public static final String PROP_SQL_DATA_SOURCE_ID = "sql-editor-data-source-id";
    public static final String PROP_SQL_PROJECT_ID = "sql-editor-project-id";
    public static final String PROP_CONTEXT_DEFAULT_CATALOG = "default-catalog";
    private static final String PROP_CONTEXT_DEFAULT_SCHEMA = "default-schema";
    private static final String PROP_SQL_DATA_SOURCE_CONTAINER = "sql-editor-data-source-container";
    private static final String PROP_EDITOR_CONTEXT = "database-editor-context";
    private static final String PROP_EXECUTION_CONTEXT = "sql-editor-execution-context";
    private static final String PROP_INPUT_FILE = "sql-editor-input-file";
    public static final String COLORS_AND_FONTS_PAGE_ID = "org.eclipse.ui.preferencePages.ColorsAndFonts";
    private static final String ZWNBSP = "\ufeff";
    private static final Log log = Log.getLog(EditorUtils.class);

    @Nullable
    public static DBPProject getFileProject(@Nullable IEditorInput editorInput) {
        if (editorInput != null) {
            DBPDataSource dataSource;
            IDatabaseEditorInput dei;
            DBSObject dbo;
            if (editorInput instanceof ILazyEditorInput) {
                ILazyEditorInput lei = (ILazyEditorInput)editorInput;
                return lei.getProject();
            }
            if (editorInput instanceof IDatabaseEditorInput && (dbo = (dei = (IDatabaseEditorInput)editorInput).getDatabaseObject()) != null && (dataSource = dbo.getDataSource()) != null) {
                return dataSource.getContainer().getProject();
            }
            IFile curFile = EditorUtils.getFileFromInput(editorInput);
            if (curFile != null) {
                return DBPPlatformDesktop.getInstance().getWorkspace().getProject(curFile.getProject());
            }
        }
        return null;
    }

    @Nullable
    public static IFile getFileFromInput(IEditorInput editorInput) {
        IPathEditorInput pathInput;
        if (editorInput == null) {
            return null;
        }
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fei = (IFileEditorInput)editorInput;
            return fei.getFile();
        }
        if (editorInput instanceof IPathEditorInput) {
            IPathEditorInput pei = (IPathEditorInput)editorInput;
            IPath path = pei.getPath();
            return path == null ? null : ResourceUtils.convertPathToWorkspaceFile((IPath)path);
        }
        if (editorInput instanceof IInMemoryEditorInput) {
            IInMemoryEditorInput mei = (IInMemoryEditorInput)editorInput;
            IFile file = (IFile)mei.getProperty(PROP_INPUT_FILE);
            if (file != null) {
                return file;
            }
        } else if (editorInput instanceof IURIEditorInput) {
            return null;
        }
        if ((pathInput = (IPathEditorInput)editorInput.getAdapter(IPathEditorInput.class)) != null) {
            IPath path = pathInput.getPath();
            return path == null ? null : ResourceUtils.convertPathToWorkspaceFile((IPath)path);
        }
        try {
            Method getFileMethod = editorInput.getClass().getMethod("getFile", new Class[0]);
            if (IFile.class.isAssignableFrom(getFileMethod.getReturnType())) {
                return (IFile)getFileMethod.invoke((Object)editorInput, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static IStorage getStorageFromInput(Object element) {
        IAdaptable adaptable;
        IStorage storage;
        if (element instanceof IStorageEditorInput) {
            IStorageEditorInput sei = (IStorageEditorInput)element;
            try {
                return sei.getStorage();
            }
            catch (CoreException e) {
                log.error((Object)e);
            }
        }
        if (element instanceof IAdaptable && (storage = (IStorage)(adaptable = (IAdaptable)element).getAdapter(IStorage.class)) != null) {
            return storage;
        }
        if (element instanceof IEditorInput) {
            IURIEditorInput uriei;
            URI uri;
            File localFile;
            IEditorInput ei = (IEditorInput)element;
            IFile file = EditorUtils.getFileFromInput(ei);
            if (file != null) {
                return file;
            }
            if (element instanceof IURIEditorInput && (localFile = new File(uri = (uriei = (IURIEditorInput)element).getURI())).exists()) {
                return new LocalFileStorage(localFile, StandardCharsets.UTF_8.name());
            }
        }
        return null;
    }

    public static File getLocalFileFromInput(Object element) {
        if (element instanceof IEditorInput) {
            IEditorInput ei = (IEditorInput)element;
            IFile file = EditorUtils.getFileFromInput(ei);
            if (file != null) {
                IPath location = file.getLocation();
                return location == null ? null : location.toFile();
            }
            if (element instanceof IURIEditorInput) {
                IURIEditorInput uriei = (IURIEditorInput)element;
                try {
                    File localFile = new File(uriei.getURI());
                    if (localFile.exists()) {
                        return localFile;
                    }
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static Path getPathFromInput(Object element) {
        IEditorInput ei;
        IFile file;
        if (element instanceof IEditorInput && (file = EditorUtils.getFileFromInput(ei = (IEditorInput)element)) != null) {
            IPath location = file.getLocation();
            return location == null ? null : location.toPath();
        }
        File localFile = EditorUtils.getLocalFileFromInput(element);
        return localFile == null ? null : localFile.toPath();
    }

    @Nullable
    public static Object getResourceProperty(@NotNull RCPProject project, @NotNull IResource resource, @NotNull String propName) {
        return project.getResourceProperty(project.getResourcePath(resource), propName);
    }

    public static void setResourceProperty(@NotNull RCPProject project, @NotNull IResource resource, @NotNull String propName, @Nullable Object value) {
        project.setResourceProperty(project.getResourcePath(resource), propName, value);
    }

    public static DatabaseEditorContext getEditorContext(IEditorInput editorInput) {
        if (editorInput instanceof IInMemoryEditorInput) {
            return (DatabaseEditorContext)((IInMemoryEditorInput)editorInput).getProperty(PROP_EDITOR_CONTEXT);
        }
        if (editorInput instanceof IncludedScriptFileEditorInput) {
            IncludedScriptFileEditorInput input = (IncludedScriptFileEditorInput)editorInput;
            return input.getDatabaseEditorContext();
        }
        return null;
    }

    public static DBCExecutionContext getInputExecutionContext(IEditorInput editorInput) {
        if (editorInput instanceof IInMemoryEditorInput) {
            return (DBCExecutionContext)((IInMemoryEditorInput)editorInput).getProperty(PROP_EXECUTION_CONTEXT);
        }
        return null;
    }

    public static DBPDataSourceContainer getInputDataSource(IEditorInput editorInput) {
        return EditorUtils.getInputDataSource(editorInput, true);
    }

    public static DBPDataSourceContainer getInputDataSource(IEditorInput editorInput, boolean forceRegistryLoad) {
        if (editorInput instanceof IDatabaseEditorInput) {
            IDatabaseEditorInput dei = (IDatabaseEditorInput)editorInput;
            DBSObject object = dei.getDatabaseObject();
            if (object != null && object.getDataSource() != null) {
                return object.getDataSource().getContainer();
            }
            if (editorInput instanceof DBPDataSourceContainerProvider) {
                DBPDataSourceContainerProvider containerProvider = (DBPDataSourceContainerProvider)editorInput;
                return containerProvider.getDataSourceContainer();
            }
            return null;
        }
        if (editorInput instanceof IInMemoryEditorInput) {
            IInMemoryEditorInput mei = (IInMemoryEditorInput)editorInput;
            return (DBPDataSourceContainer)mei.getProperty(PROP_SQL_DATA_SOURCE_CONTAINER);
        }
        IFile file = EditorUtils.getFileFromInput(editorInput);
        if (file != null) {
            return EditorUtils.getFileDataSource(file, forceRegistryLoad);
        }
        File localFile = EditorUtils.getLocalFileFromInput(editorInput);
        if (localFile != null) {
            DBPExternalFileManager efManager = DBPPlatformDesktop.getInstance().getExternalFileManager();
            String dataSourceId = (String)efManager.getFileProperty(localFile, PROP_SQL_DATA_SOURCE_ID);
            String projectName = (String)efManager.getFileProperty(localFile, PROP_SQL_PROJECT_ID);
            if (CommonUtils.isEmpty((String)dataSourceId) || CommonUtils.isEmpty((String)projectName)) {
                return null;
            }
            IProject project = DBPPlatformDesktop.getInstance().getWorkspace().getEclipseWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists()) {
                log.error((Object)("Can't locate project '" + projectName + "' in workspace"));
                return null;
            }
            DBPProject projectMeta = DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
            return projectMeta == null || !forceRegistryLoad && !projectMeta.isRegistryLoaded() ? null : projectMeta.getDataSourceRegistry().getDataSource(dataSourceId);
        }
        return null;
    }

    public static String[] getInputContextDefaults(DBPDataSourceContainer dataSource, IEditorInput editorInput) {
        String defaultDatasource = null;
        String defaultCatalogName = null;
        String defaultSchema = null;
        if (editorInput instanceof IInMemoryEditorInput) {
            IInMemoryEditorInput mei = (IInMemoryEditorInput)editorInput;
            defaultDatasource = (String)mei.getProperty("default-datasource");
            defaultCatalogName = (String)mei.getProperty(PROP_CONTEXT_DEFAULT_CATALOG);
            defaultSchema = (String)mei.getProperty(PROP_CONTEXT_DEFAULT_SCHEMA);
        } else {
            IFile file = EditorUtils.getFileFromInput(editorInput);
            if (file != null) {
                RCPProject projectMeta = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
                if (projectMeta != null) {
                    defaultDatasource = (String)EditorUtils.getResourceProperty(projectMeta, (IResource)file, "default-datasource");
                    defaultCatalogName = (String)EditorUtils.getResourceProperty(projectMeta, (IResource)file, PROP_CONTEXT_DEFAULT_CATALOG);
                    defaultSchema = (String)EditorUtils.getResourceProperty(projectMeta, (IResource)file, PROP_CONTEXT_DEFAULT_SCHEMA);
                }
            } else {
                File localFile = EditorUtils.getLocalFileFromInput(editorInput);
                if (localFile != null) {
                    DBPExternalFileManager efManager = DBPPlatformDesktop.getInstance().getExternalFileManager();
                    defaultDatasource = (String)efManager.getFileProperty(localFile, "default-datasource");
                    defaultCatalogName = (String)efManager.getFileProperty(localFile, PROP_CONTEXT_DEFAULT_CATALOG);
                    defaultSchema = (String)efManager.getFileProperty(localFile, PROP_CONTEXT_DEFAULT_SCHEMA);
                }
            }
        }
        if (!CommonUtils.isEmpty((String)defaultDatasource) && !defaultDatasource.equals(dataSource.getId())) {
            return new String[]{null, null};
        }
        return new String[]{defaultCatalogName, defaultSchema};
    }

    @Nullable
    public static DBPDataSourceContainer getFileDataSource(IFile file) {
        return EditorUtils.getFileDataSource(file, true);
    }

    @Nullable
    public static DBPDataSourceContainer getFileDataSource(IFile file, boolean forceRegistryLoad) {
        if (!file.exists()) {
            return null;
        }
        RCPProject projectMeta = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
        if (projectMeta != null) {
            Object dataSourceId = EditorUtils.getResourceProperty(projectMeta, (IResource)file, "default-datasource");
            if (dataSourceId != null && (forceRegistryLoad || projectMeta.isRegistryLoaded())) {
                DBPDataSourceContainer dataSource = projectMeta.getDataSourceRegistry().getDataSource(dataSourceId.toString());
                if (dataSource == null) {
                    log.debug((Object)("Datasource " + String.valueOf(dataSourceId) + " not found in project " + projectMeta.getName() + " (" + file.getFullPath().toString() + ")"));
                }
                return dataSource;
            }
            return null;
        }
        return null;
    }

    public static void setInputDataSource(@NotNull IEditorInput editorInput, @NotNull DatabaseEditorContext context) {
        IFile file;
        if (editorInput instanceof IInMemoryEditorInput) {
            DBPDataSourceContainer dataSourceContainer;
            IInMemoryEditorInput inMemoryEditorInput = (IInMemoryEditorInput)editorInput;
            inMemoryEditorInput.setProperty(PROP_EDITOR_CONTEXT, context);
            DBCExecutionContext executionContext = context.getExecutionContext();
            if (executionContext != null) {
                inMemoryEditorInput.setProperty(PROP_EXECUTION_CONTEXT, executionContext);
            }
            if ((dataSourceContainer = context.getDataSourceContainer()) != null) {
                inMemoryEditorInput.setProperty(PROP_SQL_DATA_SOURCE_CONTAINER, dataSourceContainer);
            }
            if (!EditorUtils.isDefaultContextSettings(context)) {
                String schemaName;
                String catalogName;
                if (dataSourceContainer != null) {
                    inMemoryEditorInput.setProperty("default-datasource", dataSourceContainer.getId());
                }
                if ((catalogName = EditorUtils.getDefaultCatalogName(context)) != null) {
                    inMemoryEditorInput.setProperty(PROP_CONTEXT_DEFAULT_CATALOG, EditorUtils.getDefaultCatalogName(context));
                }
                if ((schemaName = EditorUtils.getDefaultSchemaName(context)) != null) {
                    inMemoryEditorInput.setProperty(PROP_CONTEXT_DEFAULT_SCHEMA, schemaName);
                }
            }
            return;
        }
        if (editorInput instanceof IncludedScriptFileEditorInput) {
            IncludedScriptFileEditorInput input = (IncludedScriptFileEditorInput)editorInput;
            input.setDatabaseEditorContext(context);
        }
        if ((file = EditorUtils.getFileFromInput(editorInput)) != null) {
            EditorUtils.setFileDataSource(file, context);
        } else {
            File localFile = EditorUtils.getLocalFileFromInput(editorInput);
            if (localFile != null) {
                EditorUtils.setFileDataSource(localFile, context);
            } else {
                log.error((Object)("Can't set datasource for input " + String.valueOf(editorInput)));
            }
        }
    }

    public static void setInputInputFile(@NotNull IEditorInput editorInput, @NotNull IFile file) {
        if (editorInput instanceof IInMemoryEditorInput) {
            ((IInMemoryEditorInput)editorInput).setProperty(PROP_INPUT_FILE, file);
        }
    }

    public static void setFileDataSource(@NotNull File localFile, @NotNull DatabaseEditorContext context) {
        DBPExternalFileManager efManager = DBPPlatformDesktop.getInstance().getExternalFileManager();
        DBPDataSourceContainer dataSourceContainer = context.getDataSourceContainer();
        efManager.setFileProperty(localFile, PROP_SQL_PROJECT_ID, dataSourceContainer == null ? null : dataSourceContainer.getRegistry().getProject().getName());
        String dataSourceId = dataSourceContainer == null ? null : dataSourceContainer.getId();
        efManager.setFileProperty(localFile, PROP_SQL_DATA_SOURCE_ID, (Object)dataSourceId);
        if (!EditorUtils.isDefaultContextSettings(context)) {
            efManager.setFileProperty(localFile, "default-datasource", (Object)dataSourceId);
            String catalogName = EditorUtils.getDefaultCatalogName(context);
            if (catalogName != null) {
                efManager.setFileProperty(localFile, PROP_CONTEXT_DEFAULT_CATALOG, (Object)EditorUtils.getDefaultCatalogName(context));
            }
            String schemaName = EditorUtils.getDefaultSchemaName(context);
            if (catalogName != null || schemaName != null) {
                efManager.setFileProperty(localFile, PROP_CONTEXT_DEFAULT_SCHEMA, (Object)EditorUtils.getDefaultCatalogName(context));
            }
        }
    }

    public static void setFileDataSource(@NotNull IFile file, @NotNull DatabaseEditorContext context) {
        RCPProject projectMeta = (RCPProject)DBPPlatformDesktop.getInstance().getWorkspace().getProject(file.getProject());
        if (projectMeta == null) {
            return;
        }
        DBPDataSourceContainer dataSourceContainer = context.getDataSourceContainer();
        String dataSourceId = dataSourceContainer == null ? null : dataSourceContainer.getId();
        String resourcePath = projectMeta.getResourcePath((IResource)file);
        projectMeta.setResourceProperty(resourcePath, "default-datasource", (Object)dataSourceId);
        if (!EditorUtils.isDefaultContextSettings(context)) {
            String defaultSchemaName;
            String defaultCatalogName = EditorUtils.getDefaultCatalogName(context);
            if (!CommonUtils.isEmpty((String)defaultCatalogName)) {
                projectMeta.setResourceProperty(resourcePath, PROP_CONTEXT_DEFAULT_CATALOG, (Object)defaultCatalogName);
            }
            if (!CommonUtils.isEmpty((String)(defaultSchemaName = EditorUtils.getDefaultSchemaName(context)))) {
                projectMeta.setResourceProperty(resourcePath, PROP_CONTEXT_DEFAULT_SCHEMA, (Object)defaultSchemaName);
            }
        }
    }

    private static boolean isDefaultContextSettings(DatabaseEditorContext context) {
        return context.getExecutionContext() == null && context.getSelectedObject() == null;
    }

    private static String getDefaultCatalogName(DatabaseEditorContext context) {
        DBCExecutionContext executionContext = context.getExecutionContext();
        if (executionContext != null) {
            DBSCatalog defaultCatalog;
            DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
            if (contextDefaults != null && (defaultCatalog = contextDefaults.getDefaultCatalog()) != null) {
                return defaultCatalog.getName();
            }
        } else {
            DBSCatalog selectedCatalog;
            DBSObject dBSObject = context.getSelectedObject();
            DBSCatalog catalog = dBSObject instanceof DBSCatalog ? (selectedCatalog = (DBSCatalog)dBSObject) : (DBSCatalog)DBUtils.getParentOfType(DBSCatalog.class, (DBSObject)context.getSelectedObject());
            return catalog == null ? null : catalog.getName();
        }
        return null;
    }

    private static String getDefaultSchemaName(DatabaseEditorContext context) {
        DBCExecutionContext executionContext = context.getExecutionContext();
        if (executionContext != null) {
            DBSSchema defaultSchema;
            DBCExecutionContextDefaults contextDefaults = executionContext.getContextDefaults();
            if (contextDefaults != null && (defaultSchema = contextDefaults.getDefaultSchema()) != null) {
                return defaultSchema.getName();
            }
        } else {
            DBSSchema schema = context.getSelectedObject() instanceof DBSSchema ? (DBSSchema)context.getSelectedObject() : (DBSSchema)DBUtils.getParentOfType(DBSSchema.class, (DBSObject)context.getSelectedObject());
            return schema == null ? null : schema.getName();
        }
        return null;
    }

    @Nullable
    public static IEditorPart openExternalFileEditor(@NotNull Path path, @NotNull IWorkbenchWindow window) {
        try {
            IEditorDescriptor desc = EditorUtils.getFileEditorDescriptor(path, window);
            IFileStore fileStore = EFS.getStore((URI)path.toUri());
            FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IEditorInput)input, (String)desc.getId());
        }
        catch (CoreException e) {
            log.error((Object)("Can't open editor from path '" + String.valueOf(path.toAbsolutePath())), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Path copyRemoteFileToTempDir(@NotNull Path remotePath) throws DBException {
        return (Path)UIUtils.runWithMonitor(monitor -> {
            try {
                Path tempFile = ContentUtils.makeTempFile((Path)ContentUtils.getLobFolder((DBRProgressMonitor)monitor, (DBPPlatform)DBWorkbench.getPlatform()), (String)remotePath.getFileName().toString(), (String)IOUtils.getFileExtension((Path)remotePath));
                try (InputStream is = Files.newInputStream(remotePath, new OpenOption[0]);
                     OutputStream os = Files.newOutputStream(tempFile, new OpenOption[0]);){
                    ContentUtils.copyStreams((InputStream)is, (long)Files.size(remotePath), (OutputStream)os, (DBRProgressMonitor)monitor);
                }
                return tempFile;
            }
            catch (IOException e) {
                throw new DBException("Error copying file", (Throwable)e);
            }
        });
    }

    @NotNull
    public static IEditorDescriptor getFileEditorDescriptor(@NotNull Path path, @NotNull IWorkbenchWindow window) {
        String fileName = path.getFileName().toString();
        IEditorDescriptor desc = window.getWorkbench().getEditorRegistry().getDefaultEditor(fileName);
        if (desc == null) {
            desc = window.getWorkbench().getEditorRegistry().getDefaultEditor(fileName + ".txt");
        }
        if (desc == null) {
            desc = window.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor");
        }
        return desc;
    }

    @Nullable
    public static IEditorPart openExternalFileEditor(@NotNull File file, @NotNull IWorkbenchWindow window) {
        return EditorUtils.openExternalFileEditor(file.toPath(), window);
    }

    @NotNull
    public static IEditorDescriptor getFileEditorDescriptor(@NotNull File file, @NotNull IWorkbenchWindow window) {
        return EditorUtils.getFileEditorDescriptor(file.toPath(), window);
    }

    public static boolean isInAutoSaveJob() {
        Job currentJob = Job.getJobManager().currentJob();
        if (currentJob == null) {
            return false;
        }
        return "Auto save all editors".equals(currentJob.getName());
    }

    public static void trackControlContext(IWorkbenchSite site, Control control, final String contextId) {
        final IContextService contextService = (IContextService)site.getService(IContextService.class);
        if (contextService != null) {
            final IContextActivation[] activation = new IContextActivation[1];
            FocusListener focusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    if (activation[0] != null) {
                        contextService.deactivateContext(activation[0]);
                        activation[0] = null;
                    }
                    activation[0] = contextService.activateContext(contextId);
                }

                public void focusLost(FocusEvent e) {
                    if (activation[0] != null) {
                        contextService.deactivateContext(activation[0]);
                        activation[0] = null;
                    }
                }
            };
            control.addFocusListener(focusListener);
            control.addDisposeListener(e -> {
                if (activation[0] != null) {
                    contextService.deactivateContext(activation[0]);
                    activation[0] = null;
                }
            });
        }
    }

    public static void revertEditorChanges(IEditorPart editorPart) {
        DBCExecutionContext executionContext;
        if (editorPart instanceof IRevertableEditor) {
            ((IRevertableEditor)editorPart).doRevertToSaved();
        } else if (editorPart instanceof ITextEditor) {
            ((ITextEditor)editorPart).doRevertToSaved();
        }
        if (editorPart instanceof DBPContextProvider && editorPart instanceof IDataSourceContainerUpdate && (executionContext = ((DBPContextProvider)editorPart).getExecutionContext()) != null) {
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)executionContext);
            try {
                if (txnManager != null && !txnManager.isAutoCommit()) {
                    RuntimeUtils.runTask(monitor -> {
                        try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Rollback editor transaction");){
                            txnManager.rollback(session, null);
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    }, (String)"End editor transaction", (long)5000L);
                }
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
    }

    public static void appendProjectToolTip(@NotNull StringBuilder tip, @Nullable DBPProject project) {
        if (project == null || project.getWorkspace().getProjects().size() < 2) {
            return;
        }
        if (!tip.isEmpty() && tip.charAt(tip.length() - 1) != '\n') {
            tip.append('\n');
        }
        tip.append(EditorsMessages.database_editor_project).append(": ").append(project.getName());
    }

    public static List<Path> openExternalFiles(@NotNull String[] fileNames, @Nullable DBPDataSourceContainer currentContainer) {
        log.debug((Object)("Open external file(s) [" + Arrays.toString(fileNames) + "]"));
        ArrayList<Path> openedFiles = new ArrayList<Path>();
        Stream<String> fileNameStream = Arrays.stream(fileNames);
        if (RuntimeUtils.isMacOS()) {
            fileNameStream = fileNameStream.map(fName -> fName.replaceAll(ZWNBSP, ""));
        }
        Path[] filePaths = (Path[])fileNameStream.map(x$0 -> Path.of(x$0, new String[0])).toArray(Path[]::new);
        EditorUtils.openFileEditors(filePaths, currentContainer, openedFiles, false, null);
        return openedFiles;
    }

    public static boolean openExternalFiles(@NotNull Path[] filePaths, @Nullable DBPDataSourceContainer currentContainer, boolean databaseOnly, @Nullable DBNPathBase sourceNode) {
        log.debug((Object)("Open external file(s) [" + Arrays.toString(filePaths) + "]"));
        ArrayList<Path> openedFiles = new ArrayList<Path>();
        return EditorUtils.openFileEditors(filePaths, currentContainer, openedFiles, databaseOnly, sourceNode);
    }

    @NotNull
    public static Map<FileTypeHandlerDescriptor, List<Path>> getHandlerFiles(@NotNull Path[] fileNames, @NotNull List<Path> openedFiles, boolean databaseOnly) {
        LinkedHashMap<FileTypeHandlerDescriptor, List<Path>> filesByHandler = new LinkedHashMap<FileTypeHandlerDescriptor, List<Path>>();
        for (Path path : fileNames) {
            if (IOUtils.isLocalPath((Path)path) && Files.isDirectory(path, new LinkOption[0])) {
                log.error((Object)("Can't open directory '" + String.valueOf(path) + "'"));
                continue;
            }
            if (!IOUtils.isLocalPath((Path)path) || Files.exists(path, new LinkOption[0])) {
                String fileExtension = IOUtils.getFileExtension((Path)path);
                fileExtension = fileExtension == null ? "" : fileExtension.toLowerCase();
                FileTypeHandlerDescriptor handler = FileTypeHandlerRegistry.getInstance().findHandler(fileExtension);
                if (handler != null && databaseOnly && !handler.isDatabaseHandler()) {
                    handler = null;
                }
                filesByHandler.computeIfAbsent(handler, d -> new ArrayList()).add(path);
                openedFiles.add(path);
                continue;
            }
            DBWorkbench.getPlatformUI().showError("Open file", "Can't open '" + String.valueOf(path) + "': file doesn't exist");
        }
        return filesByHandler;
    }

    @NotNull
    public static Map<FileTypeHandlerDescriptor.Extension, List<Path>> getExtensionFiles(@NotNull List<Path> fileNames, boolean databaseOnly) {
        LinkedHashMap<FileTypeHandlerDescriptor.Extension, List<Path>> filesByExtension = new LinkedHashMap<FileTypeHandlerDescriptor.Extension, List<Path>>();
        for (Path path : fileNames) {
            if (IOUtils.isLocalPath((Path)path) && Files.isDirectory(path, new LinkOption[0])) {
                log.error((Object)("Can't open directory '" + String.valueOf(path) + "'"));
                continue;
            }
            if (!IOUtils.isLocalPath((Path)path) || Files.exists(path, new LinkOption[0])) {
                FileTypeHandlerDescriptor.Extension extension;
                String fileExtension = IOUtils.getFileExtension((Path)path);
                fileExtension = fileExtension == null ? "" : fileExtension.toLowerCase();
                FileTypeHandlerDescriptor.Extension extension2 = extension = CommonUtils.isEmpty((String)fileExtension) ? null : FileTypeHandlerRegistry.getInstance().findExtension(fileExtension);
                if (extension != null && databaseOnly && !extension.getDescriptor().isDatabaseHandler()) {
                    extension = null;
                }
                if (extension == null) continue;
                filesByExtension.computeIfAbsent(extension, d -> new ArrayList()).add(path);
                continue;
            }
            DBWorkbench.getPlatformUI().showError("Open file", "Can't open '" + String.valueOf(path) + "': file doesn't exist");
        }
        return filesByExtension;
    }

    public static boolean openFileEditors(@NotNull Path[] fileNames, @Nullable DBPDataSourceContainer currentContainer, @NotNull List<Path> openedFiles, boolean databaseOnly, @Nullable DBNPathBase sourceNode) {
        Map<FileTypeHandlerDescriptor, List<Path>> filesByHandler = EditorUtils.getHandlerFiles(fileNames, openedFiles, databaseOnly);
        for (Map.Entry<FileTypeHandlerDescriptor, List<Path>> entry : filesByHandler.entrySet()) {
            FileTypeHandlerDescriptor handler = entry.getKey();
            List<Path> pathList = entry.getValue();
            boolean allRemote = pathList.stream().noneMatch(IOUtils::isLocalPath);
            try {
                Set actions;
                FileTypeAction selectedAction;
                for (int i = 0; i < pathList.size(); ++i) {
                    Path path = pathList.get(i);
                    if (IOUtils.isLocalPath((Path)path)) continue;
                    if (handler == null || Files.isDirectory(path, new LinkOption[0])) {
                        return false;
                    }
                    if (handler.supportsRemoteFiles()) continue;
                    pathList.set(i, EditorUtils.copyRemoteFileToTempDir(path));
                }
                FileOpenHandler fileOpenHandler = handler.createHandler();
                if (sourceNode != null) {
                    fileOpenHandler.setSourceNode(sourceNode);
                }
                if ((selectedAction = EditorUtils.getFileTypeActionWithDialog(actions = fileOpenHandler.supportedActions(), !allRemote)) == null) continue;
                fileOpenHandler.openFiles(pathList, currentContainer, selectedAction);
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Open file error", "Can't open file '" + String.valueOf(pathList) + "'", (Throwable)e);
            }
        }
        return true;
    }

    @Nullable
    private static FileTypeAction getFileTypeActionWithDialog(@NotNull Set<FileTypeAction> actions, boolean hasLocalFiles) {
        ArrayList<FileTypeAction> actionList = new ArrayList<FileTypeAction>(actions.stream().sorted().toList());
        if (hasLocalFiles) {
            actionList.remove(FileTypeAction.EXTERNAL_EDITOR);
        }
        FileTypeAction selectedAction = null;
        if (actionList.size() > 1 && UIUtils.getActiveWorkbenchShell() != null) {
            FileActionSelectorDialog dialog = new FileActionSelectorDialog(UIUtils.getActiveWorkbenchShell(), actionList);
            if (dialog.open() == 0) {
                selectedAction = dialog.getSelectedAction();
            }
        } else if (actionList.size() == 1) {
            selectedAction = (FileTypeAction)actionList.getFirst();
        }
        return selectedAction;
    }

    public static void activatePartContexts(IWorkbenchPart part) {
        IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        try {
            contextService.deferUpdates(true);
            ActionUtils.fireCommandRefresh((String[])new String[]{"org.jkiss.dbeaver.core.txn.autocommit"});
        }
        finally {
            contextService.deferUpdates(false);
        }
    }

    public static void deactivatePartContexts(IWorkbenchPart part) {
    }

    public static void refreshPartContexts(IWorkbenchPart part) {
        EditorUtils.deactivatePartContexts(part);
        EditorUtils.activatePartContexts(part);
    }
}

