/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueDefaultGenerator;
import org.jkiss.dbeaver.model.data.DBDValueHandlerConfigurable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class JDBCNumberValueHandler
extends JDBCAbstractValueHandler
implements DBDValueHandlerConfigurable,
DBDValueDefaultGenerator {
    private static final Log log = Log.getLog(JDBCNumberValueHandler.class);
    private final DBDFormatSettings formatSettings;
    private int useScientificNotation = -1;
    private DBDDataFormatter formatter;

    public JDBCNumberValueHandler(DBSTypedObject type, DBDFormatSettings formatSettings) {
        this.formatSettings = formatSettings;
    }

    public void refreshValueHandlerConfiguration(DBSTypedObject type) {
        this.formatter = null;
        this.useScientificNotation = -1;
    }

    @NotNull
    public synchronized String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
        if (value == null) {
            return DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)format);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number && (format == DBDDisplayFormat.NATIVE || format == DBDDisplayFormat.EDIT)) {
            if (this.useScientificNotation < 0) {
                this.useScientificNotation = this.formatSettings.isUseScientificNumericFormat() ? 1 : 0;
            }
            return DBValueFormatting.convertNumberToNativeString((Number)((Number)value), (this.useScientificNotation > 0 ? 1 : 0) != 0);
        }
        return this.getFormatter(column).formatValue(value);
    }

    private DBDDataFormatter getFormatter(@NotNull DBSTypedObject column) {
        if (this.formatter == null) {
            try {
                this.formatter = this.formatSettings.getDataFormatterProfile().createFormatter("number", column);
            }
            catch (Exception e) {
                log.error((Object)"Can't create formatter for number value handler", (Throwable)e);
                this.formatter = DefaultDataFormatter.INSTANCE;
            }
        }
        return this.formatter;
    }

    @Override
    @Nullable
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        Object value;
        switch (type.getTypeID()) {
            case 4: {
                try {
                    value = resultSet.getLong(index);
                }
                catch (ClassCastException | NumberFormatException | SQLException e) {
                    value = resultSet.getObject(index);
                }
                break;
            }
            case 5: {
                try {
                    value = resultSet.getInt(index);
                }
                catch (ClassCastException | NumberFormatException | SQLException e) {
                    value = resultSet.getObject(index);
                }
                break;
            }
            case -6: {
                try {
                    value = resultSet.getShort(index);
                }
                catch (ClassCastException | NumberFormatException | SQLException e) {
                    value = resultSet.getObject(index);
                }
                break;
            }
            case -7: {
                if (CommonUtils.toInt((Object)type.getPrecision()) <= 1) {
                    try {
                        value = resultSet.getByte(index);
                        break;
                    }
                    catch (NumberFormatException e) {
                        try {
                            boolean bValue = resultSet.getBoolean(index);
                            value = bValue ? (byte)1 : 0;
                            break;
                        }
                        catch (Throwable e1) {
                            throw e;
                        }
                    }
                }
                String bitString = CommonUtils.toBinaryString((long)resultSet.getLong(index), (int)CommonUtils.toInt((Object)type.getPrecision()));
                if (resultSet.wasNull()) {
                    return null;
                }
                return bitString;
            }
            case 6: 
            case 7: 
            case 8: {
                if (this.isReadDecimalsAsDouble()) {
                    try {
                        value = resultSet.getDouble(index);
                    }
                    catch (ClassCastException | NumberFormatException | SQLException e) {
                        value = resultSet.getObject(index);
                    }
                    break;
                }
            }
            default: {
                boolean gotValue = false;
                value = null;
                try {
                    Object objectValue = resultSet.getObject(index);
                    if (objectValue == null || objectValue instanceof Number) {
                        value = objectValue;
                        gotValue = true;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)e);
                }
                if (value != null || gotValue) break;
                try {
                    if (CommonUtils.toInt((Object)type.getScale()) > 0) {
                        value = resultSet.getDouble(index);
                        break;
                    }
                    try {
                        value = resultSet.getLong(index);
                    }
                    catch (NumberFormatException e) {
                        value = resultSet.getDouble(index);
                    }
                    break;
                }
                catch (NumberFormatException | SQLException e) {
                    return resultSet.getString(index);
                }
            }
        }
        if (resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    protected boolean isReadDecimalsAsDouble() {
        return false;
    }

    @Override
    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException, DBCException {
        if (value instanceof String) {
            String strValue = (String)value;
            Object number = DBValueFormatting.convertStringToNumber((String)strValue, this.getNumberType(paramType), (DBDDataFormatter)this.getFormatter(paramType), (boolean)true);
            if (number != null) {
                value = number;
            } else {
                if (!strValue.isEmpty()) {
                    statement.setString(paramIndex, strValue);
                    return;
                }
                statement.setNull(paramIndex, paramType.getTypeID());
                return;
            }
        }
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof Number) {
            Number number = (Number)value;
            switch (paramType.getTypeID()) {
                case -5: {
                    if (number instanceof BigInteger) {
                        statement.setBigDecimal(paramIndex, new BigDecimal((BigInteger)number));
                        break;
                    }
                    statement.setLong(paramIndex, number.longValue());
                    break;
                }
                case 6: {
                    if (number instanceof BigDecimal) {
                        statement.setBigDecimal(paramIndex, (BigDecimal)number);
                        break;
                    }
                    if (number instanceof Double) {
                        statement.setDouble(paramIndex, number.doubleValue());
                        break;
                    }
                    statement.setFloat(paramIndex, number.floatValue());
                    break;
                }
                case 7: 
                case 8: {
                    if (number instanceof BigDecimal) {
                        statement.setBigDecimal(paramIndex, (BigDecimal)number);
                        break;
                    }
                    if (number instanceof Float) {
                        statement.setFloat(paramIndex, number.floatValue());
                        break;
                    }
                    statement.setDouble(paramIndex, number.doubleValue());
                    break;
                }
                case 4: {
                    if (number instanceof Long) {
                        statement.setLong(paramIndex, number.longValue());
                        break;
                    }
                    statement.setInt(paramIndex, number.intValue());
                    break;
                }
                case -6: 
                case 5: {
                    if (number instanceof Integer) {
                        statement.setInt(paramIndex, number.intValue());
                        break;
                    }
                    if (number instanceof Long) {
                        statement.setLong(paramIndex, number.longValue());
                        break;
                    }
                    statement.setShort(paramIndex, number.shortValue());
                    break;
                }
                case -7: {
                    if (CommonUtils.toInt((Object)paramType.getPrecision()) <= 1) {
                        statement.setByte(paramIndex, number.byteValue());
                        break;
                    }
                    statement.setLong(paramIndex, number.longValue());
                    break;
                }
                case 2: 
                case 3: {
                    if (number instanceof Long) {
                        statement.setLong(paramIndex, number.longValue());
                        break;
                    }
                    if (number instanceof Integer) {
                        statement.setInt(paramIndex, number.intValue());
                        break;
                    }
                    if (number instanceof Short) {
                        statement.setShort(paramIndex, number.shortValue());
                        break;
                    }
                    if (number instanceof Byte) {
                        statement.setByte(paramIndex, number.byteValue());
                        break;
                    }
                    if (number instanceof Float) {
                        statement.setFloat(paramIndex, number.floatValue());
                        break;
                    }
                    if (number instanceof BigDecimal) {
                        statement.setBigDecimal(paramIndex, (BigDecimal)number);
                        break;
                    }
                    if (number instanceof BigInteger) {
                        statement.setBigDecimal(paramIndex, new BigDecimal((BigInteger)number));
                        break;
                    }
                    statement.setDouble(paramIndex, number.doubleValue());
                    break;
                }
                default: {
                    if (CommonUtils.toInt((Object)paramType.getScale()) > 0) {
                        statement.setDouble(paramIndex, number.doubleValue());
                        break;
                    }
                    statement.setLong(paramIndex, number.longValue());
                    break;
                }
            }
        } else {
            throw new SQLException("Numeric value type '" + value.getClass().getName() + "' is not supported");
        }
    }

    @NotNull
    public Class<? extends Number> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return this.getNumberType(attribute);
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return object;
        }
        if (object instanceof String) {
            String strValue = (String)object;
            if (strValue.isEmpty()) {
                return null;
            }
            return DBValueFormatting.convertStringToNumber((String)strValue, this.getNumberType(type), (DBDDataFormatter)this.getFormatter(type), (boolean)validateValue);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Date) {
            return DBValueFormatting.convertDateToNumber((Date)((Date)object), this.getNumberType(type), (DBDDataFormatter)this.getFormatter(type), (boolean)validateValue);
        }
        log.warn((Object)("Unrecognized type '" + object.getClass().getName() + "' - can't convert to numeric"));
        return null;
    }

    public Class<? extends Number> getNumberType(DBSTypedObject type) {
        switch (type.getTypeID()) {
            case -5: {
                return Long.class;
            }
            case 3: 
            case 7: 
            case 8: {
                if (CommonUtils.toInt((Object)type.getScale()) > 0) {
                    return Double.class;
                }
                return BigDecimal.class;
            }
            case 6: {
                if (CommonUtils.toInt((Object)type.getScale()) > 0) {
                    return Float.class;
                }
                return BigDecimal.class;
            }
            case 4: {
                return Long.class;
            }
            case 5: {
                return Integer.class;
            }
            case -6: {
                return Short.class;
            }
            case -7: {
                if (CommonUtils.toInt((Object)type.getPrecision()) <= 1) {
                    return Byte.class;
                }
                return Long.class;
            }
            case 2: {
                return BigDecimal.class;
            }
        }
        if (CommonUtils.toInt((Object)type.getScale()) > 0) {
            return Double.class;
        }
        return Long.class;
    }

    public String getDefaultValueLabel() {
        return "Zero";
    }

    public Object generateDefaultValue(DBCSession session, DBSTypedObject type) {
        switch (type.getTypeID()) {
            case -5: {
                return 0L;
            }
            case 3: 
            case 7: 
            case 8: {
                if (CommonUtils.toInt((Object)type.getScale()) > 0) {
                    return 0.0;
                }
                return new BigDecimal(0);
            }
            case 6: {
                if (CommonUtils.toInt((Object)type.getScale()) > 0) {
                    return Float.valueOf(0.0f);
                }
                return new BigDecimal(0);
            }
            case 4: {
                return 0;
            }
            case -6: 
            case 5: {
                return (short)0;
            }
            case -7: {
                if (CommonUtils.toInt((Object)type.getPrecision()) <= 1) {
                    return (byte)0;
                }
                return 0L;
            }
            case 2: {
                return new BigDecimal(0);
            }
        }
        if (CommonUtils.toInt((Object)type.getScale()) > 0) {
            return 0.0;
        }
        return 0L;
    }
}

