/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.text;

import java.util.Locale;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class TextUtils {
    public static boolean isEmptyLine(IDocument document, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        if (region == null || region.getLength() == 0) {
            return true;
        }
        String str = document.get(region.getOffset(), region.getLength());
        return str.trim().length() == 0;
    }

    public static int getOffsetOf(IDocument document, int line, String pattern) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        if (region == null || region.getLength() == 0) {
            return -1;
        }
        String str = document.get(region.getOffset(), region.getLength());
        return str.indexOf(pattern);
    }

    public static int fuzzyScore(CharSequence term, CharSequence query) {
        return TextUtils.fuzzyScore(term, query, Locale.getDefault());
    }

    public static int fuzzyScore(CharSequence term, CharSequence query, Locale locale) {
        if (term == null || query == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        String termLowerCase = term.toString().toLowerCase(locale);
        String queryLowerCase = query.toString().toLowerCase(locale);
        int score = 0;
        int termIndex = 0;
        int previousMatchingCharacterIndex = Integer.MIN_VALUE;
        int sequenceScore = 0;
        for (int queryIndex = 0; queryIndex < queryLowerCase.length(); ++queryIndex) {
            char queryChar = queryLowerCase.charAt(queryIndex);
            boolean termCharacterMatchFound = false;
            while (termIndex < termLowerCase.length()) {
                char termChar = termLowerCase.charAt(termIndex);
                if (queryChar == termChar) {
                    ++score;
                    if (termIndex == 0) {
                        score += 4;
                    } else if (!Character.isLetter(termLowerCase.charAt(termIndex - 1))) {
                        score += 2;
                    }
                    if (previousMatchingCharacterIndex + 1 == termIndex) {
                        sequenceScore = sequenceScore == 0 ? 4 : (sequenceScore *= 2);
                        score += sequenceScore;
                    } else {
                        sequenceScore = 0;
                    }
                    previousMatchingCharacterIndex = termIndex++;
                    termCharacterMatchFound = true;
                    break;
                }
                ++termIndex;
            }
            if (termCharacterMatchFound) continue;
            return 0;
        }
        return score;
    }
}

