/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format.external;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArgumentTokenizer;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SQLFormatterExternal
implements SQLFormatter {
    public static final String FORMATTER_ID = "EXTERNAL";
    private static final Log log = Log.getLog(SQLFormatterExternal.class);
    public static final String VAR_FILE = "file";

    @Override
    public String format(String source, SQLFormatterConfiguration configuration) {
        DBPPreferenceStore store = configuration.getSyntaxManager().getPreferenceStore();
        String command = store.getString("sql.format.external.cmd");
        int timeout = store.getInt("sql.format.external.timeout");
        boolean useFile = store.getBoolean("sql.format.external.file");
        if (CommonUtils.isEmpty((String)command)) {
            return source;
        }
        try {
            FormatJob formatJob = new FormatJob(configuration, command, source, useFile);
            formatJob.schedule();
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(timeout / 10);
                if (!formatJob.finished) continue;
                return formatJob.result;
            }
            log.warn((Object)"Formatter process hangs. Terminating.");
            formatJob.stop();
        }
        catch (Exception ex) {
            log.warn((Object)("Error executing external formatter [" + command + "]"), (Throwable)ex);
        }
        return source;
    }

    private static class FormatJob
    extends AbstractJob {
        SQLFormatterConfiguration configuration;
        String command;
        Process process;
        String source;
        boolean useFile;
        String result = "";
        public boolean finished;

        public FormatJob(SQLFormatterConfiguration configuration, String command, String source, boolean useFile) {
            super("External format - " + command);
            this.command = command;
            this.configuration = configuration;
            this.source = source;
            this.useFile = useFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            String sourceEncoding = this.configuration.getSourceEncoding();
            File tmpFile = null;
            try {
                if (CommonUtils.isEmpty((String)this.command)) {
                    throw new IOException("No command specified for external formatter");
                }
                if (this.useFile) {
                    tmpFile = File.createTempFile("dbeaver-sql-format", "sql");
                    try (FileOutputStream os = new FileOutputStream(tmpFile);
                         OutputStreamWriter out = new OutputStreamWriter((OutputStream)os, sourceEncoding);){
                        IOUtils.copyText((Reader)new StringReader(this.source), (Writer)out);
                    }
                    this.command = this.command.replace(GeneralUtils.variablePattern((String)SQLFormatterExternal.VAR_FILE), tmpFile.getAbsolutePath());
                }
                List commandList = ArgumentTokenizer.tokenize((String)this.command, (boolean)false);
                ProcessBuilder pb = new ProcessBuilder(commandList);
                pb.redirectErrorStream(true);
                this.process = pb.start();
                try {
                    if (tmpFile == null) {
                        try (OutputStream stdout = this.process.getOutputStream();){
                            stdout.write(this.source.getBytes(sourceEncoding));
                        }
                    }
                    StringWriter buf = new StringWriter();
                    try (InputStreamReader input = new InputStreamReader(this.process.getInputStream(), sourceEncoding);){
                        IOUtils.copyText((Reader)input, (Writer)buf);
                    }
                    int rc = this.process.waitFor();
                    if (rc != 0) {
                        log.debug((Object)("Formatter result code: " + rc));
                    }
                    this.result = buf.toString();
                }
                finally {
                    this.process.destroy();
                }
            }
            catch (Exception e) {
                this.result = this.source;
                this.finished = true;
                IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                return iStatus;
            }
            finally {
                if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                    log.debug((Object)("Can't delete temp file '" + tmpFile.getAbsolutePath() + "'"));
                }
            }
            this.finished = true;
            return Status.OK_STATUS;
        }

        void stop() {
            if (this.process != null) {
                this.process.destroy();
            }
        }
    }
}

