/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProcessor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseProducerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferProducer;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataContainerOptions;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.handler.CopyAsConfigurationDialog;
import org.jkiss.dbeaver.ui.controls.resultset.handler.CopyAsConfigurationStorage;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;

public class ResultSetHandlerCopyAs
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(ResultSetHandlerCopyAs.class);
    public static final String CMD_COPY_AS = "org.jkiss.dbeaver.core.resultset.copyAs";
    public static final String PARAM_PROCESSOR_ID = "processorId";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (ApplicationPolicyProvider.getInstance().isPolicyEnabled("policy.data.copy.disabled")) {
            UIUtils.showMessageBox((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)UIMessages.dialog_policy_data_copy_title, (String)UIMessages.dialog_policy_data_copy_msg, (int)8);
            return null;
        }
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet(HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        DataTransferProcessorDescriptor processor = ResultSetHandlerCopyAs.getActiveProcessor(event.getParameter(PARAM_PROCESSOR_ID));
        if (processor == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.core.resultset.copyAs": {
                ResultSetHandlerCopyAs.openResultsWith(resultSet, processor);
            }
        }
        return null;
    }

    static DataTransferProcessorDescriptor getActiveProcessor(String processorId) {
        if (CommonUtils.isEmpty((String)processorId)) {
            return null;
        }
        return DataTransferRegistry.getInstance().getProcessor(processorId);
    }

    private static void openResultsWith(final IResultSetController resultSet, final DataTransferProcessorDescriptor processor) {
        ResultSetDataContainer dataContainer;
        final ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
        IResultSetSelection rsSelection = resultSet.getSelection();
        List<ResultSetRow> rsSelectedRows = rsSelection.getSelectedRows();
        List<DBDAttributeBinding> rsSelectedAttributes = rsSelection.getSelectedAttributes();
        if (rsSelectedRows.size() > 1 || rsSelectedAttributes.size() > 1) {
            ArrayList<Integer> selectedRows = new ArrayList<Integer>();
            for (ResultSetRow selectedRow : rsSelectedRows) {
                selectedRows.add(selectedRow.getRowNumber());
            }
            options.setSelectedRows(selectedRows);
            options.setSelectedColumns(rsSelectedAttributes);
        }
        if ((dataContainer = new ResultSetDataContainer(resultSet, options)).getDataSource() == null) {
            DBWorkbench.getPlatformUI().showError("Copy as " + processor.getName(), ModelMessages.error_not_connected_to_database);
            return;
        }
        AbstractJob exportJob = new AbstractJob("Copy as " + processor.getName()){
            {
                super(arg0);
                this.setUser(true);
                this.setSystem(false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                monitor.beginTask("Copy data as", 3);
                try {
                    boolean selectedColumnsOnly;
                    UIServiceSQL serviceSQL;
                    monitor.subTask("Init");
                    IDataTransferProcessor processorInstance = processor.getInstance();
                    if (!(processorInstance instanceof IStreamDataExporter)) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IStreamDataExporter exporter = (IStreamDataExporter)processorInstance;
                    StreamTransferConsumer consumer = new StreamTransferConsumer();
                    StreamConsumerSettings settings = new StreamConsumerSettings();
                    settings.setOutputClipboard(true);
                    settings.setOutputEncodingBOM(false);
                    Map<DataTransferProcessorDescriptor, Map<String, Object>> propertiesMap = CopyAsConfigurationStorage.getProcessorProperties();
                    Map<String, Object> properties = propertiesMap.get(processor);
                    if (properties == null) {
                        properties = new HashMap<String, Object>();
                        for (DBPPropertyDescriptor prop : processor.getProperties()) {
                            properties.put(prop.getId(), prop.getDefaultValue());
                        }
                    }
                    properties.put("data.manipulate.useCurrentDialect", true);
                    consumer.initTransfer((DBSObject)dataContainer, settings, new IDataTransferConsumer.TransferParameters(processor.isBinaryFormat(), processor.isHTMLFormat()), exporter, properties, null);
                    DBDDataFilter dataFilter = resultSet.getModel().getDataFilter();
                    DatabaseTransferProducer producer = new DatabaseTransferProducer((DBSDataContainer)dataContainer, dataFilter);
                    DatabaseProducerSettings producerSettings = new DatabaseProducerSettings();
                    producerSettings.setOpenNewConnections(false);
                    if (resultSet.isHasMoreData() && (serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class)) != null) {
                        producerSettings.setOpenNewConnections(serviceSQL.useIsolatedConnections((DBPContextProvider)resultSet));
                    }
                    producerSettings.setExtractType(DatabaseProducerSettings.ExtractType.SINGLE_QUERY);
                    producerSettings.setQueryRowCount(false);
                    boolean selectedRowsOnly = !CommonUtils.isEmpty(options.getSelectedRows());
                    boolean bl = selectedColumnsOnly = !CommonUtils.isEmpty(options.getSelectedColumns());
                    if (selectedRowsOnly || selectedColumnsOnly) {
                        producerSettings.setFetchedRowsPolicy(new DatabaseProducerSettings.FetchedRowsPolicy(selectedRowsOnly, selectedColumnsOnly));
                    } else {
                        producerSettings.setFetchedRowsPolicy(null);
                    }
                    monitor.worked(1);
                    monitor.subTask("Export data");
                    producer.transferData(monitor, (IDataTransferConsumer)consumer, null, producerSettings, null);
                    monitor.worked(1);
                    monitor.subTask("Finalize export");
                    consumer.finishTransfer(monitor, false);
                    consumer.finishTransfer(monitor, true);
                    monitor.worked(1);
                }
                catch (Exception e) {
                    DBWorkbench.getPlatformUI().showError("Error opening in " + processor.getAppName(), null, (Throwable)e);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        exportJob.schedule();
    }

    public void updateElement(UIElement element, Map parameters) {
        DataTransferProcessorDescriptor processor = ResultSetHandlerCopyAs.getActiveProcessor((String)parameters.get(PARAM_PROCESSOR_ID));
        if (processor != null) {
            String commandName = ActionUtils.findCommandName((String)CMD_COPY_AS);
            element.setText(commandName + " " + processor.getName());
            if (!CommonUtils.isEmpty((String)processor.getDescription())) {
                element.setTooltip(processor.getDescription());
            }
            if (processor.getIcon() != null) {
                element.setIcon(DBeaverIcons.getImageDescriptor((DBPImage)processor.getIcon()));
            }
        }
    }

    public static void fillCopyAsMenu(final ResultSetViewer viewer, IContributionManager copyAsMenu) {
        IWorkbenchPartSite site = viewer.getSite();
        copyAsMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)site, (String)"org.jkiss.dbeaver.core.edit.copy.special"));
        copyAsMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyColumnNames"));
        copyAsMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)site, (String)"org.jkiss.dbeaver.core.resultset.grid.copyRowNames"));
        copyAsMenu.add((IContributionItem)new Separator());
        ResultSetDataContainerOptions options = new ResultSetDataContainerOptions();
        ResultSetDataContainer dataContainer = new ResultSetDataContainer(viewer, options);
        ArrayList<DataTransferProcessorDescriptor> appProcessors = new ArrayList<DataTransferProcessorDescriptor>();
        for (DataTransferNodeDescriptor consumerNode : DataTransferRegistry.getInstance().getAvailableConsumers(Collections.singleton(dataContainer))) {
            for (DataTransferProcessorDescriptor processor : consumerNode.getProcessors()) {
                if (processor.isBinaryFormat()) continue;
                appProcessors.add(processor);
            }
        }
        appProcessors.sort(Comparator.comparing(DataTransferProcessorDescriptor::getName));
        for (DataTransferProcessorDescriptor processor : appProcessors) {
            CommandContributionItemParameter params = new CommandContributionItemParameter((IServiceLocator)site, processor.getId(), CMD_COPY_AS, 8);
            params.label = processor.getName();
            if (processor.getIcon() != null) {
                params.icon = DBeaverIcons.getImageDescriptor((DBPImage)processor.getIcon());
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(PARAM_PROCESSOR_ID, processor.getFullId());
            params.parameters = parameters;
            copyAsMenu.add((IContributionItem)new CommandContributionItem(params));
        }
        copyAsMenu.add((IContributionItem)new Separator());
        copyAsMenu.add((IAction)new Action(ResultSetMessages.dialog_copy_as_configuration_name){

            public void run() {
                new CopyAsConfigurationDialog(viewer).open();
            }
        });
    }

    public static class CopyAsMenuContributor
    extends CompoundContributionItem {
        protected IContributionItem[] getContributionItems() {
            ResultSetViewer rsv = (ResultSetViewer)ResultSetHandlerMain.getActiveResultSet(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart());
            if (rsv == null) {
                return new IContributionItem[0];
            }
            MenuManager menu = new MenuManager();
            ResultSetHandlerCopyAs.fillCopyAsMenu(rsv, (IContributionManager)menu);
            return menu.getItems();
        }
    }

    public static class CopyAsParameterValues
    implements IParameterValues {
        public Map<String, String> getParameterValues() {
            HashMap<String, String> values = new HashMap<String, String>();
            for (DataTransferNodeDescriptor consumerNode : DataTransferRegistry.getInstance().getNodes(DataTransferNodeDescriptor.NodeType.CONSUMER)) {
                for (DataTransferProcessorDescriptor processor : consumerNode.getProcessors()) {
                    if (processor.isBinaryFormat()) continue;
                    values.put(processor.getName(), processor.getFullId());
                }
            }
            return values;
        }
    }
}

