/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;

public class Cursors {
    public static final Cursor ARROW = SystemCursorFactory.getCursor(0);
    public static final Cursor SIZEN = SystemCursorFactory.getCursor(10);
    public static final Cursor SIZENE = SystemCursorFactory.getCursor(14);
    public static final Cursor SIZEE = SystemCursorFactory.getCursor(12);
    public static final Cursor SIZESE = SystemCursorFactory.getCursor(15);
    public static final Cursor SIZES = SystemCursorFactory.getCursor(11);
    public static final Cursor SIZESW = SystemCursorFactory.getCursor(16);
    public static final Cursor SIZEW = SystemCursorFactory.getCursor(13);
    public static final Cursor SIZENW = SystemCursorFactory.getCursor(17);
    public static final Cursor APPSTARTING;
    public static final Cursor CROSS;
    public static final Cursor HAND;
    public static final Cursor HELP;
    public static final Cursor IBEAM;
    public static final Cursor NO;
    public static final Cursor SIZEALL;
    public static final Cursor SIZENESW;
    public static final Cursor SIZENWSE;
    public static final Cursor SIZEWE;
    public static final Cursor SIZENS;
    public static final Cursor UPARROW;
    public static final Cursor WAIT;

    static {
        SIZENS = SystemCursorFactory.getCursor(7);
        SIZEWE = SystemCursorFactory.getCursor(9);
        APPSTARTING = SystemCursorFactory.getCursor(3);
        CROSS = SystemCursorFactory.getCursor(2);
        HAND = SystemCursorFactory.getCursor(21);
        HELP = SystemCursorFactory.getCursor(4);
        IBEAM = SystemCursorFactory.getCursor(19);
        NO = SystemCursorFactory.getCursor(20);
        SIZEALL = SystemCursorFactory.getCursor(5);
        SIZENESW = SystemCursorFactory.getCursor(6);
        SIZENWSE = SystemCursorFactory.getCursor(8);
        UPARROW = SystemCursorFactory.getCursor(18);
        WAIT = SystemCursorFactory.getCursor(1);
    }

    public static Cursor getDirectionalCursor(int direction) {
        return Cursors.getDirectionalCursor(direction, false);
    }

    public static Cursor getDirectionalCursor(int direction, boolean isMirrored) {
        if (isMirrored && (direction & 0x18) != 0) {
            direction ^= 0x18;
        }
        switch (direction) {
            case 1: {
                return SIZEN;
            }
            case 4: {
                return SIZES;
            }
            case 16: {
                return SIZEE;
            }
            case 8: {
                return SIZEW;
            }
            case 20: {
                return SIZESE;
            }
            case 12: {
                return SIZESW;
            }
            case 17: {
                return SIZENE;
            }
            case 9: {
                return SIZENW;
            }
        }
        return null;
    }

    private static class SystemCursorFactory {
        private SystemCursorFactory() {
        }

        public static Cursor getCursor(int which) {
            Display display = Display.getCurrent();
            if (display != null) {
                return display.getSystemCursor(which);
            }
            display = Display.getDefault();
            return (Cursor)display.syncCall(() -> Display.getCurrent().getSystemCursor(which));
        }
    }
}

