/*
 * Copyright (c) 2021, NVIDIA CORPORATION. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#ifndef NVFS_BATCH_H
#define NVFS_BATCH_H

#include "nvfs-core.h"
#include "nvfs-mmap.h"

#define NVFS_MAX_BATCH_ENTRIES 256 

typedef struct {
   uint64_t ctx_id;
   ktime_t start_io;		// Start time of IO for latency calculation
   uint64_t nents;
   nvfs_io_t *nvfsio[NVFS_MAX_BATCH_ENTRIES]; 
} nvfs_batch_io_t;

nvfs_batch_io_t* nvfs_io_batch_init(nvfs_ioctl_param_union *input_param);
long nvfs_io_batch_submit(nvfs_batch_io_t *nvfs_batch);
#endif
