/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ClassPool {
    private final Map classes = new TreeMap();

    public void clear() {
        this.classes.clear();
    }

    public void addClass(Clazz clazz) {
        this.classes.put(clazz.getName(), clazz);
    }

    public void removeClass(Clazz clazz) {
        this.removeClass(clazz.getName());
    }

    public void removeClass(String className) {
        this.classes.remove(className);
    }

    public Clazz getClass(String className) {
        return (Clazz)this.classes.get(className);
    }

    public Iterator classNames() {
        return this.classes.keySet().iterator();
    }

    public int size() {
        return this.classes.size();
    }

    public void accept(ClassPoolVisitor classPoolVisitor) {
        classPoolVisitor.visitClassPool(this);
    }

    public void classesAccept(ClassVisitor classVisitor) {
        for (Clazz clazz : this.classes.values()) {
            clazz.accept(classVisitor);
        }
    }

    public void classesAcceptAlphabetically(ClassVisitor classVisitor) {
        for (Clazz clazz : this.classes.values()) {
            clazz.accept(classVisitor);
        }
    }

    public void classesAccept(String classNameFilter, ClassVisitor classVisitor) {
        this.classesAccept(new ListParser(new ClassNameParser()).parse(classNameFilter), classVisitor);
    }

    public void classesAccept(List classNameFilter, ClassVisitor classVisitor) {
        this.classesAccept(new ListParser(new ClassNameParser()).parse(classNameFilter), classVisitor);
    }

    public void classesAccept(StringMatcher classNameFilter, ClassVisitor classVisitor) {
        for (Map.Entry entry : this.classes.entrySet()) {
            String className = (String)entry.getKey();
            if (!classNameFilter.matches(className)) continue;
            Clazz clazz = (Clazz)entry.getValue();
            clazz.accept(classVisitor);
        }
    }

    public void classAccept(String className, ClassVisitor classVisitor) {
        Clazz clazz = this.getClass(className);
        if (clazz != null) {
            clazz.accept(classVisitor);
        }
    }
}

