﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/MLTransform.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {
class GetMLTransformsResult {
 public:
  AWS_GLUE_API GetMLTransformsResult() = default;
  AWS_GLUE_API GetMLTransformsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUE_API GetMLTransformsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of machine learning transforms.</p>
   */
  inline const Aws::Vector<MLTransform>& GetTransforms() const { return m_transforms; }
  template <typename TransformsT = Aws::Vector<MLTransform>>
  void SetTransforms(TransformsT&& value) {
    m_transformsHasBeenSet = true;
    m_transforms = std::forward<TransformsT>(value);
  }
  template <typename TransformsT = Aws::Vector<MLTransform>>
  GetMLTransformsResult& WithTransforms(TransformsT&& value) {
    SetTransforms(std::forward<TransformsT>(value));
    return *this;
  }
  template <typename TransformsT = MLTransform>
  GetMLTransformsResult& AddTransforms(TransformsT&& value) {
    m_transformsHasBeenSet = true;
    m_transforms.emplace_back(std::forward<TransformsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A pagination token, if more results are available.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  GetMLTransformsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetMLTransformsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<MLTransform> m_transforms;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_transformsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
